/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IDeleteOperationProvider;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IModelTransformationStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IPatternConformityStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.ModelTransformationStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.PatternConformityStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.SimpleStatus;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.Messages;
import org.eclipse.emf.diffmerge.patterns.templates.engine.NamingUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternApplicationScope;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternComparison;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternContentScope;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternDiffPolicy;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternMatchPolicy;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternMergePolicy;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.gen.TemplatePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.util.ModelImplUtil;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatePatternApplicationComparison
extends TemplatePatternComparison {
    private final IPatternApplication _application;
    private TemplatePatternMatchPolicy _matchPolicy;
    private final TemplatePatternDiffPolicy _diffPolicy;
    private final TemplatePatternMergePolicy _mergePolicy;
    private List<String> _multiparts;
    private Iterator<String> _multipartsIterator;
    private String _currentMultipart;

    public TemplatePatternApplicationComparison(TemplatePattern pattern_p, IPatternApplication application_p, List<EStructuralFeature> ignoredFeatures_p) {
        this(pattern_p, application_p, ignoredFeatures_p, null);
    }

    public TemplatePatternApplicationComparison(TemplatePattern pattern_p, IPatternApplication application_p, List<EStructuralFeature> ignoredFeatures_p, String multipart_p) {
        this(pattern_p, new TemplatePatternApplicationScope(application_p, multipart_p), ignoredFeatures_p);
    }

    public TemplatePatternApplicationComparison(TemplatePattern pattern_p, TemplatePatternApplicationScope applicationScope_p, List<EStructuralFeature> ignoredFeatures_p) {
        super(pattern_p, (IEditableModelScope)new TemplatePatternContentScope(pattern_p), (IEditableModelScope)applicationScope_p);
        this._application = applicationScope_p.getApplication();
        this._matchPolicy = new TemplatePatternMatchPolicy(this, AdapterFactoryEditingDomain.getEditingDomainFor((EObject)pattern_p), AdapterFactoryEditingDomain.getEditingDomainFor((Object)applicationScope_p.getApplication().getScopeElement()));
        this._diffPolicy = new TemplatePatternDiffPolicy(ignoredFeatures_p);
        this._mergePolicy = new TemplatePatternMergePolicy();
        this._currentMultipart = applicationScope_p.getMultipart();
        this._multiparts = null;
        this._multipartsIterator = null;
        TemplatePatternData data = this.getPatternData();
        if (this._currentMultipart == null && data != null) {
            this._multiparts = new UniqueEList((Collection)data.getMultiparts());
            this._multipartsIterator = this._multiparts.iterator();
        }
        ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(this._application.getScopeElement());
        ruleProvider.initializeTargetScope((IFeaturedModelScope)this.getScope(TemplatePatternApplicationComparison.getPatternRole()), (IFeaturedModelScope)this.getScope(TemplatePatternApplicationComparison.getApplicationRole()));
    }

    public IPatternConformityStatus checkConformity() {
        IStatus status = null;
        PatternConformityStatus result = new PatternConformityStatus(0, 0);
        do {
            if (this.hasMultiparts()) {
                this.setCurrentMultipart(this._multipartsIterator.next());
            }
            status = this.compute();
            int allPresences = this.getRemainingDifferences().size();
            int patternPresences = this.getPresencesInPattern().size();
            result.addMissingValues(patternPresences);
            result.addExtraValues(allPresences - patternPresences);
        } while (this.hasNextMultipart() && (status == null || status.isOK()));
        result.freeze();
        return result;
    }

    public IStatus compute() {
        IStatus result = this.compute((IMatchPolicy)this._matchPolicy, (IDiffPolicy)this._diffPolicy, (IMergePolicy)this._mergePolicy, null);
        return result;
    }

    private SimpleStatus createFailureStatus(IStatus status_p) {
        return new SimpleStatus(false, String.valueOf(Messages.TemplatePatternComparison_FailureAnnouncement) + status_p.getMessage());
    }

    public void extendPatternData() {
        TemplatePatternData data = this.getPatternData();
        if (data != null) {
            Collection<IMatch> updatedMatches = this.getLastUpdatedMatches();
            for (IMatch match : updatedMatches) {
                EObject instanceElement = match.get(TemplatePatternApplicationComparison.getApplicationRole());
                EObject templateElement = match.get(TemplatePatternApplicationComparison.getPatternRole());
                String mappingMultipart = this.getMainMultipart();
                if (!this.getPattern().isUnique(templateElement) && this.getCurrentMultipart() != null) {
                    mappingMultipart = this.getCurrentMultipart();
                }
                data.map(instanceElement, templateElement, mappingMultipart);
                data.markAsUnfolded(instanceElement);
            }
        }
    }

    public static Role getApplicationRole() {
        return TemplatePatternApplicationComparison.getPatternRole().opposite();
    }

    protected TemplatePatternApplicationScope getApplicationScope() {
        return (TemplatePatternApplicationScope)this.getScope(TemplatePatternApplicationComparison.getApplicationRole());
    }

    public String getCurrentMultipart() {
        return this._currentMultipart;
    }

    public String getMainMultipart() {
        return TemplatePatternsPlugin.getDefault().getEngine().getMainMultipart();
    }

    private String getMultipartSuffix() {
        String result = null;
        String multipart = this.getCurrentMultipart();
        if (multipart != null && !this.getMainMultipart().equals(multipart)) {
            int position = this._multiparts.indexOf(multipart) + 1;
            result = " " + String.valueOf(position);
        }
        return result;
    }

    public TemplatePatternData getPatternData() {
        return TemplatePatternsUtil.getPatternData(this._application);
    }

    private List<IDifference> getPresencesInPattern() {
        return this.getDifferences(TemplatePatternApplicationComparison.getPatternRole());
    }

    private TemplatePatternRole getRoleOf(EObject element_p) {
        if (element_p != null) {
            for (TemplatePatternRole role : this.getPattern().getRoles()) {
                if (!role.getTemplateElements().contains((Object)element_p)) continue;
                return role;
            }
        }
        return null;
    }

    public boolean hasMultiparts() {
        return this._multipartsIterator != null && !this._multiparts.isEmpty();
    }

    public void setCurrentMultipart(String multipart_p) {
        this.clear();
        this._currentMultipart = multipart_p;
        this.getApplicationScope().setMultipart(this._currentMultipart);
    }

    private void storeRootWithRole(EObject root_p) {
        IReferenceLocation refLocation;
        ILocation location;
        IMatch match = this.getMapping().getMatchFor(root_p, TemplatePatternApplicationComparison.getApplicationRole());
        EObject original = match.get(TemplatePatternApplicationComparison.getPatternRole());
        TemplatePatternRole role = this.getRoleOf(original);
        if (role != null && role.acceptsAddition() && (location = this._application.getLocation((IPatternRole)role)) instanceof IReferenceLocation && (refLocation = (IReferenceLocation)location).getReference().isContainment()) {
            LocationsUtil.add((IReferenceLocation)refLocation, (EObject)root_p);
        }
    }

    public IModelTransformationStatus updateApplication(boolean destructive_p) {
        SimpleStatus result;
        IStatus status = null;
        boolean hadDifferences = false;
        FOrderedSet additions = new FOrderedSet();
        FOrderedSet merges = new FOrderedSet();
        int nbCandidateChanges = 0;
        int nbChangesMade = 0;
        do {
            List<IDifference> presencesInPattern;
            if (this.hasMultiparts()) {
                this.setCurrentMultipart(this._multipartsIterator.next());
            }
            status = this.compute();
            List<IDifference> list = presencesInPattern = destructive_p ? this.getRemainingDifferences() : this.getPresencesInPattern();
            if (presencesInPattern.isEmpty()) continue;
            hadDifferences = true;
            merges.clear();
            nbCandidateChanges += this.getNbDifferences();
            boolean stepSuccessful = this.updateModelStep(destructive_p, (Collection<EObject>)additions, (Collection<IDifference>)merges);
            nbChangesMade += merges.size();
            if (stepSuccessful) {
                this.extendPatternData();
                continue;
            }
            status = Status.CANCEL_STATUS;
        } while (this.hasNextMultipart() && (status == null || status.isOK()));
        Collection<EObject> toDelete = this.getApplicationScope().getDeletedElements();
        if (!toDelete.isEmpty()) {
            IDeleteOperationProvider deleteProvider = CorePatternsPlugin.getDefault().getDeleteOperationProvider();
            IModelOperation op = deleteProvider.getDeleteOperation(toDelete, true, true, toDelete);
            CorePatternsPlugin.getDefault().getModelEnvironment().execute(op);
        }
        ISemanticRuleProvider ruleProvider = null;
        if (this._application.getScopeElement() != null) {
            ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(this._application.getScopeElement());
            ruleProvider.postPatternApplication(this._application, (Collection<EObject>)additions, (Collection<IDifference>)merges);
        }
        if (status.isOK()) {
            if (hadDifferences) {
                ModelTransformationStatus mts = new ModelTransformationStatus(true, false, "", true);
                mts.getAddedElements().addAll(additions);
                mts.getDeletedElements().addAll(this.getApplicationScope().getDeletedElements());
                mts.setNbCandidateChanges(nbCandidateChanges);
                mts.setNbChangesMade(nbChangesMade);
                mts.freeze();
                result = mts;
            } else {
                result = new SimpleStatus(true, Messages.TemplatePatternEngine_AlreadyConforms);
            }
        } else if (status.matches(8)) {
            ModelTransformationStatus mtStatus = new ModelTransformationStatus(false, false, "", true);
            mtStatus.setAborted(true);
            mtStatus.freeze();
            result = mtStatus;
        } else {
            result = this.createFailureStatus(status);
        }
        return result;
    }

    private boolean hasNextMultipart() {
        return this._multipartsIterator != null && this._multipartsIterator.hasNext();
    }

    private boolean updateModelStep(boolean destructive_p, Collection<EObject> additions_p, Collection<IDifference> merges_p) {
        boolean result = true;
        List<IDifference> initialDifferences = destructive_p ? this.getRemainingDifferences() : this.getPresencesInPattern();
        Collection<IDifference> mergedDifferences = this.merge(initialDifferences, TemplatePatternApplicationComparison.getApplicationRole(), true, null);
        merges_p.addAll(mergedDifferences);
        FOrderedSet unstored = new FOrderedSet();
        ISemanticRuleProvider ruleProvider = null;
        if (this._application.getScopeElement() != null) {
            ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(this._application.getScopeElement());
        }
        for (EObject root : this.getScope(TemplatePatternApplicationComparison.getApplicationRole()).getContents()) {
            if (ruleProvider == null || ruleProvider.isAllowedToBeRoot(root)) continue;
            if (root.eContainer() == null) {
                this.storeRootWithRole(root);
            }
            if (root.eContainer() != null) continue;
            unstored.add(root);
        }
        if (!unstored.isEmpty()) {
            Object context = this._application.getScopeElement();
            ISemanticRuleProvider semanticRuleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(context);
            Boolean enforcementResult = semanticRuleProvider.enforceOwnership((Collection<? extends EObject>)unstored, context);
            boolean bl = result = enforcementResult != null && enforcementResult != false;
        }
        if (result) {
            String suffix = this.getMultipartSuffix();
            for (IMatch addMatch : this.getMapping().getCompletedMatches(TemplatePatternApplicationComparison.getApplicationRole())) {
                String name;
                EObject added = addMatch.get(TemplatePatternApplicationComparison.getApplicationRole());
                ModelImplUtil.setXMLID((EObject)added, (String)EcoreUtil.getID((EObject)added));
                additions_p.add(added);
                if (suffix == null || (name = NamingUtil.getName(added)) == null) continue;
                NamingUtil.setName(added, String.valueOf(name) + suffix);
            }
        }
        return result;
    }
}

