/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.diffdata.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.diffdata.DiffdataPackage;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.diffdata.EReferenceValuePresence;
import org.eclipse.emf.diffmerge.diffdata.impl.EValuePresenceImpl;
import org.eclipse.emf.diffmerge.impl.helpers.BidirectionalComparisonCopier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class EReferenceValuePresenceImpl
extends EValuePresenceImpl
implements EReferenceValuePresence {
    protected EMatch value;

    protected EReferenceValuePresenceImpl() {
    }

    public EReferenceValuePresenceImpl(EComparison comparison_p, EMatch elementMatch_p, EReference reference_p, EMatch value_p, Role presenceRole_p, boolean isOrder_p) {
        super(comparison_p, elementMatch_p, (EStructuralFeature)reference_p, presenceRole_p, isOrder_p);
        this.value = value_p;
        this.elementMatch.addRelatedDifference(this);
    }

    protected EClass eStaticClass() {
        return DiffdataPackage.Literals.EREFERENCE_VALUE_PRESENCE;
    }

    public EMatch getValue() {
        if (this.value != null && this.value.eIsProxy()) {
            InternalEObject oldValue = (InternalEObject)this.value;
            this.value = (EMatch)this.eResolveProxy(oldValue);
            if (this.value != oldValue && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 13, (Object)oldValue, (Object)this.value));
            }
        }
        return this.value;
    }

    public EReference getFeature() {
        return (EReference)super.getFeature();
    }

    public EMatch basicGetValue() {
        return this.value;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 13: {
                if (resolve) {
                    return this.getValue();
                }
                return this.basicGetValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 13: {
                return this.value != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public IReferenceValuePresence getOpposite() {
        IReferenceValuePresence result = null;
        EReference opposite = this.getFeature().getEOpposite();
        if (opposite != null) {
            result = this.getValue().getReferenceValueDifference(opposite, this.getElementMatch());
        }
        return result;
    }

    public IReferenceValuePresence getSymmetrical() {
        IReferenceValuePresence result = null;
        if (!this.getFeature().isMany()) {
            Collection candidates = this.getElementMatch().getReferenceDifferences(this.getFeature());
            assert (candidates.size() <= 2);
            for (IReferenceValuePresence candidate : candidates) {
                if (candidate.getPresenceRole() != this.getAbsenceRole()) continue;
                result = candidate;
                break;
            }
        } else if (this.isOrder()) {
            result = (IReferenceValuePresence)this.getElementMatch().getOrderDifference((EStructuralFeature)this.getFeature(), this.getAbsenceRole());
        }
        return result;
    }

    public IReferenceValuePresence getSymmetricalOwnership() {
        IReferenceValuePresence result = this.getValue().getOwnershipDifference(this.getAbsenceRole());
        return result;
    }

    protected boolean hasStrongerOpposite() {
        EReference ref;
        boolean result = false;
        EReference ownfeature = this.getFeature();
        if (ownfeature instanceof EReference && (ref = ownfeature).isMany()) {
            EReference opposite = ref.getEOpposite();
            result = opposite != null && !opposite.isMany();
        }
        return result;
    }

    public boolean isOppositeOf(IReferenceValuePresence peer_p) {
        return this.getPresenceRole() == peer_p.getPresenceRole() && this.getFeature().getEOpposite() == peer_p.getFeature() && this.getElementMatch() == peer_p.getValue() && this.getValue() == peer_p.getElementMatch();
    }

    public boolean isUnrelatedToContainmentTree() {
        return !this.getFeature().isContainment() || this.isOrder();
    }

    public boolean isSymmetricalOwnershipTo(IReferenceValuePresence peer_p) {
        return this.getAbsenceRole() == peer_p.getPresenceRole() && this.getFeature().isContainment() && peer_p.getFeature().isContainment() && this.getValue() == peer_p.getValue();
    }

    protected void mergeOrder() {
        EObject sourceHolder = this.getHolder();
        EObject destinationHolder = this.getMatchOfHolder();
        EReference reference = this.getFeature();
        assert (sourceHolder != null && destinationHolder != null);
        assert (this.getFeature() != null);
        IEditableModelScope absenceScope = this.getAbsenceScope();
        IMergePolicy mergePolicy = this.getComparison().getLastMergePolicy();
        Role destination = this.getAbsenceRole();
        EMatch holderMatch = this.getElementMatch();
        EComparison owningComparison = this.getComparison();
        List<EObject> sourceValues = this.getPresenceScope().get(sourceHolder, reference);
        int i = sourceValues.size() - 1;
        while (i >= 0) {
            int index;
            EObject destinationValue;
            EObject sourceValue = sourceValues.get(i);
            IMatch valueMatch = owningComparison.getMapping().getMatchFor(sourceValue, destination.opposite());
            if (valueMatch != null && (destinationValue = valueMatch.get(destination)) != null && (index = mergePolicy.getDesiredValuePosition(owningComparison, destination, holderMatch, reference, valueMatch)) >= 0) {
                List<EObject> updatedDestinationValues = absenceScope.get(destinationHolder, reference);
                int oldIndex = updatedDestinationValues.indexOf(destinationValue);
                absenceScope.move(destinationHolder, (EStructuralFeature)reference, index, oldIndex);
            }
            --i;
        }
    }

    protected void mergeValueAddition() {
        int index;
        boolean cloned;
        EObject destinationValue;
        IEditableModelScope absenceScope = this.getAbsenceScope();
        EObject destinationHolder = this.getMatchOfHolder();
        EMatch match = this.getValue();
        if (match.isPartial()) {
            destinationValue = this.getComparison().getMapping().completeMatch(match);
            cloned = true;
        } else {
            destinationValue = match.get(this.getAbsenceRole());
            cloned = false;
        }
        assert (destinationHolder != null && destinationValue != null);
        boolean actuallyAdded = absenceScope.add(destinationHolder, this.getFeature(), destinationValue);
        IDiffPolicy diffPolicy = this.getComparison().getLastDiffPolicy();
        IMergePolicy mergePolicy = this.getComparison().getLastMergePolicy();
        if (diffPolicy != null && actuallyAdded && diffPolicy.considerOrdered((EStructuralFeature)this.getFeature()) && (index = mergePolicy.getDesiredValuePosition(this.getComparison(), this.getAbsenceRole(), this.getElementMatch(), this.getFeature(), this.getValue())) >= 0) {
            absenceScope.move(destinationHolder, (EStructuralFeature)this.getFeature(), index, -1);
        }
        if (cloned && actuallyAdded) {
            BidirectionalComparisonCopier.handleIDCopy(match.get(this.getPresenceRole()), this.getPresenceScope(), destinationValue, this.getAbsenceScope(), mergePolicy);
        }
    }

    protected final void mergeValueRemoval() {
        if (this.getSymmetrical() == null && (!this.hasStrongerOpposite() || this.getValue().isPartial())) {
            IEditableModelScope presenceScope = this.getPresenceScope();
            EObject valueElement = this.getValue().get(this.getPresenceRole());
            if (this.getFeature() != null) {
                presenceScope.remove(this.getHolder(), this.getFeature(), valueElement);
            } else {
                presenceScope.remove(valueElement);
            }
            if (this.getFeature() == null || this.getFeature().isContainment()) {
                for (EStructuralFeature.Setting setting : this.getComparison().getMapping().getCrossReferences(valueElement, this.getPresenceRole())) {
                    presenceScope.remove(setting.getEObject(), (EReference)setting.getEStructuralFeature(), valueElement);
                }
                if (!this.getComparison().getLastMergePolicy().bindPresenceToOwnership(presenceScope)) {
                    for (EObject child : presenceScope.getContents(valueElement)) {
                        presenceScope.add(child);
                    }
                }
            }
        }
    }
}

