/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.attributesID;

import dmLab.mcfs.attributesID.IDEdge;
import dmLab.mcfs.attributesID.IDEdgeIterator;
import dmLab.mcfs.attributesID.IDEntity;
import dmLab.mcfs.attributesID.IDLink;
import dmLab.mcfs.attributesID.IDList;
import dmLab.mcfs.attributesID.IDProps;
import dmLab.mcfs.attributesID.graph.IDGraph;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.utils.FileUtils;
import dmLab.utils.MyDict;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public final class AttributesID
implements Iterable<IDEdge> {
    private HashMap<IDLink, IDProps> myIDMap;
    private MyDict myDict;
    private float maxID;
    private float minID;
    private boolean directedGraph;
    private boolean selfID;
    public static String ID_FILE_HEADER = "parent,child,weight";
    public static String ID_FILE_HEADER_OLD = "edge_a,edge_b,weight";

    /*
     * WARNING - void declaration
     */
    private AttributesID(MyDict myDict, boolean directed, boolean selfID) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.myDict = var1_1;
        this.directedGraph = var2_2;
        this.selfID = var3_3;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public AttributesID(String[] attributes, boolean directed, boolean selfID) {
        void var1_1;
        this.myDict = new MyDict((String[])var1_1);
        this.directedGraph = true;
        this.selfID = false;
        this.init();
    }

    public AttributesID(boolean directed, boolean selfID) {
        this.myDict = new MyDict();
        this.directedGraph = true;
        this.selfID = false;
        this.init();
    }

    public final void init() {
        this.myIDMap = new HashMap();
        this.minID = Float.MAX_VALUE;
        this.maxID = Float.MIN_VALUE;
    }

    public final int getNodesNumber() {
        return this.myDict.size();
    }

    public final int addAttributesID(AttributesID attrID) {
        IDLink[] myIDLinks = new IDLink[1];
        myIDLinks = attrID.myIDMap.keySet().toArray(myIDLinks);
        for (int i = 0; i < myIDLinks.length; ++i) {
            IDLink link = myIDLinks[i];
            if (link == null) continue;
            IDProps props = attrID.myIDMap.get(link);
            this.putID(link, props);
        }
        return this.myIDMap.size();
    }

    /*
     * WARNING - void declaration
     */
    public final int addID(String parent, String child, float weight) {
        if (!this.selfID && parent.equalsIgnoreCase(child)) {
            return this.myIDMap.size();
        }
        this.putID(parent, child, weight);
        if (!this.directedGraph) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.putID((String)var2_2, (String)var1_1, (float)var3_3);
        }
        return this.myIDMap.size();
    }

    /*
     * WARNING - void declaration
     */
    private int putID(String parent, String child, float weight) {
        void var3_6;
        void var1_3;
        void var2_5;
        int parentId = this.myDict.put(parent);
        int childId = this.myDict.put(child);
        IDLink link = new IDLink(parentId, (int)var2_5);
        return this.putID((IDLink)var1_3, new IDProps((float)var3_6));
    }

    /*
     * WARNING - void declaration
     */
    private int putID(IDLink link, IDProps props) {
        IDProps myIDProps = this.myIDMap.get(link);
        if (myIDProps == null) {
            void var1_1;
            myIDProps = props;
            this.myIDMap.put((IDLink)var1_1, props);
        } else {
            void var2_2;
            myIDProps.add((IDProps)var2_2);
        }
        if (myIDProps.weight > this.maxID) {
            this.maxID = myIDProps.weight;
        }
        if (myIDProps.weight < this.minID) {
            void var3_3;
            this.minID = var3_3.weight;
        }
        return this.myIDMap.size();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(ID_FILE_HEADER).append('\n');
        IDLink[] myIDLinksArray = new IDLink[1];
        myIDLinksArray = this.myIDMap.keySet().toArray(myIDLinksArray);
        for (int i = 0; i < myIDLinksArray.length; ++i) {
            IDLink link = myIDLinksArray[i];
            if (link == null) continue;
            IDProps props = this.myIDMap.get(link);
            tmp.append(link.toString(this.myDict)).append(",").append(props.toString()).append("\n");
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String toConnString() {
        void var2_2;
        String[] attributes = this.myDict.getKeys();
        StringBuffer tmp = new StringBuffer();
        AttributesID attributesID = this;
        Object[] objectArray = attributesID.myDict.getKeys();
        Object object = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            object[i] = attributesID.myDict.get(objectArray[i]);
        }
        IDList iDList = new IDList((int[])object);
        objectArray = new IDLink[1];
        objectArray = (IDLink[])attributesID.myIDMap.keySet().toArray(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            object = object2;
            if (object2 == null) continue;
            iDList.put(object.parentId, object.childId);
        }
        IDList connLists = iDList;
        for (int i = 0; i < attributes.length; ++i) {
            int j;
            int attrId = this.myDict.get(attributes[i]);
            Integer[] vals = connLists.getValues(attrId);
            if (vals == null) continue;
            tmp.append(attributes[i]);
            Object[] myIDEntityArray = new IDEntity[vals.length];
            for (j = 0; j < vals.length; ++j) {
                IDLink link = new IDLink(attrId, vals[j]);
                IDProps props = this.myIDMap.get(link);
                myIDEntityArray[j] = new IDEntity(link, props);
            }
            Arrays.sort(myIDEntityArray);
            for (j = 0; j < myIDEntityArray.length; ++j) {
                tmp.append(',').append(this.myDict.get(((IDEntity)myIDEntityArray[j]).link.childId)).append("(" + ((IDEntity)myIDEntityArray[j]).props.toString() + ")");
            }
            tmp.append('\n');
        }
        return var2_2.toString();
    }

    public final boolean save(String fileName) {
        return FileUtils.saveString(fileName, this.toConnString());
    }

    /*
     * WARNING - void declaration
     */
    public final AttributesID filter(float minWeight, AttributesRI importance, int attrNumber) {
        void var1_1;
        Ranking ranking = null;
        String[] attributes = null;
        if (importance != null) {
            void var3_4;
            void var2_3;
            void v0 = var2_3;
            ranking = v0.getTopRankingSize(v0.mainMeasureIdx, (int)var3_4);
        }
        if (ranking != null) {
            attributes = ranking.getAttributesNames();
        }
        AttributesID attributesID = this.filter(attributes, (float)var1_1);
        return attributesID;
    }

    /*
     * WARNING - void declaration
     */
    private AttributesID filter(String[] attributes, float minWeight) {
        void var3_3;
        AttributesID retAttrID = new AttributesID(this.myDict.clone(), this.directedGraph, this.selfID);
        HashSet<Integer> attributesSet = null;
        if (attributes != null) {
            attributesSet = new HashSet<Integer>();
            for (int i = 0; i < attributes.length; ++i) {
                Integer currAttrId = this.myDict.get(attributes[i]);
                if (currAttrId == null) continue;
                attributesSet.add(currAttrId);
            }
        }
        IDLink[] linksArray = new IDLink[1];
        linksArray = this.myIDMap.keySet().toArray(linksArray);
        for (int i = 0; i < linksArray.length; ++i) {
            void var1_1;
            IDProps iDProps;
            IDLink link = linksArray[i];
            if (link == null) continue;
            IDProps props = this.myIDMap.get(link);
            boolean put = iDProps.weight >= minWeight;
            put = attributesSet == null ? (put &= true) : (attributesSet.contains(link.parentId) && attributesSet.contains(link.childId) ? (put &= true) : false);
            if (!put) continue;
            retAttrID.putID((IDLink)var1_1, props);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final IDGraph toGraph(float minWeight2, AttributesRI importance, int attrNumber) {
        void var1_2;
        void var2_3;
        void var3_4;
        AttributesID minWeight2 = this.filter(minWeight2, importance, (int)var3_4);
        IDGraph graph = minWeight2.toGraph();
        graph.setNodesWeights((AttributesRI)var2_3);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private IDGraph toGraph() {
        void var3_3;
        void var2_2;
        void var1_1;
        float minID = Float.MAX_VALUE;
        float maxID = Float.MIN_VALUE;
        IDGraph graph = new IDGraph();
        IDLink[] linksArray = new IDLink[1];
        linksArray = this.myIDMap.keySet().toArray(linksArray);
        for (int i = 0; i < linksArray.length; ++i) {
            float f;
            IDLink link = linksArray[i];
            if (link == null) continue;
            IDProps iDProps = this.myIDMap.get(link);
            float weight = iDProps.weight;
            if (f > maxID) {
                maxID = weight;
            }
            if (weight < minID) {
                minID = weight;
            }
            graph.addEdge(this.myDict.get(link.parentId), this.myDict.get(link.childId), weight);
        }
        graph.setMinEdgeWeight((float)var1_1);
        graph.setMaxEdgeWeight((float)var2_2);
        return var3_3;
    }

    public final float getMaxID() {
        return this.maxID;
    }

    /*
     * WARNING - void declaration
     */
    public final float getIDWeight(int topSize) {
        void var3_5;
        void var1_2;
        ArrayList<Float> w = new ArrayList<Float>();
        IDLink[] linksArray = new IDLink[1];
        linksArray = this.myIDMap.keySet().toArray(linksArray);
        for (int i = 0; i < linksArray.length; ++i) {
            IDLink link = linksArray[i];
            if (link == null) continue;
            w.add(Float.valueOf(this.myIDMap.get((Object)link).weight));
        }
        Float[] f = new Float[1];
        f = var1_2.toArray(f);
        Arrays.sort((Object[])f);
        if (f.length - 20 < 0) {
            return f[0].floatValue();
        }
        void v0 = var3_5;
        return v0[((void)v0).length - 20].floatValue();
    }

    @Override
    public final Iterator<IDEdge> iterator() {
        IDEdgeIterator iDEdgeIterator = new IDEdgeIterator(this.myIDMap, this.myDict);
        return iDEdgeIterator;
    }
}

