/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.act.rscat.cat.AbstractScoringMethodConfig;
import org.act.rscat.cat.CatConfig;
import org.act.rscat.cat.CatConfigStandard;
import org.act.rscat.cat.ExposureControlConfig;
import org.act.rscat.cat.ExposureControlType;
import org.act.rscat.cat.ItemSelectionMethod;
import org.act.rscat.cat.ThetaRange;
import org.act.rscat.mip.SolverConfig;
import org.act.rscat.sim.AbstractCatSimulation;
import org.act.rscat.sim.CatSimulationStandard;
import org.act.rscat.sim.SimOutput;
import org.act.rscat.sol.InfeasibleTestConfigException;
import org.act.rscat.testdef.TestConfig;
import org.act.rscat.util.ContentTable;
import org.act.rscat.util.CsvUtils;
import org.act.rscat.util.ProbDistributionFactory;

public class RHelper {
    private RHelper() {
    }

    public static List<SimOutput> runSim(AbstractScoringMethodConfig scoringMethodConfig, double initTheta, double scalingConstant, String itemSelectionMethod, String exposureControlType, double rMax, int lValue, double absGap, double relGap, double intTol, boolean saveInput, String testConfigID, int testLength, String itempoolPath, String passagepoolPath, String constraintPath, boolean[] itemNumericColumn, boolean[] passageNumericColumn, boolean enableEnemyItem, int numPassageLB, int numPassageUB, int numItemPerPassageLB, int numItemPerPassageUB, String simID, int numExaminees, String trueThetaDistType, double[] trueThetaDistParams) throws IOException, InfeasibleTestConfigException {
        ExposureControlType ecType;
        ItemSelectionMethod.SUPPORTED_METHODS itemSelMethod;
        SolverConfig solverConfig = new SolverConfig(absGap, relGap, intTol, saveInput);
        if (itemSelectionMethod.equals("maxInfo")) {
            itemSelMethod = ItemSelectionMethod.SUPPORTED_METHODS.MAX_FISHER_INFO;
        } else if (itemSelectionMethod.equals("ebi")) {
            itemSelMethod = ItemSelectionMethod.SUPPORTED_METHODS.EBI;
        } else {
            throw new IllegalArgumentException("Invalid item selection method!");
        }
        if (exposureControlType.equals("Item")) {
            ecType = ExposureControlType.ITEM;
        } else if (exposureControlType.equals("None")) {
            ecType = ExposureControlType.NONE;
        } else {
            throw new IllegalArgumentException("Invalid exposure control type!");
        }
        List<ThetaRange> thetaRanges = Arrays.asList(new ThetaRange(-8.0, 8.0));
        ExposureControlConfig exposureConfig = new ExposureControlConfig(ecType, thetaRanges, rMax);
        CatConfigStandard catConfig = new CatConfigStandard(solverConfig, initTheta, scalingConstant, scoringMethodConfig, exposureConfig, itemSelMethod, lValue);
        ContentTable.RowOriented itemPoolTable = CsvUtils.read(new FileInputStream(new File(itempoolPath)));
        TestConfig.Builder testConfigBuilder = new TestConfig.Builder(testLength, itemNumericColumn, itemPoolTable);
        testConfigBuilder.testConfigId(testConfigID).enableEnemyItemConstraint(enableEnemyItem);
        if (constraintPath.length() > 0) {
            ContentTable.RowOriented constraintTable = CsvUtils.read(new FileInputStream(new File(constraintPath)));
            testConfigBuilder.constraintTable(constraintTable);
        }
        if (passagepoolPath.length() > 0) {
            ContentTable.RowOriented passagepoolTable = CsvUtils.read(new FileInputStream(new File(passagepoolPath)));
            testConfigBuilder.passageTable(passagepoolTable).passageNumericColumn(passageNumericColumn).numPassageLB(numPassageLB).numPassageUB(numPassageUB).numItemPerPassageLB(numItemPerPassageLB).numItemPerPassageUB(numItemPerPassageUB);
        }
        TestConfig testConfig = testConfigBuilder.build();
        CatSimulationStandard catSim = new CatSimulationStandard(simID, numExaminees, ProbDistributionFactory.getProbDistribution(trueThetaDistType, trueThetaDistParams), testConfig, (CatConfig)catConfig, (Boolean)true);
        return ((AbstractCatSimulation)catSim).runSim();
    }
}

