/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.cat;

import org.act.rscat.cat.EBIMethod;
import org.act.rscat.cat.ItemSelectionMethod;
import org.act.rscat.cat.MaxFisherInformationMethod;
import org.apache.commons.math3.linear.RealMatrix;

public class ItemSelectionMethodFactory {
    private ItemSelectionMethodFactory() {
    }

    public static ItemSelectionMethod getInstance(ItemSelectionMethod.SUPPORTED_METHODS itemSelectionMethodType, RealMatrix itemPar, double thetaEst, double thetaSe) {
        switch (itemSelectionMethodType) {
            case MAX_FISHER_INFO: {
                return new MaxFisherInformationMethod(itemPar, thetaEst);
            }
            case EBI: {
                return new EBIMethod(itemPar, thetaEst, thetaSe);
            }
        }
        throw new IllegalArgumentException("The item selection is method not supported!");
    }
}

