/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.structure;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.IStateLong;

public class OneWordS64BitSet
implements IStateBitSet {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;
    private final IStateLong word;

    public OneWordS64BitSet(IEnvironment environment) {
        this.word = environment.makeLong(0L);
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    @Override
    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.word.set(this.word.get() | 1L << bitIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        OneWordS64BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        this.word.set(this.word.get() | firstWordMask & lastWordMask);
    }

    @Override
    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.word.set(this.word.get() & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        OneWordS64BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        this.word.set(this.word.get() & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public void clear() {
        this.word.set(0L);
    }

    @Override
    public final boolean get(int bitIndex) {
        return bitIndex < 64 && (this.word.get() & 1L << bitIndex) != 0L;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= 64) {
            return -1;
        }
        long word = this.word.get() & -1L << fromIndex;
        if (word != 0L) {
            return Long.numberOfTrailingZeros(word);
        }
        return -1;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= 64) {
            return fromIndex;
        }
        long word = (this.word.get() ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        if (word != 0L) {
            return Long.numberOfTrailingZeros(word);
        }
        return 64;
    }

    @Override
    public int prevSetBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex >= 64) {
            return this.length() - 1;
        }
        long word = this.word.get() & -1L >>> -(fromIndex + 1);
        if (word != 0L) {
            return 63 - Long.numberOfLeadingZeros(word);
        }
        return -1;
    }

    @Override
    public int prevClearBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex >= 64) {
            return fromIndex;
        }
        long word = (this.word.get() ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(fromIndex + 1);
        if (word != 0L) {
            return 63 - Long.numberOfLeadingZeros(word);
        }
        return -1;
    }

    public int length() {
        return 64 - Long.numberOfLeadingZeros(this.word.get());
    }

    @Override
    public boolean isEmpty() {
        return this.word.get() == 0L;
    }

    @Override
    public int cardinality() {
        return Long.bitCount(this.word.get());
    }

    public int hashCode() {
        long h = 1234L;
        return (int)((h ^= this.word.get()) >> 32 ^ h);
    }

    @Override
    public int size() {
        return 64;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OneWordS64BitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        OneWordS64BitSet set = (OneWordS64BitSet)obj;
        return this.word == set.word;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(386);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }
}

