## -----------------------------------------------------------------------------
require(mcunit)
set.seed(10)

## -----------------------------------------------------------------------------
gen <- function(){
    x <- rnorm(10)
    t.test(x)$p.value<0.05
}

## -----------------------------------------------------------------------------
J <- matrix(nrow=2,c(0,0.045, 0.04,0.06, 0.055,1))
colnames(J) <- c("low","ok","high")
J

## -----------------------------------------------------------------------------
expect_bernoulli(gen,J=J,ok="ok")

## -----------------------------------------------------------------------------
J <- matrix(nrow=2,c(0,0.04,0.035,0.065, 0.06,1))
colnames(J) <- c("low", "ok","high")
J
gen <- function()as.numeric(chisq.test(c(rmultinom(1,size=15,prob=c(1/3,1/3,1/3))))$p.value<0.05)
expect_bernoulli(gen,J=J,ok="ok")

## -----------------------------------------------------------------------------
gen <- function(){
    x <- rnorm(10,mean=3.7)
    CI <- t.test(x)$conf.int
    as.numeric(CI[1]<=3.7&CI[2]>=3.7)
}

## -----------------------------------------------------------------------------
J <- matrix(nrow=2,c(0,0.945, 0.94,0.96, 0.955,1))
colnames(J) <- c("low","ok","high")
J

## -----------------------------------------------------------------------------
expect_bernoulli(gen,J=J,ok="ok")

