## ----include = FALSE--------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  message = FALSE,
	warning = FALSE,
	tidy.opts = list(
		keep.blank.line = TRUE,
		width.cutoff = 150
		),
	options(width = 150,fig.width=12, fig.height=8)
)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
library(clustcurv)
library(survival)
head(veteran)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res <- survclustcurves(time = veteran$time, status = veteran$status,
x = veteran$celltype, algorithm = 'kmedians', nboot = 100, seed=300716)

## ---------------------------------------------------------------------------------------------------------------------------------------------------

summary(res)

## ----out.width= '100%', fig.align = "center"--------------------------------------------------------------------------------------------------------
autoplot(res , groups_by_colour = FALSE, interactive = TRUE)

## ----out.width= '100%', fig.align = "center"--------------------------------------------------------------------------------------------------------
autoplot(res , groups_by_colour = TRUE, interactive = TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res2 <- survclustcurves(time = veteran$time, status = veteran$status,
x = veteran$celltype, algorithm = 'kmeans', nboot = 100, seed=300716)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
data("barnacle5")
head(barnacle5)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
fit.bar <- regclustcurves(y = barnacle5$DW, x = barnacle5$RC, z = barnacle5$F,
                          nboot = 100, seed = 300716, algorithm = 'kmeans')

## ---------------------------------------------------------------------------------------------------------------------------------------------------
print(fit.bar)
summary(fit.bar)

## ----out.width= '100%', fig.align = "center"--------------------------------------------------------------------------------------------------------
autoplot(fit.bar, groups_by_color = TRUE, interactive = TRUE)

