/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.file_chooser;

import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import com.qarks.util.ui.swing.file_chooser.FileChooser;
import com.qarks.util.ui.swing.file_chooser.FileSelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public class FileChooserDialog
extends JDialog
implements ActionListener,
FileSelectionListener {
    private JButton ok;
    private JButton cancel;
    private FileChooser fileChooser;
    private JTextField selection;
    private boolean save;
    private boolean selectionOk = false;
    private boolean multipleSelection = true;

    public FileChooserDialog(Window window, String string, File file, File file2, boolean bl) {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.save = bl;
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        container.add(jPanel);
        this.ok = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
        this.ok.addActionListener(this);
        this.ok.setEnabled(false);
        this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        this.cancel.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
        jPanel2.add(this.ok);
        jPanel2.add(this.cancel);
        this.fileChooser = new FileChooser();
        if (file != null) {
            try {
                this.fileChooser.setCurrentDir(file.getCanonicalPath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            this.multipleSelection = false;
            this.fileChooser.setMultipleSelection(false);
        }
        this.fileChooser.addFileSelectionListener(this);
        this.selection = new JTextField(32);
        this.selection.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                FileChooserDialog.this.ok.setEnabled(FileChooserDialog.this.selection.getText().length() > 0);
            }
        });
        this.selection.setDocument(new DefaultStyledDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (FileChooserDialog.this.multipleSelection || string.indexOf("|") == -1) {
                    super.insertString(n, string, attributeSet);
                }
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        jPanel4.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKey.FILE)), "West");
        jPanel4.add((Component)this.selection, "Center");
        jPanel3.add((Component)this.fileChooser, "Center");
        jPanel3.add((Component)jPanel4, "South");
        jPanel.add((Component)jPanel2, "South");
        jPanel.add((Component)jPanel3, "Center");
        if (file2 != null) {
            String string2 = file2.getName();
            this.selection.setText(string2);
            this.ok.setEnabled(string2.length() > 0);
        }
        this.setSize(700, 500);
    }

    public void enabledMultipleSelection(boolean bl) {
        if (!this.save) {
            this.multipleSelection = bl;
            this.fileChooser.setMultipleSelection(bl);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            if ("".equals(this.fileChooser.getCurrentDirectory())) {
                JOptionPane.showMessageDialog(this, ResourceManager.getString((Object)ResourceKey.SELECT_FOLDER_FIRST), ResourceManager.getString((Object)ResourceKey.SAVE), 1);
            } else if (this.save) {
                File file = this.getInternalSelection()[0];
                if (file.exists()) {
                    Object[] objectArray = new Object[]{ResourceManager.getString((Object)ResourceKey.YES), ResourceManager.getString((Object)ResourceKey.NO)};
                    int n = JOptionPane.showOptionDialog(this, ResourceManager.getString((Object)ResourceKey.OVERWRITE_CONFIRM), ResourceManager.getString((Object)ResourceKey.SAVE), -1, 1, null, objectArray, objectArray[1]);
                    if (n == 0) {
                        this.selectionOk = true;
                        this.dispose();
                    }
                } else {
                    this.selectionOk = true;
                    this.dispose();
                }
            } else {
                this.selectionOk = true;
                this.dispose();
            }
        } else if (object == this.cancel) {
            this.dispose();
        }
    }

    public File[] getSelectedFiles() {
        File[] fileArray = null;
        if (this.selectionOk) {
            fileArray = this.getInternalSelection();
        }
        return fileArray;
    }

    private File[] getInternalSelection() {
        File[] fileArray = new File[]{};
        StringTokenizer stringTokenizer = new StringTokenizer(this.selection.getText(), "|");
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = this.fileChooser.getCurrentDirectory() + File.separator;
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(string + stringTokenizer.nextToken());
            arrayList.add(file);
        }
        fileArray = arrayList.toArray(fileArray);
        return fileArray;
    }

    @Override
    public void onFileSelected(File[] fileArray) {
        this.ok.setEnabled(false);
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (fileArray != null) {
            boolean bl3 = true;
            for (File file : fileArray) {
                if (!file.isDirectory()) {
                    bl = true;
                    if (!bl3) {
                        stringBuffer.append("|");
                    }
                    bl3 = false;
                    stringBuffer.append(file.getName());
                    continue;
                }
                bl2 = true;
            }
            this.ok.setEnabled(bl && !bl2);
        }
        this.selection.setText(stringBuffer.toString());
    }
}

