/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.realarray.mut;

import net.sf.jclec.realarray.RealArrayIndividual;
import net.sf.jclec.realarray.mut.ModalMutator;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModalContinuousMutator<I extends RealArrayIndividual>
extends ModalMutator<I> {
    private static final long serialVersionUID = 1982401789338573017L;
    protected transient double upper;
    protected transient double half;
    protected transient double half_density;

    public boolean equals(Object other) {
        if (other instanceof ModalContinuousMutator) {
            ModalContinuousMutator o = (ModalContinuousMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.locusMutProb, o.locusMutProb);
            eb.append(this.Bm, o.Bm);
            eb.append(this.minimumRange, o.minimumRange);
            eb.append(this.mutationRange, o.mutationRange);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void prepareMutation() {
        super.prepareMutation();
        this.upper = 0.5 * (this.Bm - 1.0);
        this.half = this.upper / 2.0;
        this.half_density = 1.0 / this.half;
    }

    @Override
    protected void doLocusMutation(double[] parentChromosome, double[] mutantChromosome, int locusIndex) {
        double rang = this.mutationRange * this.genotypeSchema[locusIndex].efWidth();
        int pi = (int)(Math.log(this.minimumRange) / Math.log(this.Bm));
        double gamma = 0.0;
        int k = 0;
        while (k >= pi) {
            if (this.randgen.raw() < 0.0625) {
                double prob;
                double point2;
                double point1;
                double extinf = (Math.pow(this.Bm, k) - Math.pow(this.Bm, k - 1)) / 2.0;
                double extsup = (Math.pow(this.Bm, k + 1) - Math.pow(this.Bm, k)) / 2.0;
                if (extsup <= this.half) {
                    point1 = this.half_density / this.half * extinf;
                    point2 = this.half_density / this.half * extsup;
                    prob = (point1 + point2) * (extsup - extinf) / 2.0;
                } else if (extinf >= this.half) {
                    point1 = -this.half_density / (this.upper - this.half) * extinf + this.half_density + this.half * this.half_density / (this.upper - this.half);
                    point2 = -this.half_density / (this.upper - this.half) * extsup + this.half_density + this.half * this.half_density / (this.upper - this.half);
                    prob = (point1 + point2) * (extsup - extinf) / 2.0;
                } else {
                    point1 = this.half_density / this.half * extinf;
                    point2 = -this.half_density / (this.upper - this.half) * extsup + this.half_density + this.half * this.half_density / (this.upper - this.half);
                    prob = (point1 + this.half_density) * (this.half - extinf) / 2.0;
                    prob += (point2 + this.half_density) * (extsup - this.half) / 2.0;
                }
                gamma += prob;
            }
            --k;
        }
        double newValue = this.randgen.coin() ? parentChromosome[locusIndex] + rang * gamma : parentChromosome[locusIndex] - rang * gamma;
        mutantChromosome[locusIndex] = this.genotypeSchema[locusIndex].nearestOf(newValue);
    }

    @Override
    protected double defaultLocusMutProb() {
        return 0.6;
    }

    @Override
    protected double defaultBm() {
        return 2.0;
    }

    @Override
    protected double defaultMutationRange() {
        return 0.1;
    }

    @Override
    protected double defaultMinimumRange() {
        return 1.0E-5;
    }
}

