% Generated by roxygen2: do not edit by hand
\name{cdplot}
\alias{cdplot}
\title{Conditional Density Plot}
\arguments{
  \item{formula}{of the form `y ~ x`, where `y` is a factor and `x` is numeric}
  \item{data}{data frame containing the variables in the formula}
  \item{yaxlabels}{character vector; y axis labels for vertical ordering of levels}
  \item{ylevels}{character vector to subset or reorder factor levels}
  \item{...}{\{.help [graphical parameters](graphics::par)\}, e.g. `col`
}
}

\details{
Visualize how a categorical variable depends on a numeric predictor
\code{
df <- data.frame(
  x = c(rnorm(50, m = -2), rnorm(50, m = 0), rnorm(50, m = 2)),
  c = factor( rep(c("A","B","C"), each = 50) )
)
cdplot(c ~ x, data = df)
}

Specify labels for factors (default is alphabetical order)
\code{
cdplot(c ~ x, data = df, yaxlabels = c("aa","bb","cc"))
}

Reorder presentation of factor levels top to bottom
\code{
cdplot(c ~ x, data = df, ylevels = c("C","A","B"))
}}

