: BEGIN {die "You meant to run embed.pl"} # Stop early if fed to perl.
:
: Lines are of the form:
:    flags|return_type|function_name|arg1|arg2|...|argN
:
: A line may be continued on another by ending it with a backslash.
: Leading and trailing whitespace will be ignored in each component.
:
: flags are single letters with following meanings:
:	A		member of public API
:	m		Implemented as a macro - no export, no
:			proto, no #define
:	d		function has documentation with its source
:	s		static function, should have an S_ prefix in
:			source file; for macros (m), suffix the usage
:			example with a semicolon
:	n		has no implicit interpreter/thread context argument
:	p		function has a Perl_ prefix
:	f		function takes printf style format string, varargs
:	r		function never returns
:	o		has no compatibility macro (#define foo Perl_foo)
:	x		not exported
:	X		explicitly exported
:	M		may change
:	E		visible to extensions included in the Perl core
:	b		binary backward compatibility; function is a macro
:			but has also Perl_ implementation (which is exported)
:	U		suppress usage example in autogenerated documentation
:	a		allocates memory a la malloc/calloc.  Is also "R".
:	R		Return value must not be ignored.
:	P		pure function: no effects except the return value;
:			return value depends only on parms and/or globals
: (see also L<perlguts/Internal Functions> for those flags.)
:
: Pointer parameters that must not be passed NULLs should be prefixed with NN.
:
: Pointer parameters that may be NULL should be prefixed with NULLOK.  This has
: no effect on output yet.  It's a notation for the maintainers to know "I have
: defined whether NULL is OK or not" rather than having neither NULL or NULLOK,
: which is ambiguous.
:
: Individual flags may be separated by whitespace.

START_EXTERN_C

#if defined(PERL_IMPLICIT_SYS)
Ano	|PerlInterpreter*|perl_alloc_using \
				|NN struct IPerlMem* m|NN struct IPerlMem* ms \
				|NN struct IPerlMem* mp|NN struct IPerlEnv* e \
				|NN struct IPerlStdIO* io|NN struct IPerlLIO* lio \
				|NN struct IPerlDir* d|NN struct IPerlSock* s \
				|NN struct IPerlProc* p
#endif
Anod	|PerlInterpreter*	|perl_alloc
Anod	|void	|perl_construct	|NN PerlInterpreter* interp
Anod	|int	|perl_destruct	|NN PerlInterpreter* interp
Anod	|void	|perl_free	|NN PerlInterpreter* interp
Anod	|int	|perl_run	|NN PerlInterpreter* interp
Anod	|int	|perl_parse	|NN PerlInterpreter* interp|XSINIT_t xsinit \
				|int argc|NULLOK char** argv|NULLOK char** env
AnpR	|bool	|doing_taint	|int argc|NULLOK char** argv|NULLOK char** env
#if defined(USE_ITHREADS)
Anod	|PerlInterpreter*|perl_clone|NN PerlInterpreter* interp|UV flags
#  if defined(PERL_IMPLICIT_SYS)
Ano	|PerlInterpreter*|perl_clone_using \
				|NN PerlInterpreter *interp|UV flags \
				|NN struct IPerlMem* m|NN struct IPerlMem* ms \
				|NN struct IPerlMem* mp|NN struct IPerlEnv* e \
				|NN struct IPerlStdIO* io|NN struct IPerlLIO* lio \
				|NN struct IPerlDir* d|NN struct IPerlSock* s \
				|NN struct IPerlProc* p
#  endif
#endif

Aanop	|Malloc_t|malloc	|MEM_SIZE nbytes
Aanop	|Malloc_t|calloc	|MEM_SIZE elements|MEM_SIZE size
Aanop	|Malloc_t|realloc	|Malloc_t where|MEM_SIZE nbytes
Anop	|Free_t	|mfree		|Malloc_t where
#if defined(MYMALLOC)
npR	|MEM_SIZE|malloced_size	|NN void *p
#endif

AnpR	|void*	|get_context
Anp	|void	|set_context	|NN void *thx

END_EXTERN_C

/* functions with flag 'n' should come before here */
START_EXTERN_C
#  include "pp_proto.h"
Ap	|SV*	|amagic_call	|NN SV* left|NN SV* right|int method|int dir
Ap	|bool	|Gv_AMupdate	|NN HV* stash
ApR	|CV*	|gv_handler	|NULLOK HV* stash|I32 id
p	|OP*	|append_elem	|I32 optype|NULLOK OP* first|NULLOK OP* last
p	|OP*	|append_list	|I32 optype|NULLOK LISTOP* first|NULLOK LISTOP* last
p	|I32	|apply		|I32 type|NN SV** mark|NN SV** sp
ApM	|void	|apply_attrs_string|NN char *stashpv|NN CV *cv|NN char *attrstr|STRLEN len
Ap	|SV*	|avhv_delete_ent|NULLOK AV *ar|NN SV* keysv|I32 flags|U32 hash
Ap	|bool	|avhv_exists_ent|NULLOK AV *ar|NN SV* keysv|U32 hash
Ap	|SV**	|avhv_fetch_ent	|NULLOK AV *ar|NN SV* keysv|I32 lval|U32 hash
Ap	|SV**	|avhv_store_ent	|NULLOK AV *ar|NN SV* keysv|NULLOK SV* val\
				|U32 hash
Ap	|HE*	|avhv_iternext	|NULLOK AV *ar
Ap	|SV*	|avhv_iterval	|NULLOK AV *ar|NN HE* entry
Ap	|HV*	|avhv_keys	|NULLOK AV *ar
Apd	|void	|av_clear	|NULLOK AV* ar
Apd	|SV*	|av_delete	|NULLOK AV* ar|I32 key|I32 flags
ApdR	|bool	|av_exists	|NULLOK AV* ar|I32 key
Apd	|void	|av_extend	|NN AV* ar|I32 key
pR	|AV*	|av_fake	|I32 size|NN SV** svp
ApdR	|SV**	|av_fetch	|NULLOK AV* ar|I32 key|I32 lval
Apd	|void	|av_fill	|NN AV* ar|I32 fill
ApdR	|I32	|av_len		|NN AV* ar
ApdR	|AV*	|av_make	|I32 size|NN SV** svp
Apd	|SV*	|av_pop		|NULLOK AV* ar
ApdoxM	|void	|av_create_and_push|NN AV **const avp|NN SV *const val
Apd	|void	|av_push	|NULLOK AV* ar|NN SV* val
EXp	|void	|av_reify	|NN AV* ar
ApdR	|SV*	|av_shift	|NULLOK AV* ar
Apd	|SV**	|av_store	|NULLOK AV* ar|I32 key|NULLOK SV* val
Apd	|void	|av_undef	|NULLOK AV* ar
ApdoxM	|SV**	|av_create_and_unshift_one|NN AV **const avp|NN SV *const val
Apd	|void	|av_unshift	|NULLOK AV* ar|I32 num
pR	|OP*	|bind_match	|I32 type|NN OP* left|NN OP* pat
pR	|OP*	|block_end	|I32 floor|NULLOK OP* seq
ApR	|I32	|block_gimme
pR	|int	|block_start	|int full
p	|void	|boot_core_UNIVERSAL
p	|void	|boot_core_PerlIO
Ap	|void	|call_list	|I32 oldscope|NN AV* av_list
pR	|bool	|cando		|Mode_t mode|Uid_t effective|NN Stat_t* statbufp
ApR	|U32	|cast_ulong	|NV f
ApR	|I32	|cast_i32	|NV f
ApR	|IV	|cast_iv	|NV f
ApR	|UV	|cast_uv	|NV f
#if !defined(HAS_TRUNCATE) && !defined(HAS_CHSIZE) && defined(F_FREESP)
ApR	|I32	|my_chsize	|int fd|Off_t length
#endif
#if defined(USE_5005THREADS)
Ap	|MAGIC*	|condpair_magic	|NN SV *sv
#endif
pR	|OP*	|convert	|I32 optype|I32 flags|NULLOK OP* o
pM	|PERL_CONTEXT*	|create_eval_scope|U32 flags
: croak()'s first parm can be NULL.  Otherwise, mod_perl breaks.
Afprd	|void	|croak		|NULLOK const char* pat|...
Apr	|void	|vcroak		|NN const char* pat|NULLOK va_list* args
#if defined(PERL_IMPLICIT_CONTEXT)
Afnrp	|void	|croak_nocontext|NN const char* pat|...
Afnp	|OP*	|die_nocontext	|NN const char* pat|...
Afnp	|void	|deb_nocontext	|NN const char* pat|...
Afnp	|char*	|form_nocontext	|NN const char* pat|...
Anp	|void	|load_module_nocontext|U32 flags|NN SV* name|NN SV* ver|...
Afnp	|SV*	|mess_nocontext	|NN const char* pat|...
Afnp	|void	|warn_nocontext	|NN const char* pat|...
Afnp	|void	|warner_nocontext|U32 err|NN const char* pat|...
Afnp	|SV*	|newSVpvf_nocontext|NN const char* pat|...
Afnp	|void	|sv_catpvf_nocontext|NN SV* sv|NN const char* pat|...
Afnp	|void	|sv_setpvf_nocontext|NN SV* sv|NN const char* pat|...
Afnp	|void	|sv_catpvf_mg_nocontext|NN SV* sv|NN const char* pat|...
Afnp	|void	|sv_setpvf_mg_nocontext|NN SV* sv|NN const char* pat|...
Afnp	|int	|fprintf_nocontext|NN PerlIO* stream|NN const char* fmt|...
Afnp	|int	|printf_nocontext|NN const char* fmt|...
#endif
pb	|void	|cv_ckproto	|NN CV* cv|NULLOK GV* gv|NULLOK char* p
p	|void	|cv_ckproto_len	|NN const CV* cv|NULLOK const GV* gv\
				|NULLOK const char* p|const STRLEN len
pd	|CV*	|cv_clone	|NN CV* proto
ApdR	|SV*	|gv_const_sv	|NN GV* gv
ApdR	|SV*	|cv_const_sv	|NULLOK CV* cv
pR	|SV*	|op_const_sv	|NULLOK OP* o|NULLOK CV* cv
Apd	|void	|cv_undef	|NN CV* cv
Ap	|void	|cx_dump	|NN PERL_CONTEXT* cx
Ap	|SV*	|filter_add	|NULLOK filter_t funcp|NULLOK SV* datasv
Ap	|void	|filter_del	|NN filter_t funcp
ApR	|I32	|filter_read	|int idx|NN SV* buffer|int maxlen
ApPR	|char**	|get_op_descs
ApPR	|char**	|get_op_names
pPR	|char*	|get_no_modify
pPR	|U32*	|get_opargs
ApPR	|PPADDR_t*|get_ppaddr
EXpR	|I32	|cxinc
Afp	|void	|deb		|NN const char* pat|...
Ap	|void	|vdeb		|NN const char* pat|NULLOK va_list* args
Ap	|void	|debprofdump
Ap	|I32	|debop		|NN OP* o
Ap	|I32	|debstack
Ap	|I32	|debstackptrs
Ap	|char*	|delimcpy	|NN char* to|NN char* toend|NN char* from \
				|NN char* fromend|int delim|NN I32* retlen
pM	|void	|delete_eval_scope
p	|void	|deprecate	|NN char* s
p	|void	|deprecate_old	|NN char* s
Afp	|OP*	|die		|NULLOK const char* pat|...
p	|OP*	|vdie		|NULLOK const char* pat|NULLOK va_list* args
p	|OP*	|die_where	|NULLOK char* message|STRLEN msglen
Ap	|void	|dounwind	|I32 cxix
pmb	|bool	|do_aexec	|NULLOK SV* really|NN SV** mark|NN SV** sp
p	|bool	|do_aexec5	|NULLOK SV* really|NN SV** mark|NN SV** sp|int fd|int do_report
Ap	|int	|do_binmode	|NN PerlIO *fp|int iotype|int mode
p	|void	|do_chop	|NN SV* asv|NN SV* sv
Ap	|bool	|do_close	|NULLOK GV* gv|bool not_implicit
p	|bool	|do_eof		|NN GV* gv

#ifdef PERL_DEFAULT_DO_EXEC3_IMPLEMENTATION
pmb	|bool	|do_exec	|NN char* cmd
#else
p	|bool	|do_exec	|NN char* cmd
#endif

#if defined(WIN32)
Ap	|int	|do_aspawn	|NN SV* really|NN SV** mark|NN SV** sp
Ap	|int	|do_spawn	|NN char* cmd
Ap	|int	|do_spawn_nowait|NN char* cmd
#endif
#if !defined(WIN32)
p	|bool	|do_exec3	|NN char* cmd|int fd|int do_report
#endif
p	|void	|do_execfree
#ifdef PERL_IN_DOIO_C
s	|void	|exec_failed	|NN const char *cmd|int fd|int do_report
#endif
#if defined(HAS_MSG) || defined(HAS_SEM) || defined(HAS_SHM)
p	|I32	|do_ipcctl	|I32 optype|NN SV** mark|NN SV** sp
p	|I32	|do_ipcget	|I32 optype|NN SV** mark|NN SV** sp
p	|I32	|do_msgrcv	|NN SV** mark|NN SV** sp
p	|I32	|do_msgsnd	|NN SV** mark|NN SV** sp
p	|I32	|do_semop	|NN SV** mark|NN SV** sp
p	|I32	|do_shmio	|I32 optype|NN SV** mark|NN SV** sp
#endif
Ap	|void	|do_join	|NN SV* sv|NN SV* del|NN SV** mark|NN SV** sp
p	|OP*	|do_kv
Apmb	|bool	|do_open	|NN GV* gv|NN char* name|I32 len|int as_raw \
				|int rawmode|int rawperm|NULLOK PerlIO* supplied_fp
Ap	|bool	|do_open9	|NN GV *gv|NN char *name|I32 len|int as_raw \
				|int rawmode|int rawperm|NULLOK PerlIO *supplied_fp \
				|NN SV *svs|I32 num
Ap	|bool	|do_openn	|NN GV *gv|NN char *name|I32 len|int as_raw \
				|int rawmode|int rawperm|NULLOK PerlIO *supplied_fp \
				|NULLOK SV **svp|I32 num
p	|void	|do_pipe	|NN SV* sv|NULLOK GV* rgv|NULLOK GV* wgv
p	|bool	|do_print	|NULLOK SV* sv|NN PerlIO* fp
pR	|OP*	|do_readline
p	|I32	|do_chomp	|NN SV* sv
p	|bool	|do_seek	|NULLOK GV* gv|Off_t pos|int whence
Ap	|void	|do_sprintf	|NN SV* sv|I32 len|NN SV** sarg
p	|Off_t	|do_sysseek	|NN GV* gv|Off_t pos|int whence
pR	|Off_t	|do_tell	|NN GV* gv
p	|I32	|do_trans	|NN SV* sv
p	|UV	|do_vecget	|NN SV* sv|I32 offset|I32 size
p	|void	|do_vecset	|NN SV* sv
p	|void	|do_vop		|I32 optype|NN SV* sv|NN SV* left|NN SV* right
p	|OP*	|dofile2	|NN OP* term|I32 force_builtin
p	|OP*	|dofile		|NN OP* term
ApR	|I32	|dowantarray
Ap	|void	|dump_all
Ap	|void	|dump_eval
#if defined(DUMP_FDS)
Ap	|void	|dump_fds	|NN char* s
#endif
Ap	|void	|dump_form	|NN GV* gv
Ap	|void	|gv_dump	|NN GV* gv
Ap	|void	|op_dump	|NN OP* arg
Ap	|void	|pmop_dump	|NULLOK PMOP* pm
Ap	|void	|dump_packsubs	|NN HV* stash
Ap	|void	|dump_sub	|NN GV* gv
Apd	|void	|fbm_compile	|NN SV* sv|U32 flags
ApdR	|char*	|fbm_instr	|NN unsigned char* big|NN unsigned char* bigend \
				|NN SV* littlesv|U32 flags
p	|char*	|find_script	|NN char *scriptname|bool dosearch \
				|NULLOK char **search_ext|I32 flags
#if defined(USE_5005THREADS)
p	|PADOFFSET|find_threadsv|NN const char *name
#endif
p	|OP*	|force_list	|NULLOK OP* arg
p	|OP*	|fold_constants	|NN OP* arg
Afpd	|char*	|form		|NN const char* pat|...
Ap	|char*	|vform		|NN const char* pat|NULLOK va_list* args
Ap	|void	|free_tmps
p	|OP*	|gen_constant_list|NULLOK OP* o
#if !defined(HAS_GETENV_LEN)
p	|char*	|getenv_len	|NN const char* key|NN unsigned long *len
#endif
pox	|void	|get_db_sub	|NULLOK SV **svp|NN CV *cv
Ap	|void	|gp_free	|NULLOK GV* gv
Ap	|GP*	|gp_ref		|NULLOK GP* gp
Ap	|GV*	|gv_AVadd	|NN GV* gv
Ap	|GV*	|gv_HVadd	|NN GV* gv
Ap	|GV*	|gv_IOadd	|NN GV* gv
ApR	|GV*	|gv_autoload4	|NULLOK HV* stash|NN const char* name|STRLEN len|I32 method
Ap	|void	|gv_check	|NN HV* stash
Ap	|void	|gv_efullname	|NN SV* sv|NN GV* gv
Apmb	|void	|gv_efullname3	|NN SV* sv|NN GV* gv|NULLOK const char* prefix
Ap	|void	|gv_efullname4	|NN SV* sv|NN GV* gv|NULLOK const char* prefix|bool keepmain
Ap	|GV*	|gv_fetchfile	|NN const char* name
Ap	|GV*	|gv_fetchfile_flags|NN const char *const name|const STRLEN len\
				|const U32 flags
Apd	|GV*	|gv_fetchmeth	|NULLOK HV* stash|NN const char* name|STRLEN len|I32 level
Apd	|GV*	|gv_fetchmeth_autoload	|NULLOK HV* stash|NN const char* name|STRLEN len|I32 level
Apdmb	|GV*	|gv_fetchmethod	|NULLOK HV* stash|NN const char* name
Apd	|GV*	|gv_fetchmethod_autoload|NULLOK HV* stash|NN const char* name|I32 autoload
Ap	|GV*	|gv_fetchpv	|NN const char* name|I32 add|I32 sv_type
Ap	|void	|gv_fullname	|NN SV* sv|NN GV* gv
Apmb	|void	|gv_fullname3	|NN SV* sv|NN GV* gv|NULLOK const char* prefix
Ap	|void	|gv_fullname4	|NN SV* sv|NN GV* gv|NULLOK const char* prefix|bool keepmain
pMox	|GP *	|newGP		|NN GV *const gv
Ap	|void	|gv_init	|NN GV* gv|NULLOK HV* stash|NN const char* name|STRLEN len|int multi
Ap	|void	|gv_name_set	|NN GV* gv|NULLOK const char *name|U32 len|U32 flags
Apd	|HV*	|gv_stashpv	|NN const char* name|I32 flags
Apd	|HV*	|gv_stashpvn	|NN const char* name|U32 namelen|I32 flags
Apd	|HV*	|gv_stashsv	|NULLOK SV* sv|I32 flags
Apd	|void	|hv_clear	|NULLOK HV* tb
Ap	|void	|hv_delayfree_ent|NN HV* hv|NULLOK HE* entry
Abmd	|SV*	|hv_delete	|NULLOK HV* tb|NN const char* key|I32 klen \
				|I32 flags
Abmd	|SV*	|hv_delete_ent	|NULLOK HV* tb|NN SV* key|I32 flags|U32 hash
AbmdR	|bool	|hv_exists	|NULLOK HV* tb|NN const char* key|I32 klen
AbmdR	|bool	|hv_exists_ent	|NULLOK HV* tb|NN SV* key|U32 hash
Abmd	|SV**	|hv_fetch	|NULLOK HV* tb|NN const char* key|I32 klen \
				|I32 lval
Abmd	|HE*	|hv_fetch_ent	|NULLOK HV* tb|NN SV* key|I32 lval|U32 hash
Ap	|void*	|hv_common	|NULLOK HV* tb|NULLOK SV* keysv \
				|NULLOK const char* key|STRLEN klen|int flags \
				|int action|NULLOK SV* val|U32 hash
Ap	|void*	|hv_common_key_len|NULLOK HV *hv|NN const char *key \
				|I32 klen_i32|const int action|NULLOK SV *val \
				|const U32 hash
Ap	|void	|hv_free_ent	|NN HV* hv|NULLOK HE* entryK
Apd	|I32	|hv_iterinit	|NN HV* tb
ApdR	|char*	|hv_iterkey	|NN HE* entry|NN I32* retlen
ApdR	|SV*	|hv_iterkeysv	|NN HE* entry
ApdRbm	|HE*	|hv_iternext	|NN HV* tb
ApdR	|SV*	|hv_iternextsv	|NN HV* hv|NN char** key|NN I32* retlen
ApMdR	|HE*	|hv_iternext_flags|NN HV* tb|I32 flags
ApdR	|SV*	|hv_iterval	|NN HV* tb|NN HE* entry
Ap	|void	|hv_ksplit	|NN HV* hv|IV newmax
Apdbm	|void	|hv_magic	|NN HV* hv|NULLOK GV* gv|int how
Abmd	|SV**	|hv_store	|NULLOK HV* tb|NULLOK const char* key \
				|I32 klen|NULLOK SV* val|U32 hash
Abmd	|HE*	|hv_store_ent	|NULLOK HV* tb|NULLOK SV* key|NULLOK SV* val|U32 hash
AbmdM	|SV**	|hv_store_flags	|NULLOK HV* tb|NULLOK const char* key \
				|I32 klen|NULLOK SV* val|U32 hash|int flags
Apd	|void	|hv_undef	|NULLOK HV* tb
ApP	|I32	|ibcmp		|NN const char* a|NN const char* b|I32 len
ApP	|I32	|ibcmp_locale	|NN const char* a|NN const char* b|I32 len
Apd	|I32	|ibcmp_utf8	|NN const char* a|NULLOK char **pe1|UV l1|bool u1 \
				|NN const char* b|NULLOK char **pe2|UV l2|bool u2
pR	|bool	|ingroup	|Gid_t testgid|Uid_t effective
p	|void	|init_argv_symbols|int argc|NN char **argv
p	|void	|init_debugger
Ap	|void	|init_stacks
Ap	|void	|init_tm	|NN struct tm *ptm
pd	|U32	|intro_my
ApPR	|char*	|instr		|NN const char* big|NN const char* little
p	|bool	|io_close	|NN IO* io|bool not_implicit
pR	|OP*	|invert		|NULLOK OP* cmd
dpR	|bool	|is_gv_magical	|NN char *name|STRLEN len|U32 flags
ApR	|I32	|is_lvalue_sub
ApPR	|U32	|to_uni_upper_lc|U32 c
ApPR	|U32	|to_uni_title_lc|U32 c
ApPR	|U32	|to_uni_lower_lc|U32 c
ApPR	|bool	|is_uni_alnum	|UV c
ApPR	|bool	|is_uni_alnumc	|UV c
ApPR	|bool	|is_uni_idfirst	|UV c
ApPR	|bool	|is_uni_alpha	|UV c
ApPR	|bool	|is_uni_ascii	|UV c
ApPR	|bool	|is_uni_space	|UV c
ApPR	|bool	|is_uni_cntrl	|UV c
ApPR	|bool	|is_uni_graph	|UV c
ApPR	|bool	|is_uni_digit	|UV c
ApPR	|bool	|is_uni_upper	|UV c
ApPR	|bool	|is_uni_lower	|UV c
ApPR	|bool	|is_uni_print	|UV c
ApPR	|bool	|is_uni_punct	|UV c
ApPR	|bool	|is_uni_xdigit	|UV c
Ap	|UV	|to_uni_upper	|UV c|NN U8 *p|NN STRLEN *lenp
Ap	|UV	|to_uni_title	|UV c|NN U8 *p|NN STRLEN *lenp
Ap	|UV	|to_uni_lower	|UV c|NN U8 *p|NN STRLEN *lenp
Ap	|UV	|to_uni_fold	|UV c|NN U8 *p|NN STRLEN *lenp
ApPR	|bool	|is_uni_alnum_lc|UV c
ApPR	|bool	|is_uni_alnumc_lc|UV c
ApPR	|bool	|is_uni_idfirst_lc|UV c
ApPR	|bool	|is_uni_alpha_lc|UV c
ApPR	|bool	|is_uni_ascii_lc|UV c
ApPR	|bool	|is_uni_space_lc|UV c
ApPR	|bool	|is_uni_cntrl_lc|UV c
ApPR	|bool	|is_uni_graph_lc|UV c
ApPR	|bool	|is_uni_digit_lc|UV c
ApPR	|bool	|is_uni_upper_lc|UV c
ApPR	|bool	|is_uni_lower_lc|UV c
ApPR	|bool	|is_uni_print_lc|UV c
ApPR	|bool	|is_uni_punct_lc|UV c
ApPR	|bool	|is_uni_xdigit_lc|UV c
Apd	|STRLEN	|is_utf8_char	|NN U8 *p
Apdbm	|bool	|is_utf8_string_loc|NN U8 *s|STRLEN len|NULLOK U8 **p
Apd	|bool	|is_utf8_string	|NN U8 *s|STRLEN len
ApR	|bool	|is_utf8_alnum	|NN U8 *p
ApR	|bool	|is_utf8_alnumc	|NN U8 *p
ApR	|bool	|is_utf8_idfirst|NN U8 *p
ApR	|bool	|is_utf8_idcont	|NN U8 *p
ApR	|bool	|is_utf8_alpha	|NN U8 *p
ApR	|bool	|is_utf8_ascii	|NN U8 *p
ApR	|bool	|is_utf8_space	|NN U8 *p
ApR	|bool	|is_utf8_cntrl	|NN U8 *p
ApR	|bool	|is_utf8_digit	|NN U8 *p
ApR	|bool	|is_utf8_graph	|NN U8 *p
ApR	|bool	|is_utf8_upper	|NN U8 *p
ApR	|bool	|is_utf8_lower	|NN U8 *p
ApR	|bool	|is_utf8_print	|NN U8 *p
ApR	|bool	|is_utf8_punct	|NN U8 *p
ApR	|bool	|is_utf8_xdigit	|NN U8 *p
ApR	|bool	|is_utf8_mark	|NN U8 *p
p	|OP*	|jmaybe		|NN OP* arg
pP	|I32	|keyword	|NN char* d|I32 len
Ap	|void	|leave_scope	|I32 base
EXp	|void	|lex_end
p	|void	|lex_start	|NULLOK SV* line
Ap	|void	|op_null	|NN OP* o
EXp	|void	|op_clear	|NN OP* o
p	|OP*	|linklist	|NN OP* o
p	|OP*	|list		|NULLOK OP* o
p	|OP*	|listkids	|NULLOK OP* o
Apd	|void	|load_module|U32 flags|NN SV* name|NULLOK SV* ver|...
Ap	|void	|vload_module|U32 flags|NN SV* name|NULLOK SV* ver|NULLOK va_list* args
p	|OP*	|localize	|NN OP* arg|I32 lexical
ApdR	|I32	|looks_like_number|NN SV* sv
Apd	|UV	|grok_bin	|NN char* start|NN STRLEN* len|NN I32* flags|NULLOK NV *result
Apd	|UV	|grok_hex	|NN char* start|NN STRLEN* len|NN I32* flags|NULLOK NV *result
Apd	|int	|grok_number	|NN const char *pv|STRLEN len|NULLOK UV *valuep
ApdR	|bool	|grok_numeric_radix|NN const char **sp|NN const char *send
Apd	|UV	|grok_oct	|NN char* start|NN STRLEN* len_p|NN I32* flags|NULLOK NV *result
p	|int	|magic_clearenv	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_clear_all_env|NN SV* sv|NN MAGIC* mg
p	|int	|magic_clearpack|NN SV* sv|NN MAGIC* mg
p	|int	|magic_clearsig	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_existspack|NN SV* sv|NN MAGIC* mg
p	|int	|magic_freeregexp|NN SV* sv|NN MAGIC* mg
p	|int	|magic_freeovrld|NN SV* sv|NN MAGIC* mg
p	|int	|magic_get	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_getarylen|NN SV* sv|NN MAGIC* mg
p	|int	|magic_getdefelem|NN SV* sv|NN MAGIC* mg
p	|int	|magic_getglob	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_getnkeys	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_getpack	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_getpos	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_getsig	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_getsubstr|NN SV* sv|NN MAGIC* mg
p	|int	|magic_gettaint	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_getuvar	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_getvec	|NN SV* sv|NN MAGIC* mg
p	|U32	|magic_len	|NN SV* sv|NN MAGIC* mg
#if defined(USE_5005THREADS)
p	|int	|magic_mutexfree|NULLOK SV* sv|NN MAGIC* mg
#endif
p	|int	|magic_nextpack	|NN SV* sv|NN MAGIC* mg|NN SV* key
p	|U32	|magic_regdata_cnt|NN SV* sv|NN MAGIC* mg
p	|int	|magic_regdatum_get|NN SV* sv|NN MAGIC* mg
pr	|int	|magic_regdatum_set|NN SV* sv|NN MAGIC* mg
p	|int	|magic_set	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setamagic|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setarylen|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setbm	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setdbline|NN SV* sv|NN MAGIC* mg
#if defined(USE_LOCALE_COLLATE)
p	|int	|magic_setcollxfrm|NN SV* sv|NN MAGIC* mg
#endif
p	|int	|magic_setdefelem|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setenv	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setfm	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setisa	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setglob	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setmglob	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setnkeys	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setpack	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setpos	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setregexp|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setsig	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setsubstr|NN SV* sv|NN MAGIC* mg
p	|int	|magic_settaint	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setuvar	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setvec	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_setutf8	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_set_all_env|NN SV* sv|NN MAGIC* mg
p	|U32	|magic_sizepack	|NN SV* sv|NN MAGIC* mg
p	|int	|magic_wipepack	|NN SV* sv|NN MAGIC* mg
p	|void	|magicname	|NN char* sym|NULLOK char* name|I32 namlen
Ap	|void	|markstack_grow
#if defined(USE_LOCALE_COLLATE)
p	|char*	|mem_collxfrm	|NN const char* s|STRLEN len|NN STRLEN* xlen
#endif
Afp	|SV*	|mess		|NN const char* pat|...
Ap	|SV*	|vmess		|NN const char* pat|NULLOK va_list* args
EXp	|void	|qerror		|NN SV* err
Apd	|void	|sortsv		|NN SV** array|size_t num_elts|NN SVCOMPARE_t cmp
Apd	|int	|mg_clear	|NN SV* sv
Apd	|int	|mg_copy	|NN SV* sv|NN SV* nsv|NULLOK const char* key|I32 klen
pd	|void	|mg_localize	|NN SV* sv|NN SV* nsv
ApdR	|MAGIC*	|mg_find	|NULLOK SV* sv|int type
Apd	|int	|mg_free	|NN SV* sv
Apd	|int	|mg_get		|NN SV* sv
Apd	|U32	|mg_length	|NN SV* sv
Apd	|void	|mg_magical	|NN SV* sv
Apd	|int	|mg_set		|NN SV* sv
Ap	|I32	|mg_size	|NN SV* sv
Ap	|void	|mini_mktime	|NN struct tm *pm
EXp	|OP*	|mod		|NULLOK OP* o|I32 type
p	|int	|mode_from_discipline|NULLOK SV* discp
Ap	|char*	|moreswitches	|NN char* s
p	|OP*	|my		|NN OP* o
Ap	|NV	|my_atof	|NN const char *s
#if (!defined(HAS_MEMCPY) && !defined(HAS_BCOPY)) || (!defined(HAS_MEMMOVE) && !defined(HAS_SAFE_MEMCPY) && !defined(HAS_SAFE_BCOPY))
Anp	|char*	|my_bcopy	|NN const char* from|NN char* to|I32 len
#endif
#if !defined(HAS_BZERO) && !defined(HAS_MEMSET)
Anp	|char*	|my_bzero	|NN char* loc|I32 len
#endif
Apr	|void	|my_exit	|U32 status
Apr	|void	|my_failure_exit
Ap	|I32	|my_fflush_all
Anp	|Pid_t	|my_fork
Anp	|void	|atfork_lock
Anp	|void	|atfork_unlock
Ap	|I32	|my_lstat
#if !defined(HAS_MEMCMP) || !defined(HAS_SANE_MEMCMP)
AnpP	|I32	|my_memcmp	|NN const char* s1|NN const char* s2|I32 len
#endif
#if !defined(HAS_MEMSET)
Anp	|void*	|my_memset	|NN char* loc|I32 ch|I32 len
#endif
Ap	|I32	|my_pclose	|NULLOK PerlIO* ptr
Ap	|PerlIO*|my_popen	|NN char* cmd|NN char* mode
Ap	|PerlIO*|my_popen_list	|NN char* mode|int n|NN SV ** args
Ap	|void	|my_setenv	|NULLOK char* nam|NULLOK char* val
Ap	|I32	|my_stat
Ap	|char *	|my_strftime	|NN char *fmt|int sec|int min|int hour|int mday|int mon|int year|int wday|int yday|int isdst
#if defined(MYSWAP)
ApPa	|short	|my_swap	|short s
ApPa	|long	|my_htonl	|long l
ApPa	|long	|my_ntohl	|long l
#endif
p	|void	|my_unexec
Apa	|OP*	|newANONLIST	|NULLOK OP* o
Apa	|OP*	|newANONHASH	|NULLOK OP* o
Ap	|OP*	|newANONSUB	|I32 floor|NULLOK OP* proto|NULLOK OP* block
Apa	|OP*	|newASSIGNOP	|I32 flags|NULLOK OP* left|I32 optype|NULLOK OP* right
Apa	|OP*	|newCONDOP	|I32 flags|NN OP* first|NULLOK OP* trueop|NULLOK OP* falseop
Apd	|CV*	|newCONSTSUB	|NULLOK HV* stash|NULLOK char* name|NULLOK SV* sv
Ap	|void	|newFORM	|I32 floor|NULLOK OP* o|NULLOK OP* block
Apa	|OP*	|newFOROP	|I32 flags|NULLOK char* label|line_t forline \
				|NULLOK OP* sv|NN OP* expr|NULLOK OP* block|NULLOK OP* cont
Apa	|OP*	|newLOGOP	|I32 optype|I32 flags|NN OP* left|NN OP* right
Apa	|OP*	|newLOOPEX	|I32 type|NN OP* label
Apa	|OP*	|newLOOPOP	|I32 flags|I32 debuggable|NULLOK OP* expr|NULLOK OP* block
Apa	|OP*	|newNULLLIST
Apa	|OP*	|newOP		|I32 optype|I32 flags
Ap	|void	|newPROG	|NN OP* o
Apa	|OP*	|newRANGE	|I32 flags|NN OP* left|NN OP* right
Apa	|OP*	|newSLICEOP	|I32 flags|NULLOK OP* subscript|NULLOK OP* listop
Apa	|OP*	|newSTATEOP	|I32 flags|NULLOK char* label|NULLOK OP* o
Ap	|CV*	|newSUB		|I32 floor|NULLOK OP* o|NULLOK OP* proto|NULLOK OP* block
ApM	|CV *	|newXS_flags	|NULLOK const char *name|NN XSUBADDR_t subaddr\
				|NN const char *const filename \
				|NULLOK const char *const proto|U32 flags
Apd	|CV*	|newXS		|NULLOK char* name|NN XSUBADDR_t f|NN char* filename
Apda	|AV*	|newAV
Apa	|OP*	|newAVREF	|NN OP* o
Apa	|OP*	|newBINOP	|I32 type|I32 flags|NULLOK OP* first|NULLOK OP* last
Apa	|OP*	|newCVREF	|I32 flags|NULLOK OP* o
Apa	|OP*	|newGVOP	|I32 type|I32 flags|NN GV* gv
Apa	|GV*	|newGVgen	|NN char* pack
Apa	|OP*	|newGVREF	|I32 type|NULLOK OP* o
ApaR	|OP*	|newHVREF	|NN OP* o
ApdaR	|HV*	|newHV
ApaR	|HV*	|newHVhv	|NULLOK HV* hv
Apa	|IO*	|newIO
Apa	|OP*	|newLISTOP	|I32 type|I32 flags|NULLOK OP* first|NULLOK OP* last
Apa	|OP*	|newPADOP	|I32 type|I32 flags|NN SV* sv
Apa	|OP*	|newPMOP	|I32 type|I32 flags
Apa	|OP*	|newPVOP	|I32 type|I32 flags|NULLOK char* pv
Apa	|SV*	|newRV		|NN SV* sv
Apda	|SV*	|newRV_noinc	|NN SV* sv
Apda	|SV*	|newSV		|STRLEN len
Apa	|OP*	|newSVREF	|NN OP* o
Apa	|OP*	|newSVOP	|I32 type|I32 flags|NN SV* sv
Apda	|SV*	|newSViv	|IV i
Apda	|SV*	|newSVuv	|UV u
Apda	|SV*	|newSVnv	|NV n
Apda	|SV*	|newSVpv	|NULLOK const char* s|STRLEN len
Apda	|SV*	|newSVpvn	|NULLOK const char* s|STRLEN len
Apda	|SV*	|newSVpvn_flags	|NULLOK const char* s|STRLEN len|U32 flags
Apda	|SV*	|newSVpvn_share	|NULLOK const char* s|I32 len|U32 hash
Afpda	|SV*	|newSVpvf	|NN const char* pat|...
Apa	|SV*	|vnewSVpvf	|NN const char* pat|NULLOK va_list* args
Apd	|SV*	|newSVrv	|NN SV* rv|NULLOK const char* classname
Apda	|SV*	|newSVsv	|NULLOK SV* old
Apda	|SV*	|newSV_type	|svtype type
Apa	|OP*	|newUNOP	|I32 type|I32 flags|NULLOK OP* first
AMpa	|OP*	|newWHILEOP	|I32 flags|I32 debuggable|NULLOK LOOP* loop \
				|I32 whileline|NULLOK OP* expr|NULLOK OP* block|NULLOK OP* cont
AMp	|OP*	|newWHILEOP8	|I32 flags|I32 debuggable|NULLOK LOOP* loop \
				|I32 whileline|NULLOK OP* expr \
				|NULLOK OP* block|NULLOK OP* cont|I32 has_my
Apa	|PERL_SI*|new_stackinfo|I32 stitems|I32 cxitems
Ap	|char*	|scan_vstring	|NN char *vstr|NN SV *sv
p	|PerlIO*|nextargv	|NN GV* gv
ApP	|char*	|ninstr		|NN const char* big|NN const char* bigend \
				|NN const char* little|NN const char* lend
pr	|OP*	|oopsCV		|NN OP* o
Ap	|void	|op_free	|NULLOK OP* arg
p	|void	|package	|NN OP* o
pd	|PADOFFSET|pad_alloc	|I32 optype|U32 tmptype
p	|PADOFFSET|allocmy	|NN char* name
pdR	|PADOFFSET|pad_findmy	|NN char* name
pR	|OP*	|oopsAV		|NN OP* o
pR	|OP*	|oopsHV		|NN OP* o
pd	|void	|pad_leavemy
Apd	|SV*	|pad_sv		|PADOFFSET po
pd	|void	|pad_free	|PADOFFSET po
pd	|void	|pad_reset
pd	|void	|pad_swipe	|PADOFFSET po|bool refadjust
p	|void	|peep		|NULLOK OP* o
dopM	|PerlIO*|start_glob	|NN SV* pattern|NN IO *io
#if defined(USE_5005THREADS)
Ap	|struct perl_thread*	|new_struct_thread|NN struct perl_thread *t
#endif
#if defined(USE_REENTRANT_API)
Ap	|void	|reentrant_size
Ap	|void	|reentrant_init
Ap	|void	|reentrant_free
Anp	|void*	|reentrant_retry|NN const char*|...
#endif
Ap	|void	|call_atexit	|ATEXIT_t fn|NULLOK void *ptr
Apd	|I32	|call_argv	|NN const char* sub_name|I32 flags|NN char** argv
Apd	|I32	|call_method	|NN const char* methname|I32 flags
Apd	|I32	|call_pv	|NN const char* sub_name|I32 flags
Apd	|I32	|call_sv	|NN SV* sv|VOL I32 flags
Ap	|void	|despatch_signals
Apd	|SV*	|eval_pv	|NN const char* p|I32 croak_on_error
Apd	|I32	|eval_sv	|NN SV* sv|I32 flags
Apd	|SV*	|get_sv		|NN const char* name|I32 create
Apd	|AV*	|get_av		|NN const char* name|I32 create
Apd	|HV*	|get_hv		|NN const char* name|I32 create
Apd	|CV*	|get_cv		|NN const char* name|I32 flags
Apd	|CV*	|get_cvn_flags	|NN const char* name|STRLEN len|I32 flags
Ap	|int	|init_i18nl10n	|int printwarn
Ap	|int	|init_i18nl14n	|int printwarn
Ap	|void	|new_collate	|NULLOK char* newcoll
Ap	|void	|new_ctype	|NN char* newctype
Ap	|void	|new_numeric	|NULLOK char* newcoll
Ap	|void	|set_numeric_local
Ap	|void	|set_numeric_radix
Ap	|void	|set_numeric_standard
Apd	|void	|require_pv	|NN const char* pv
Apd	|void	|pack_cat	|NN SV *cat|NN char *pat|NN char *patend \
				|NN SV **beglist|NN SV **endlist|NN SV ***next_in_list|U32 flags
Apd	|void	|packlist 	|NN SV *cat|NN char *pat|NN char *patend|NN SV **beglist|NN SV **endlist
p	|void	|pidgone	|Pid_t pid|int status
Ap	|void	|pmflag		|NN U32* pmfl|int ch
p	|OP*	|pmruntime	|NN OP* pm|NN OP* expr|NULLOK OP* repl
p	|OP*	|pmtrans	|NN OP* o|NN OP* expr|NN OP* repl
EXp	|OP*	|pop_return
Ap	|void	|pop_scope
p	|OP*	|prepend_elem	|I32 optype|NULLOK OP* head|NULLOK OP* tail
p	|void	|push_return	|NULLOK OP* o
Ap	|void	|push_scope
p	|OP*	|ref		|NULLOK OP* o|I32 type
p	|OP*	|refkids	|NULLOK OP* o|I32 type
Ap	|void	|regdump	|NN const regexp* r
Ap	|SV*	|regclass_swash	|NN struct regnode *n|bool doinit|NULLOK SV **listsvp|NULLOK SV **altsvp
Ap	|I32	|pregexec	|NN regexp* prog|NN char* stringarg \
				|NN char* strend|NN char* strbeg|I32 minend \
				|NN SV* screamer|U32 nosave
Ap	|void	|pregfree	|NULLOK struct regexp* r
#if defined(USE_ITHREADS)
Ap	|regexp*|regdupe	|NN const regexp* r|NN CLONE_PARAMS* param
#endif
Ap	|regexp*|pregcomp	|NN char* exp|NN char* xend|NN PMOP* pm
Ap	|char*	|re_intuit_start|NN regexp* prog|NULLOK SV* sv|NN char* strpos \
				|NN char* strend|U32 flags \
				|NULLOK struct re_scream_pos_data_s *data
Ap	|SV*	|re_intuit_string|NN regexp* prog
Ap	|I32	|regexec_flags	|NN regexp* prog|NN char* stringarg \
				|NN char* strend|NN char* strbeg|I32 minend \
				|NN SV* screamer|NULLOK void* data|U32 flags
ApR	|regnode*|regnext	|NN regnode* p
Ep	|void	|regprop	|NN SV* sv|NN regnode* o
Ap	|void	|repeatcpy	|NN char* to|NN const char* from|I32 len|I32 count
ApP	|char*	|rninstr	|NN const char* big|NN const char* bigend \
				|NN const char* little|NN const char* lend
Ap	|Sighandler_t|rsignal	|int i|Sighandler_t t
p	|int	|rsignal_restore|int i|NULLOK Sigsave_t* t
p	|int	|rsignal_save	|int i|Sighandler_t t1|NN Sigsave_t* t2
Ap	|Sighandler_t|rsignal_state|int i
p	|void	|rxres_free	|NN void** rsp
p	|void	|rxres_restore	|NN void** rsp|NN REGEXP* prx
p	|void	|rxres_save	|NN void** rsp|NN REGEXP* prx
#if !defined(HAS_RENAME)
p	|I32	|same_dirent	|NN char* a|NN char* b
#endif
Apda	|char*	|savepv		|NULLOK const char* pv
Apda	|char*	|savepvn	|NULLOK const char* pv|I32 len
Apda	|char*	|savesharedpv	|NULLOK const char* pv
Apda	|char*	|savesharedpvn	|NN const char *const pv|const STRLEN len
Ap	|void	|savestack_grow
Ap	|void	|savestack_grow_cnt	|I32 need
Ap	|void	|save_aelem	|NN AV* av|I32 idx|NN SV **sptr
Ap	|I32	|save_alloc	|I32 size|I32 pad
Ap	|void	|save_aptr	|NN AV** aptr
Ap	|AV*	|save_ary	|NN GV* gv
Ap	|void	|save_bool	|NN bool* boolp
Ap	|void	|save_clearsv	|NN SV** svp
Ap	|void	|save_delete	|NN HV* hv|NN char* key|I32 klen
Ap	|void	|save_destructor|DESTRUCTORFUNC_NOCONTEXT_t f|NN void* p
Ap	|void	|save_destructor_x|DESTRUCTORFUNC_t f|NULLOK void* p
Ap	|void	|save_freesv	|NULLOK SV* sv
p	|void	|save_freeop	|NULLOK OP* o
Ap	|void	|save_freepv	|NULLOK char* pv
Ap	|void	|save_generic_svref|NN SV** sptr
Ap	|void	|save_generic_pvref|NN char** str
Ap	|void	|save_shared_pvref|NN char** str
Ap	|void	|save_gp	|NN GV* gv|I32 empty
Ap	|HV*	|save_hash	|NN GV* gv
Ap	|void	|save_helem	|NN HV* hv|NN SV *key|NN SV **sptr
Apr	|void	|save_hints
Ap	|void	|save_hptr	|NN HV** hptr
Ap	|void	|save_I16	|NN I16* intp
Ap	|void	|save_I32	|NN I32* intp
Ap	|void	|save_I8	|NN I8* bytep
Ap	|void	|save_int	|NN int* intp
Ap	|void	|save_item	|NN SV* item
Ap	|void	|save_iv	|NN IV* iv
Ap	|void	|save_list	|NN SV** sarg|I32 maxsarg
Ap	|void	|save_long	|NN long* longp
Ap	|void	|save_mortalizesv|NN SV* sv
Ap	|void	|save_nogv	|NULLOK GV* gv
p	|void	|save_op
Ap	|SV*	|save_scalar	|NN GV* gv
Ap	|void	|save_pptr	|NN char** pptr
Ap	|void	|save_vptr	|NN void* pptr
Ap	|void	|save_re_context
Ap	|void	|save_padsv	|PADOFFSET off
Ap	|void	|save_padsv_and_mortalize|PADOFFSET off
Ap	|void	|save_sptr	|NN SV** sptr
Ap	|SV*	|save_svref	|NN SV** sptr
#ifdef USE_5005THREADS
Ap	|SV**	|save_threadsv	|PADOFFSET i
#else
Apr	|SV**	|save_threadsv	|PADOFFSET i
#endif
p	|OP*	|sawparens	|NULLOK OP* o
p	|OP*	|scalar		|NULLOK OP* o
p	|OP*	|scalarkids	|NULLOK OP* o
p	|OP*	|scalarseq	|NULLOK OP* o
p	|OP*	|scalarvoid	|NN OP* o
Apd	|NV	|scan_bin	|NN char* start|STRLEN len|NN STRLEN* retlen
Apd	|NV	|scan_hex	|NN char* start|STRLEN len|NN STRLEN* retlen
Ap	|char*	|scan_num	|NN char* s|NN YYSTYPE *lvalp
Apd	|NV	|scan_oct	|NN char* start|STRLEN len|NN STRLEN* retlen
p	|OP*	|scope		|NULLOK OP* o
Ap	|char*	|screaminstr	|NN SV *bigstr|NN SV *littlestr|I32 start_shift \
				|I32 end_shift|NN I32 *oldposp|I32 last
#if !defined(VMS)
p	|I32	|setenv_getix	|NN char* nam
#endif
EXp	|void	|setdefout	|NULLOK GV* gv
Ap	|HEK*	|share_hek	|NN const char* str|I32 len|U32 hash
np	|Signal_t |sighandler	|int sig
Anp	|Signal_t |csighandler	|int sig
Ap	|SV**	|stack_grow	|NN SV** sp|NN SV** p|int n
Ap	|I32	|start_subparse	|I32 is_format|U32 flags
p	|void	|sub_crush_depth|NN CV* cv
Apd	|bool	|sv_2bool	|NN SV* sv
Apd	|CV*	|sv_2cv		|NULLOK SV* sv|NN HV** st|NN GV** gvp|I32 lref
Apd	|IO*	|sv_2io		|NN SV* sv
Amb	|IV	|sv_2iv		|NN SV* sv
Apd	|IV	|sv_2iv_flags	|NN SV* sv|I32 flags
Apd	|SV*	|sv_2mortal	|NULLOK SV* sv
Apd	|NV	|sv_2nv		|NN SV* sv
pMd	|SV*	|sv_2num	|NN SV* sv
Amb	|char*	|sv_2pv		|NN SV* sv|NULLOK STRLEN* lp
Apd	|char*	|sv_2pvutf8	|NN SV* sv|NULLOK STRLEN* lp
Apd	|char*	|sv_2pvbyte	|NN SV* sv|NULLOK STRLEN* lp
Ap	|char*	|sv_pvn_nomg	|NN SV* sv|NULLOK STRLEN* lp
Amb	|UV	|sv_2uv		|NN SV* sv
Apd	|UV	|sv_2uv_flags	|NN SV* sv|I32 flags
Apd	|IV	|sv_iv		|NN SV* sv
Apd	|UV	|sv_uv		|NN SV* sv
Apd	|NV	|sv_nv		|NN SV* sv
Apd	|char*	|sv_pvn		|NN SV *sv|NN STRLEN *len
Apd	|char*	|sv_pvutf8n	|NN SV *sv|NN STRLEN *len
Apd	|char*	|sv_pvbyten	|NN SV *sv|NN STRLEN *len
Apd	|I32	|sv_true	|NULLOK SV *sv
pd	|void	|sv_add_arena	|NN char* ptr|U32 size|U32 flags
Apd	|int	|sv_backoff	|NN SV* sv
Apd	|SV*	|sv_bless	|NN SV* sv|NN HV* stash
Afpd	|void	|sv_catpvf	|NN SV* sv|NN const char* pat|...
Apd	|void	|sv_vcatpvf	|NN SV* sv|NN const char* pat|NULLOK va_list* args
Apd	|void	|sv_catpv	|NN SV* sv|NN const char* ptr
Amdb	|void	|sv_catpvn	|NN SV* sv|NN const char* ptr|STRLEN len
Amdb	|void	|sv_catsv	|NN SV* dsv|NULLOK SV* ssv
Apd	|void	|sv_chop	|NN SV* sv|NULLOK char* ptr
pd	|I32	|sv_clean_all
pd	|void	|sv_clean_objs
Apd	|void	|sv_clear	|NN SV* sv
Apd	|I32	|sv_cmp		|NN SV* sv1|NN SV* sv2
Apd	|I32	|sv_cmp_locale	|NN SV* sv1|NN SV* sv2
#if defined(USE_LOCALE_COLLATE)
Apd	|char*	|sv_collxfrm	|NN SV* sv|NN STRLEN* nxp
#endif
Ap	|OP*	|sv_compile_2op	|NN SV* sv|NN OP** startp|NN char* code|NN PAD** padp
Apd	|int	|getcwd_sv	|NN SV* sv
Apd	|void	|sv_dec		|NN SV* sv
Ap	|void	|sv_dump	|NN SV* sv
ApdR	|bool	|sv_derived_from|NN SV* sv|NN const char* name
Apd	|I32	|sv_eq		|NULLOK SV* sv1|NULLOK SV* sv2
Apd	|void	|sv_free	|NULLOK SV* sv
pd	|void	|sv_free_arenas
Apd	|char*	|sv_gets	|NN SV* sv|NN PerlIO* fp|I32 append
Apd	|char*	|sv_grow	|NN SV* sv|STRLEN newlen
Apd	|void	|sv_inc		|NN SV* sv
Apd	|void	|sv_insert	|NN SV* bigsv|STRLEN offset|STRLEN len \
				|NN char* little|STRLEN littlelen
Apd	|int	|sv_isa		|NULLOK SV* sv|NN const char* name
Apd	|int	|sv_isobject	|NULLOK SV* sv
Apd	|STRLEN	|sv_len		|NULLOK SV* sv
Apd	|STRLEN	|sv_len_utf8	|NULLOK SV* sv
Apd	|void	|sv_magic	|NN SV* sv|NULLOK SV* obj|int how|NULLOK const char* name \
				|I32 namlen
Apd	|MAGIC *|sv_magicext	|NN SV* sv|NULLOK SV* obj|int how|NULLOK MGVTBL *vtbl \
				|NULLOK const char* name|I32 namlen
ApdaR	|SV*	|sv_mortalcopy	|NULLOK SV* oldsv
ApdR	|SV*	|sv_newmortal
Apd	|SV*	|sv_newref	|NULLOK SV* sv
Ap	|char*	|sv_peek	|NULLOK SV* sv
Apd	|void	|sv_pos_u2b	|NULLOK SV* sv|NN I32* offsetp|NULLOK I32* lenp
Apd	|void	|sv_pos_b2u	|NULLOK SV* sv|NN I32* offsetp
Amdb	|char*	|sv_pvn_force	|NN SV* sv|NULLOK STRLEN* lp
Apd	|char*	|sv_pvutf8n_force|NN SV* sv|NULLOK STRLEN* lp
Apd	|char*	|sv_pvbyten_force|NN SV* sv|NULLOK STRLEN* lp
Apd	|char*	|sv_recode_to_utf8	|NN SV* sv|NN SV *encoding
Apd	|bool	|sv_cat_decode	|NN SV* dsv|NN SV *encoding|NN SV *ssv|NN int *offset \
				|NN char* tstr|int tlen
ApdR	|char*	|sv_reftype	|NN SV* sv|int ob
Apd	|void	|sv_replace	|NN SV* sv|NN SV* nsv
Apd	|void	|sv_report_used
Apd	|void	|sv_reset	|NN char* s|NULLOK HV* stash
Afpd	|void	|sv_setpvf	|NN SV* sv|NN const char* pat|...
Apd	|void	|sv_vsetpvf	|NN SV* sv|NN const char* pat|NULLOK va_list* args
Apd	|void	|sv_setiv	|NN SV* sv|IV num
Apdb	|void	|sv_setpviv	|NN SV* sv|IV num
Apd	|void	|sv_setuv	|NN SV* sv|UV num
Apd	|void	|sv_setnv	|NN SV* sv|NV num
Apd	|SV*	|sv_setref_iv	|NN SV* rv|NULLOK const char* classname|IV iv
Apd	|SV*	|sv_setref_uv	|NN SV* rv|NULLOK const char* classname|UV uv
Apd	|SV*	|sv_setref_nv	|NN SV* rv|NULLOK const char* classname|NV nv
Apd	|SV*	|sv_setref_pv	|NN SV* rv|NULLOK const char* classname|NULLOK void* pv
Apd	|SV*	|sv_setref_pvn	|NN SV* rv|NULLOK const char* classname|NN char* pv|STRLEN n
Apd	|void	|sv_setpv	|NN SV* sv|NULLOK const char* ptr
Apd	|void	|sv_setpvn	|NN SV* sv|NULLOK const char* ptr|STRLEN len
Amdb	|void	|sv_setsv	|NN SV* dsv|NULLOK SV* ssv
Amdb	|void	|sv_taint	|NN SV* sv
ApdR	|bool	|sv_tainted	|NN SV* sv
Apd	|int	|sv_unmagic	|NN SV* sv|int type
Apdmb	|void	|sv_unref	|NN SV* sv
Apd	|void	|sv_unref_flags	|NN SV* sv|U32 flags
Apd	|void	|sv_untaint	|NN SV* sv
Apd	|bool	|sv_upgrade	|NN SV* sv|U32 mt
Apdmb	|void	|sv_usepvn	|NN SV* sv|NULLOK char* ptr|STRLEN len
Apd	|void	|sv_usepvn_flags|NN SV* sv|NULLOK char* ptr|STRLEN len\
				|U32 flags
Apd	|void	|sv_vcatpvfn	|NN SV* sv|NN const char* pat|STRLEN patlen \
				|NULLOK va_list* args|NULLOK SV** svargs|I32 svmax \
				|NULLOK bool *maybe_tainted
Apd	|void	|sv_vsetpvfn	|NN SV* sv|NN const char* pat|STRLEN patlen \
				|NULLOK va_list* args|NULLOK SV** svargs|I32 svmax \
				|NULLOK bool *maybe_tainted
ApR	|NV	|str_to_version	|NN SV *sv
Ap	|SV*	|swash_init	|NN char* pkg|NN char* name|NN SV* listsv|I32 minbits|I32 none
Ap	|UV	|swash_fetch	|NN SV *swash|NN U8 *ptr|bool do_utf8
Ap	|void	|taint_env
Ap	|void	|taint_proper	|NULLOK const char* f|NN const char* s
Apd	|UV	|to_utf8_case	|NN U8 *p|NN U8* ustrp|NULLOK STRLEN *lenp \
				|NN SV **swashp|NN char *normal|NN char *special
Apd	|UV	|to_utf8_lower	|NN U8 *p|NN U8* ustrp|NULLOK STRLEN *lenp
Apd	|UV	|to_utf8_upper	|NN U8 *p|NN U8* ustrp|NULLOK STRLEN *lenp
Apd	|UV	|to_utf8_title	|NN U8 *p|NN U8* ustrp|NULLOK STRLEN *lenp
Apd	|UV	|to_utf8_fold	|NN U8 *p|NN U8* ustrp|NULLOK STRLEN *lenp
#if defined(UNLINK_ALL_VERSIONS)
Ap	|I32	|unlnk		|NN char* f
#endif
#if defined(USE_5005THREADS)
Ap	|void	|unlock_condpair|NN void* svv
#endif
Apd	|I32	|unpack_str	|NN char *pat|NN char *patend|NN char *s \
				|NULLOK char *strbeg|NN char *strend|NULLOK char **new_s \
				|I32 ocnt|U32 flags
Apd	|I32	|unpackstring	|NN char *pat|NN char *patend|NN char *s \
				|NN char *strend|U32 flags
Ap	|void	|unsharepvn	|NULLOK const char* sv|I32 len|U32 hash
p	|void	|unshare_hek	|NULLOK HEK* hek
p	|void	|utilize	|int aver|I32 floor|NULLOK OP* version|NN OP* idop|NULLOK OP* arg
Ap	|U8*	|utf16_to_utf8	|NN U8* p|NN U8 *d|I32 bytelen|NN I32 *newlen
Ap	|U8*	|utf16_to_utf8_reversed|NN U8* p|NN U8 *d|I32 bytelen|NN I32 *newlen
AdpPR	|STRLEN	|utf8_length	|NN U8* s|NN U8 *e
ApdPR	|IV	|utf8_distance	|NN U8 *a|NN U8 *b
ApdPR	|U8*	|utf8_hop	|NN U8 *s|I32 off
ApMd	|U8*	|utf8_to_bytes	|NN U8 *s|NN STRLEN *len
ApMd	|U8*	|bytes_from_utf8|NN U8 *s|NN STRLEN *len|NULLOK bool *is_utf8
ApMd	|U8*	|bytes_to_utf8	|NN U8 *s|NN STRLEN *len
Apd	|UV	|utf8_to_uvchr	|NN U8 *s|NULLOK STRLEN *retlen
Apd	|UV	|utf8_to_uvuni	|NN U8 *s|NULLOK STRLEN *retlen

#ifdef EBCDIC
Adp	|UV	|utf8n_to_uvchr	|NN U8 *s|STRLEN curlen|NULLOK STRLEN *retlen|U32 flags
#else
Adpbm	|UV	|utf8n_to_uvchr	|NN U8 *s|STRLEN curlen|NULLOK STRLEN *retlen|U32 flags
#endif

Adp	|UV	|utf8n_to_uvuni	|NN U8 *s|STRLEN curlen|NULLOK STRLEN *retlen|U32 flags

#ifdef EBCDIC
Apd	|U8*	|uvchr_to_utf8	|NN U8 *d|UV uv
#else
Apdbm	|U8*	|uvchr_to_utf8	|NN U8 *d|UV uv
#endif

Apbm	|U8*	|uvuni_to_utf8	|NN U8 *d|UV uv
Ap	|U8*	|uvchr_to_utf8_flags	|NN U8 *d|UV uv|UV flags
Apd	|U8*	|uvuni_to_utf8_flags	|NN U8 *d|UV uv|UV flags
Apd	|char*	|pv_uni_display	|NN SV *dsv|NN U8 *spv|STRLEN len \
				|STRLEN pvlim|UV flags
ApdR	|char*	|sv_uni_display	|NN SV *dsv|NN SV *ssv|STRLEN pvlim|UV flags
EXp	|void	|vivify_defelem	|NN SV* sv
p	|void	|vivify_ref	|NN SV* sv|U32 to_what
p	|I32	|wait4pid	|Pid_t pid|NN int* statusp|int flags
p	|U32	|parse_unicode_opts|NN char **popt
Ap	|U32	|seed
pR	|UV	|get_hash_seed
p	|void	|report_evil_fh	|NULLOK GV *gv|NULLOK IO *io|I32 op
pd	|void	|report_uninit
Afpd	|void	|warn		|NN const char* pat|...
Ap	|void	|vwarn		|NN const char* pat|NULLOK va_list* args
Afp	|void	|warner		|U32 err|NN const char* pat|...
Ap	|void	|vwarner	|U32 err|NN const char* pat|NULLOK va_list* args
p	|void	|watch		|NN char** addr
Ap	|I32	|whichsig	|NN char* sig
p	|void	|write_to_stderr|NN const char* message|int msglen
p	|int	|yyerror	|NN char* s
#ifdef USE_PURE_BISON
p	|int	|yylex_r	|NULLOK YYSTYPE *lvalp|NULLOK int *lcharp
#endif
EXp	|int	|yylex
p	|int	|yyparse
p	|int	|yywarn		|NN char* s
#if defined(MYMALLOC)
Ap	|void	|dump_mstats	|NN char* s
Ap	|int	|get_mstats	|NN perl_mstats_t *buf|int buflen|int level
#endif
Anpa	|Malloc_t|safesysmalloc	|MEM_SIZE nbytes
Anpa	|Malloc_t|safesyscalloc	|MEM_SIZE elements|MEM_SIZE size
Anpa	|Malloc_t|safesysrealloc|Malloc_t where|MEM_SIZE nbytes
Anp	|Free_t	|safesysfree	|Malloc_t where
#if defined(PERL_GLOBAL_STRUCT)
Ap	|struct perl_vars *|GetVars
#endif
Ap	|int	|runops_standard
Ap	|int	|runops_debug
#if defined(USE_5005THREADS)
Ap	|SV*	|sv_lock	|NN SV *sv
#endif
Afpd	|void	|sv_catpvf_mg	|NN SV *sv|NN const char* pat|...
Apd	|void	|sv_vcatpvf_mg	|NN SV* sv|NN const char* pat|NULLOK va_list* args
Apd	|void	|sv_catpv_mg	|NN SV *sv|NN const char *ptr
Apdbm	|void	|sv_catpvn_mg	|NN SV *sv|NN const char *ptr|STRLEN len
Apdbm	|void	|sv_catsv_mg	|NN SV *dstr|NULLOK SV *sstr
Afpd	|void	|sv_setpvf_mg	|NN SV *sv|NN const char* pat|...
Apd	|void	|sv_vsetpvf_mg	|NN SV* sv|NN const char* pat|NULLOK va_list* args
Apd	|void	|sv_setiv_mg	|NN SV *sv|IV i
Apdb	|void	|sv_setpviv_mg	|NN SV *sv|IV iv
Apd	|void	|sv_setuv_mg	|NN SV *sv|UV u
Apd	|void	|sv_setnv_mg	|NN SV *sv|NV num
Apd	|void	|sv_setpv_mg	|NN SV *sv|NULLOK const char *ptr
Apd	|void	|sv_setpvn_mg	|NN SV *sv|NN const char *ptr|STRLEN len
Apd	|void	|sv_setsv_mg	|NN SV *dstr|NULLOK SV *sstr
Apdbm	|void	|sv_usepvn_mg	|NN SV *sv|NULLOK char *ptr|STRLEN len
ApR	|MGVTBL*|get_vtbl	|int vtbl_id
Apd	|char*	|pv_display	|NN SV *dsv|NN char *pv|STRLEN cur|STRLEN len \
				|STRLEN pvlim
Apd	|char*	|pv_escape	|NN SV *dsv|NN char const * const str\
                                |const STRLEN count|const STRLEN max\
                                |NULLOK STRLEN * const escaped\
                                |const U32 flags				
Apd     |char*  |pv_pretty      |NN SV *dsv|NN char const * const str\
                                |const STRLEN count|const STRLEN max\
                                |NULLOK char const * const start_color\
                                |NULLOK char const * const end_color\
                                |const U32 flags				
Afp	|void	|dump_indent	|I32 level|NN PerlIO *file|NN const char* pat|...
Ap	|void	|dump_vindent	|I32 level|NN PerlIO *file|NN const char* pat \
				|NULLOK va_list *args
Ap	|void	|do_gv_dump	|I32 level|NN PerlIO *file|NN char *name|NULLOK GV *sv
Ap	|void	|do_gvgv_dump	|I32 level|NN PerlIO *file|NN char *name|NULLOK GV *sv
Ap	|void	|do_hv_dump	|I32 level|NN PerlIO *file|NN char *name|NULLOK HV *sv
Ap	|void	|do_magic_dump	|I32 level|NN PerlIO *file|NN MAGIC *mg|I32 nest \
				|I32 maxnest|bool dumpops|STRLEN pvlim
Ap	|void	|do_op_dump	|I32 level|NN PerlIO *file|NULLOK OP *o
Ap	|void	|do_pmop_dump	|I32 level|NN PerlIO *file|NULLOK PMOP *pm
Ap	|void	|do_sv_dump	|I32 level|NN PerlIO *file|NULLOK SV *sv|I32 nest \
				|I32 maxnest|bool dumpops|STRLEN pvlim
Ap	|void	|magic_dump	|NULLOK MAGIC *mg
#if defined(PERL_FLEXIBLE_EXCEPTIONS)
Ap	|void*	|default_protect|NN volatile JMPENV *je|NN int *excpt \
				|protect_body_t body|...
Ap	|void*	|vdefault_protect|NN volatile JMPENV *je|NN int *excpt \
				|protect_body_t body|NN va_list *args
#endif
Ap	|void	|reginitcolors
ApdRmb	|char*	|sv_2pv_nolen	|NN SV* sv
ApdRmb	|char*	|sv_2pvutf8_nolen|NN SV* sv
ApdRmb	|char*	|sv_2pvbyte_nolen|NN SV* sv
AmdbR	|char*	|sv_pv		|NN SV *sv
AmdbR	|char*	|sv_pvutf8	|NN SV *sv
AmdbR	|char*	|sv_pvbyte	|NN SV *sv
Amdb	|STRLEN	|sv_utf8_upgrade|NN SV *sv
ApdM	|bool	|sv_utf8_downgrade|NN SV *sv|bool fail_ok
Apd	|void	|sv_utf8_encode |NN SV *sv
ApdM	|bool	|sv_utf8_decode |NN SV *sv
Apdmb	|void	|sv_force_normal|NN SV *sv
Apd	|void	|sv_force_normal_flags|NN SV *sv|U32 flags
Ap	|void	|tmps_grow	|I32 n
Apd	|SV*	|sv_rvweaken	|NN SV *sv
p	|int	|magic_killbackrefs|NN SV *sv|NN MAGIC *mg
Ap	|OP*	|newANONATTRSUB	|I32 floor|NULLOK OP *proto|NULLOK OP *attrs|NULLOK OP *block
Ap	|CV*	|newATTRSUB	|I32 floor|NULLOK OP *o|NULLOK OP *proto|NULLOK OP *attrs|NULLOK OP *block
Apr	|void	|newMYSUB	|I32 floor|NULLOK OP *o|NULLOK OP *proto|NULLOK OP *attrs|NULLOK OP *block
p	|OP *	|my_attrs	|NN OP *o|NULLOK OP *attrs
p	|void	|boot_core_xsutils
#if defined(USE_ITHREADS)
ApR	|PERL_CONTEXT*|cx_dup	|NULLOK PERL_CONTEXT* cx|I32 ix|I32 max|NN CLONE_PARAMS* param
ApR	|PERL_SI*|si_dup	|NULLOK PERL_SI* si|NN CLONE_PARAMS* param
Apa	|ANY*	|ss_dup		|NN PerlInterpreter* proto_perl|NN CLONE_PARAMS* param
ApR	|void*	|any_dup	|NULLOK void* v|NN PerlInterpreter* proto_perl
ApR	|HE*	|he_dup		|NULLOK HE* e|bool shared|NN CLONE_PARAMS* param
Apa	|REGEXP*|re_dup		|NULLOK REGEXP* r|NN CLONE_PARAMS* param
Ap	|PerlIO*|fp_dup		|NULLOK PerlIO* fp|char type|NN CLONE_PARAMS* param
ApR	|DIR*	|dirp_dup	|NULLOK DIR* dp
ApR	|GP*	|gp_dup		|NULLOK GP* gp|NN CLONE_PARAMS* param
ApR	|MAGIC*	|mg_dup		|NULLOK MAGIC* mg|NN CLONE_PARAMS* param
ApR	|SV*	|sv_dup		|NULLOK SV* sstr|NN CLONE_PARAMS* param
Ap	|void	|rvpv_dup	|NN SV* dstr|NN SV *sstr|NN CLONE_PARAMS* param
#endif
Apa	|PTR_TBL_t*|ptr_table_new
ApaR	|void*	|ptr_table_fetch|NN PTR_TBL_t *tbl|NN void *sv
Ap	|void	|ptr_table_store|NN PTR_TBL_t *tbl|NULLOK void *oldsv|NN void *newsv
Ap	|void	|ptr_table_split|NN PTR_TBL_t *tbl
Ap	|void	|ptr_table_clear|NULLOK PTR_TBL_t *tbl
Ap	|void	|ptr_table_free|NULLOK PTR_TBL_t *tbl
#if defined(USE_ITHREADS)
#  if defined(HAVE_INTERP_INTERN)
Ap	|void	|sys_intern_dup	|NN struct interp_intern* src \
				|NN struct interp_intern* dst
#  endif
#endif
#if defined(HAVE_INTERP_INTERN)
Ap	|void	|sys_intern_clear
Ap	|void	|sys_intern_init
#endif

ApR	|char *	|custom_op_name	|NN OP* op
ApR	|char *	|custom_op_desc	|NN OP* op

Adp	|void	|sv_nosharing	|NULLOK SV *sv
Adpbm	|void	|sv_nolocking	|NULLOK SV *sv
Adp	|bool	|sv_destroyable	|NULLOK SV *sv
#ifdef NO_MATHOMS
Adpbm	|void	|sv_nounlocking	|NULLOK SV *sv
#else
Adpb	|void	|sv_nounlocking	|NULLOK SV *sv
#endif
Adp	|int	|nothreadhook

END_EXTERN_C

#if defined(PERL_IN_AV_C) || defined(PERL_DECL_PROT)
s	|I32	|avhv_index_sv	|NN SV* sv
s	|I32	|avhv_index	|NULLOK AV* av|NN SV* sv|U32 hash
#endif

#if defined(PERL_IN_DOOP_C) || defined(PERL_DECL_PROT)
sR	|I32	|do_trans_simple	|NN SV * const sv
sR	|I32	|do_trans_count		|NN SV * const sv
sR	|I32	|do_trans_complex	|NN SV * const sv
sR	|I32	|do_trans_simple_utf8	|NN SV * const sv
sR	|I32	|do_trans_count_utf8	|NN SV * const sv
sR	|I32	|do_trans_complex_utf8	|NN SV * const sv
#endif

#if defined(PERL_IN_GV_C) || defined(PERL_DECL_PROT)
s	|void	|gv_init_sv	|NN GV *gv|I32 sv_type
s	|void	|require_errno	|NN GV *gv
#endif

: #if defined(PERL_IN_HV_C) || defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
paRxo	|void*	|get_arena	|size_t svtype|U32 misc
: #endif

#if defined(PERL_IN_HV_C) || defined(PERL_DECL_PROT)
s	|void	|hsplit		|NN HV *hv
s	|void	|hfreeentries	|NN HV *hv
sa	|HE*	|new_he
sanR	|HEK*	|save_hek_flags	|NN const char *str|I32 len|U32 hash|int flags
sn	|void	|hv_magic_check	|NN HV *hv|NN bool *needs_copy|NN bool *needs_store
s	|void	|unshare_hek_or_pvn|NULLOK const HEK* hek|NULLOK const char* str|I32 len|U32 hash
sR	|HEK*	|share_hek_flags|NN const char* str|I32 len|U32 hash|int flags
rs	|void	|hv_notallowed	|int flags|NN const char *key|I32 klen|NN const char *msg
#endif

#if defined(PERL_IN_MG_C) || defined(PERL_DECL_PROT)
s	|void	|save_magic	|I32 mgs_ix|NN SV *sv
s	|int	|magic_methpack	|NN SV *sv|NN const MAGIC *mg|NN const char *meth
s	|int	|magic_methcall	|NN SV *sv|NN const MAGIC *mg|NN const char *meth|I32 f \
				|int n|NULLOK SV *val
s	|void	|restore_magic	|NN const void *p
s	|void	|unwind_handler_stack|NN const void *p

#endif

#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
sRn	|bool	|is_handle_constructor|NN const OP *o|I32 numargs
sR	|I32	|is_list_assignment|NULLOK const OP *o
s	|void	|cop_free	|NN COP *cop
s	|OP*	|modkids	|NULLOK OP *o|I32 type
s	|OP*	|scalarboolean	|NN OP *o
sR	|OP*	|newDEFSVOP
sR	|OP*	|new_logop	|I32 type|I32 flags|NN OP **firstp|NN OP **otherp
s	|void	|simplify_sort	|NN OP *o
s	|const char*	|gv_ename	|NN GV *gv
sRn	|bool	|scalar_mod_type|NN const OP *o|I32 type
s	|OP *	|my_kid		|NULLOK OP *o|NULLOK OP *attrs|NN OP **imopsp
s	|OP *	|dup_attrlist	|NN OP *o
s	|void	|apply_attrs	|NN HV *stash|NN SV *target|NULLOK OP *attrs|bool for_my
s	|void	|apply_attrs_my	|NN HV *stash|NN OP *target|NULLOK OP *attrs|NN OP **imopsp
s	|void	|bad_type	|I32 n|NN const char *t|NN const char *name|NN const OP *kid
s	|void	|no_bareword_allowed|NN const OP *o
sR	|OP*	|no_fh_allowed|NN OP *o
sR	|OP*	|too_few_arguments|NN OP *o|NN const char* name
sR	|OP*	|too_many_arguments|NN OP *o|NN const char* name
#if defined(PERL_FLEXIBLE_EXCEPTIONS)
s	|void*	|vcall_runops	|va_list args
#endif
s	|void	|process_special_blocks	|NN const char *const fullname\
					|NN GV *const gv|NN CV *const cv
#endif
#if defined(PL_OP_SLAB_ALLOC)
Apa	|void*	|Slab_Alloc	|int m|size_t sz
Ap	|void	|Slab_Free	|NN void *op
#endif

#if defined(PERL_IN_PERL_C) || defined(PERL_DECL_PROT)
s	|void	|find_beginning	|NN SV* linestr_sv
s	|void	|forbid_setid	|const char flag|const bool suidscript
s	|void	|incpush	|NULLOK const char *dir|bool addsubdirs|bool addoldvers|bool usesep|bool canrelocate
s	|void	|init_interp
s	|void	|init_ids
s	|void	|init_main_stash
s	|void	|init_perllib
s	|void	|init_postdump_symbols|int argc|NN char **argv|NULLOK char **env
s	|void	|init_predump_symbols
rs	|void	|my_exit_jump
s	|void	|nuke_stacks
s	|int	|open_script	|NN const char *scriptname|bool dosearch \
				|NN SV *sv|NN bool *suidscript
s	|void	|usage		|NN const char *name
#ifdef DOSUID
#  ifdef IAMSUID
so	|void	|validate_suid	|NN const char *validarg \
				|int fdscript \
				|bool suidscript|NN SV* linestr_sv
#else
so	|void	|validate_suid	|NN const char *validarg \
				|NN const char *scriptname|int fdscript \
				|NN SV* linestr_sv
#  endif
#else
#  ifndef SETUID_SCRIPTS_ARE_SECURE_NOW
so	|void	|validate_suid
#  endif
#endif

#  if defined(IAMSUID)
s	|int	|fd_on_nosuid_fs|int fd
#  endif
s	|void*	|parse_body	|NULLOK char **env|XSINIT_t xsinit
rs	|void	|run_body	|I32 oldscope
s	|void	|call_body	|NN const OP *myop|bool is_eval
s	|void*	|call_list_body	|NN CV *cv
s	|SV *	|incpush_if_exists|NN SV *dir
#if defined(PERL_FLEXIBLE_EXCEPTIONS)
s	|void*	|vparse_body	|va_list args
s	|void*	|vrun_body	|va_list args
s	|void*	|vcall_body	|va_list args
s	|void*	|vcall_list_body|va_list args
#endif
#  if defined(USE_5005THREADS)
s	|struct perl_thread *	|init_main_thread
#  endif
#endif

#if defined(PERL_IN_PP_C) || defined(PERL_DECL_PROT)
sR	|SV*	|refto		|NN SV* sv
#endif
#if defined(PERL_IN_PP_C) || defined(PERL_IN_PP_HOT_C) || defined(PERL_DECL_PROT)
pRxo	|GV*	|softref2xv	|NN SV *const sv|NN const char *const what \
				|const U32 type|NN SV ***spp
#endif

#if defined(PERL_IN_PP_PACK_C) || defined(PERL_DECL_PROT)
s	|I32	|unpack_rec	|NN struct tempsym* symptr|NN const char *s \
				|NN const char *strbeg|NN const char *strend \
				|NULLOK const char **new_s
s	|SV **	|pack_rec	|NN SV *cat|NN struct tempsym* symptr \
				|NN SV **beglist|NN SV **endlist
s	|SV*	|mul128		|NN SV *sv|U8 m
s	|I32	|measure_struct	|NN struct tempsym* symptr
s	|bool	|next_symbol	|NN struct tempsym* symptr
sR	|SV*	|is_an_int	|NN const char *s|STRLEN l
s	|int	|div128		|NN SV *pnum|NN bool *done
s	|const char *|group_end	|NN const char *pat|NN const char *patend \
				|char ender
s	|const char *|get_num	|NN const char *ppat|NN I32 *lenptr
sR	|char *	|sv_exp_grow	|NN SV *sv|STRLEN needed
snR	|char *	|bytes_to_uni	|NN const U8 *start|STRLEN len|NN char *dest
#endif

#if defined(PERL_IN_PP_CTL_C) || defined(PERL_DECL_PROT)
sR	|OP*	|docatch	|NULLOK OP *o
s	|void	|docatch_body
#if defined(PERL_FLEXIBLE_EXCEPTIONS)
s	|void*	|vdocatch_body	|va_list args
#endif
sR	|OP*	|dofindlabel	|NN OP *o|NN const char *label|NN OP **opstack|NN OP **oplimit
sR	|OP*	|doparseform	|NN SV *sv
snR	|bool	|num_overflow	|NV value|I32 fldsize|I32 frcsize
sR	|I32	|dopoptoeval	|I32 startingblock
sR	|I32	|dopoptolabel	|NN const char *label
sR	|I32	|dopoptoloop	|I32 startingblock
sR	|I32	|dopoptosub_at	|NN const PERL_CONTEXT* cxstk|I32 startingblock
s	|void	|save_lines	|NULLOK AV *array|NN SV *sv
s	|bool	|doeval		|int gimme|NULLOK OP** startop|NULLOK CV* outside|U32 seq
sR	|PerlIO *|check_type_and_open|NN const char *name
#ifndef PERL_DISABLE_PMC
sR	|PerlIO *|doopen_pm	|NN const char *name|const STRLEN namelen
#endif
sRn	|bool	|path_is_absolute|NN const char *name
sR	|I32	|run_user_filter|int idx|NN SV *buf_sv|int maxlen
#endif

#if defined(PERL_IN_PP_HOT_C) || defined(PERL_DECL_PROT)
s	|int	|do_maybe_phash	|NN AV *ary|NN SV **lelem|NN SV **firstlelem \
				|NN SV **relem|NN SV **lastrelem
s	|void	|do_oddball	|NN HV *hash|NN SV **relem|NN SV **firstrelem
sR	|SV*	|method_common	|NN SV* meth|NULLOK U32* hashp
#endif

#if defined(PERL_IN_PP_SORT_C) || defined(PERL_DECL_PROT)
s	|I32	|sv_ncmp	|NN SV *a|NN SV *b
s	|I32	|sv_i_ncmp	|NN SV *a|NN SV *b
s	|I32	|amagic_ncmp	|NN SV *a|NN SV *b
s	|I32	|amagic_i_ncmp	|NN SV *a|NN SV *b
s	|I32	|amagic_cmp	|NN SV *a|NN SV *b
s	|I32	|amagic_cmp_locale|NN SV *a|NN SV *b
s	|I32	|sortcv		|NN SV *a|NN SV *b
s	|I32	|sortcv_xsub	|NN SV *a|NN SV *b
s	|I32	|sortcv_stacked	|NN SV *a|NN SV *b
s	|void	|qsortsvu	|NN SV** array|size_t num_elts|NN SVCOMPARE_t compare
#endif

#if defined(PERL_IN_PP_SYS_C) || defined(PERL_DECL_PROT)
s	|OP*	|doform		|NN CV *cv|NN GV *gv|NN OP *retop
#  if !defined(HAS_MKDIR) || !defined(HAS_RMDIR)
sR	|int	|dooneliner	|NN const char *cmd|NN const char *filename
#  endif
s	|SV *	|space_join_names_mortal|NN char *const *array
#endif

#if defined(PERL_IN_REGCOMP_C) || defined(PERL_DECL_PROT)
Es	|regnode*|reg		|NN struct RExC_state_t *state|I32 paren|NN I32 *flagp
Es	|regnode*|reganode	|NN struct RExC_state_t *state|U8 op|U32 arg
Es	|regnode*|regatom	|NN struct RExC_state_t *state|NN I32 *flagp
Es	|regnode*|regbranch	|NN struct RExC_state_t *state|NN I32 *flagp|I32 first
Es	|STRLEN	|reguni		|NN const struct RExC_state_t *state|UV uv|NN char *s
Es	|regnode*|regclass	|NN struct RExC_state_t *state
ERsn	|I32	|regcurly	|NN const char *
Es	|regnode*|reg_node	|NN struct RExC_state_t *state|U8 op
Es	|UV	|reg_recode	|const char value|NN SV **encp
Es	|regnode*|regpiece	|NN struct RExC_state_t *state|NN I32 *flagp
Es	|void	|reginsert	|NN struct RExC_state_t *state|U8 op|NN regnode *opnd
Es	|void	|regtail	|NN const struct RExC_state_t *state|NN regnode *p|NN const regnode *val
EsRn	|char*	|regwhite	|NN char *p|NN const char *e
Es	|char*	|nextchar	|NN struct RExC_state_t *state
#  ifdef DEBUGGING
Es	|const regnode*|dumpuntil|NN const regnode *start \
				|NN const regnode *node \
				|NULLOK const regnode *last|NN SV* sv|I32 l
Es	|void	|put_byte	|NN SV* sv|int c
#  endif
Es	|void	|scan_commit	|NN const struct RExC_state_t* state|NN struct scan_data_t *data
Esn	|void	|cl_anything	|NN const struct RExC_state_t* state|NN struct regnode_charclass_class *cl
EsRn	|int	|cl_is_anything	|NN const struct regnode_charclass_class *cl
Esn	|void	|cl_init	|NN const struct RExC_state_t* state|NN struct regnode_charclass_class *cl
Esn	|void	|cl_init_zero	|NN const struct RExC_state_t* state|NN struct regnode_charclass_class *cl
Esn	|void	|cl_and		|NN struct regnode_charclass_class *cl \
				|NN const struct regnode_charclass_class *and_with
Esn	|void	|cl_or		|NN const struct RExC_state_t* state|NN struct regnode_charclass_class *cl \
				|NN const struct regnode_charclass_class *or_with
Es	|I32	|study_chunk	|NN struct RExC_state_t* state|NN regnode **scanp \
				|NN I32 *deltap|NN regnode *last|NULLOK struct scan_data_t *data \
				|U32 flags
EsRn	|U32	|add_data	|NN struct RExC_state_t* state|U32 n|NN const char *s
rs	|void	|re_croak2	|NN const char* pat1|NN const char* pat2|...
Es	|I32	|regpposixcc	|NN struct RExC_state_t* state|I32 value
Es	|void	|checkposixcc	|NN struct RExC_state_t* state
#endif

#if defined(PERL_IN_REGEXEC_C) || defined(PERL_DECL_PROT)
ERs	|I32	|regmatch	|NN regnode *prog
ERs	|I32	|regrepeat	|NN const regnode *p|I32 max
ERs	|I32	|regtry		|NN regexp *prog|NN char *startpos
ERs	|bool	|reginclass	|NN const regnode *n|NN const U8 *p|NULLOK STRLEN *lenp\
				|bool do_utf8sv_is_utf8
Es	|CHECKPOINT|regcppush	|I32 parenfloor
Es	|char*|regcppop
Es	|void	|cache_re	|NN regexp *prog
ERsn	|U8*	|reghop3	|NN U8 *pos|I32 off|NN const U8 *lim
ERsn	|U8*	|reghopmaybe3	|NN U8 *pos|I32 off|NN const U8 *lim
ERs	|char*	|find_byclass	|NN regexp * prog|NN const regnode *c|NN char *s|NN const char *strend|I32 norun
Es	|void	|to_utf8_substr	|NN regexp * prog
Es	|void	|to_byte_substr	|NN regexp * prog
#endif

#if defined(PERL_IN_DUMP_C) || defined(PERL_DECL_PROT)
s	|CV*	|deb_curcv	|const I32 ix
s	|void	|debprof	|NN const OP *o
s	|SV*	|pm_description	|NN const PMOP *pm
#endif

#if defined(PERL_IN_SCOPE_C) || defined(PERL_DECL_PROT)
s	|SV*	|save_scalar_at	|NN SV **sptr
#endif

#if defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
nsR	|char *	|uiv_2buf	|NN char *buf|IV iv|UV uv|int is_uv|NN char **peob
s	|void	|sv_unglob	|NN SV* sv
s	|void	|not_a_number	|NN SV *sv
s	|I32	|visit		|NN SVFUNC_t f|U32 flags|U32 mask
s	|void	|sv_add_backref	|NN SV *tsv|NN SV *sv
s	|void	|sv_del_backref	|NN SV *sv
#  ifdef DEBUGGING
s	|void	|del_sv	|NN SV *p
#  endif
#  if !defined(NV_PRESERVES_UV)
#    ifdef DEBUGGING
s	|int	|sv_2iuv_non_preserve	|NN SV *sv|I32 numtype
#    else
s	|int	|sv_2iuv_non_preserve	|NN SV *sv
#    endif
#  endif
sR	|I32	|expect_number	|NN char** pattern
#
sn	|STRLEN	|sv_pos_u2b_forwards|NN const U8 *const start \
		|NN const U8 *const send|STRLEN uoffset
sn	|STRLEN	|sv_pos_u2b_midway|NN const U8 *const start \
		|NN const U8 *send|STRLEN uoffset|STRLEN uend
s	|STRLEN	|sv_pos_u2b_cached|NN SV *sv|NN MAGIC **mgp \
		|NN const U8 *const start|NN const U8 *const send \
		|STRLEN uoffset|STRLEN uoffset0|STRLEN boffset0
s	|void	|utf8_mg_pos_cache_update|NN SV *sv|NN MAGIC **mgp \
		|STRLEN byte|STRLEN utf8|STRLEN blen
s	|STRLEN	|sv_pos_b2u_midway|NN const U8 *s|NN const U8 *const target \
		|NN const U8 *end|STRLEN endu
s	|char *	|stringify_regexp|NN SV *sv|NN MAGIC *mg|NULLOK STRLEN *lp
sn	|char *	|F0convert	|NV nv|NN char *endbuf|NN STRLEN *len
s	|SV *	|more_sv
s	|void *	|more_bodies	|svtype sv_type
s	|bool	|sv_2iuv_common	|NN SV *sv
s	|void	|glob_assign_glob|NN SV *dstr|NN SV *sstr|const int dtype
s	|void	|glob_assign_ref|NN SV *dstr|NN SV *sstr
sRn	|PTR_TBL_ENT_t *|ptr_table_find|NN PTR_TBL_t *tbl|NN const void *sv
s	|U32	|process_sub	|NN CV *const current_sub|U32 how_many_in_pad \
				|NN const SV *const target|NN SV *const rv \
				|const bool on
s	|void	|reset_amagic	|NN SV *rv|const bool on
#endif

#if defined(PERL_IN_TOKE_C) || defined(PERL_DECL_PROT)
s	|void	|check_uni
s	|void	|force_next	|I32 type
s	|char*	|force_version	|NN char *start|int guessing
s	|char*	|force_word	|NN char *start|int token|int check_keyword \
				|int allow_pack|int allow_tick
s	|SV*	|tokeq		|NN SV *sv
sR	|char*	|scan_const	|NN char *start
sR	|char*	|scan_formline	|NN char *s
sR	|char*	|scan_heredoc	|NN char *s
s	|char*	|scan_ident	|NN char *s|NN const char *send|NN char *dest \
				|STRLEN destlen|I32 ck_uni
sR	|char*	|scan_inputsymbol|NN char *start
sR	|char*	|scan_pat	|NN char *start|I32 type
sR	|char*	|scan_str	|NN char *start|int keep_quoted|int keep_delims
sR	|char*	|scan_subst	|NN char *start
sR	|char*	|scan_trans	|NN char *start
s	|char*	|scan_word	|NN char *s|NN char *dest|STRLEN destlen \
				|int allow_package|NN STRLEN *slp
s	|void	|update_debugger_info|NULLOK SV *orig_sv \
				|NULLOK const char *buf|STRLEN len
sR	|char*	|skipspace	|NN char *s
sR	|char*	|swallow_bom	|NN U8 *s
s	|void	|checkcomma	|NN const char *s|NN const char *name \
				|NN const char *what
s	|void	|force_ident	|NN const char *s|int kind
s	|void	|incline	|NN const char *s
s	|int	|intuit_method	|NN char *s|NULLOK GV *gv|NULLOK CV *cv
s	|int	|intuit_more	|NN char *s
s	|I32	|lop		|I32 f|int x|NN char *s
rs	|void	|missingterm	|NULLOK char *s
s	|void	|no_op		|NN const char *what|NULLOK char *s
sR	|I32	|sublex_done
sR	|I32	|sublex_push
sR	|I32	|sublex_start
sR	|char *	|filter_gets	|NN SV *sv|NN PerlIO *fp|STRLEN append
sR	|HV *	|find_in_my_stash|NN const char *pkgname|STRLEN len
sR	|char *	|tokenize_use	|int is_use|NN char *s
so	|SV*	|new_constant	|NULLOK const char *s|STRLEN len \
				|NN const char *key|STRLEN keylen|NN SV *sv \
				|NULLOK SV *pv|NULLOK const char *type \
				|STRLEN typelen
s	|int	|ao		|int toketype
#  if defined(PERL_CR_FILTER)
s	|I32	|cr_textfilter	|int idx|NULLOK SV *sv|int maxlen
s	|void	|strip_return	|NN SV *sv
#  endif
#  if defined(DEBUGGING)
s	|int	|tokereport	|I32 rv
s	|void	|printbuf	|NN const char* fmt|NN const char* s
#  endif
#endif

#if defined(PERL_IN_UNIVERSAL_C) || defined(PERL_DECL_PROT)
s	|bool|isa_lookup	|NN HV *stash|NN const char *name|NULLOK const HV * const name_stash|int len|int level
#endif

#if defined(PERL_IN_LOCALE_C) || defined(PERL_DECL_PROT)
s	|char*	|stdize_locale	|NN char* locs
#endif

#if defined(PERL_IN_UTIL_C) || defined(PERL_DECL_PROT)
s	|const COP*|closest_cop	|NN const COP *cop|NULLOK const OP *o
s	|SV*	|mess_alloc
xo	|const char *|vdie_croak_common|NULLOK const char *pat|NULLOK va_list *args \
				|NULLOK STRLEN *msglen|NULLOK I32* utf8
s	|bool	|vdie_common	|NULLOK const char *message|STRLEN msglen\
				|I32 utf8|bool warn
sr	|char *	|write_no_mem
#endif

#if defined(PERL_IN_NUMERIC_C) || defined(PERL_DECL_PROT)
sn	|NV|mulexp10	|NV value|I32 exponent
#endif

#if defined(PERL_IN_UTF8_C) || defined(PERL_DECL_PROT)
sRn	|STRLEN	|is_utf8_char_slow|NN const U8 *s|const STRLEN len
sR	|bool	|is_utf8_common	|NN const U8 *const p|NN SV **swash|NN const char * const swashname
sR	|SV*	|swash_get	|NN SV* swash|UV start|UV span
#endif

START_EXTERN_C

Apd	|void	|sv_setsv_flags	|NN SV* dsv|NULLOK SV* ssv|I32 flags
Apd	|void	|sv_catpvn_flags|NN SV* sv|NN const char* ptr|STRLEN len|I32 flags
Apd	|void	|sv_catsv_flags	|NN SV* dsv|NULLOK SV* ssv|I32 flags
Apd	|STRLEN	|sv_utf8_upgrade_flags|NN SV *sv|I32 flags
Apd	|char*	|sv_pvn_force_flags|NN SV* sv|NULLOK STRLEN* lp|I32 flags
Apd	|char*	|sv_2pv_flags	|NN SV* sv|NULLOK STRLEN* lp|I32 flags
Apd	|void	|sv_copypv	|NN SV* dsv|NN SV* ssv
Ap	|char*	|my_atof2	|NN const char *s|NN NV* value
Apn	|int	|my_socketpair	|int family|int type|int protocol|int fd[2]
Ap	|int	|my_dirfd	|NULLOK DIR* dir

#if defined(USE_PERLIO) && !defined(USE_SFIO)
Ap	|int	|PerlIO_close		|NULLOK PerlIO *f
Ap	|int	|PerlIO_fill		|NULLOK PerlIO *f
Ap	|int	|PerlIO_fileno		|NULLOK PerlIO *f
Ap	|int	|PerlIO_eof		|NULLOK PerlIO *f
Ap	|int	|PerlIO_error		|NULLOK PerlIO *f
Ap	|int	|PerlIO_flush		|NULLOK PerlIO *f
Ap	|void	|PerlIO_clearerr	|NULLOK PerlIO *f
Ap	|void	|PerlIO_set_cnt		|NULLOK PerlIO *f|int cnt
Ap	|void	|PerlIO_set_ptrcnt	|NULLOK PerlIO *f|NN STDCHAR *ptr|int cnt
Ap	|void	|PerlIO_setlinebuf	|NULLOK PerlIO *f
Ap	|SSize_t|PerlIO_read		|NULLOK PerlIO *f|NN void *buf|Size_t count
Ap	|SSize_t|PerlIO_write		|NULLOK PerlIO *f|NN const void *buf|Size_t count
Ap	|SSize_t|PerlIO_unread		|NULLOK PerlIO *f|NN const void *buf|Size_t count
Ap	|Off_t	|PerlIO_tell		|NULLOK PerlIO *f
Ap	|int	|PerlIO_seek		|NULLOK PerlIO *f|Off_t offset|int whence

Ap	|STDCHAR *|PerlIO_get_base	|NULLOK PerlIO *f
Ap	|STDCHAR *|PerlIO_get_ptr	|NULLOK PerlIO *f
ApR	|int	  |PerlIO_get_bufsiz	|NULLOK PerlIO *f
ApR	|int	  |PerlIO_get_cnt	|NULLOK PerlIO *f

ApR	|PerlIO *|PerlIO_stdin
ApR	|PerlIO *|PerlIO_stdout
ApR	|PerlIO *|PerlIO_stderr
#endif /* PERLIO_LAYERS */

p	|void	|deb_stack_all
#ifdef PERL_IN_DEB_C
s	|void	|deb_stack_n	|NN SV** stack_base|I32 stack_min \
				|I32 stack_max|I32 mark_min|I32 mark_max
#endif

pda	|PADLIST*|pad_new	|int flags
pd	|void	|pad_undef	|NN CV* cv
pd	|PADOFFSET|pad_add_name	|NN char *name\
				|NULLOK HV* typestash|NULLOK HV* ourstash|bool clone
pd	|PADOFFSET|pad_add_anon	|NN SV* sv|OPCODE op_type
pd	|void	|pad_check_dup	|NN char* name|bool is_our|NN HV* ourstash
#ifdef DEBUGGING
pd	|void	|pad_setsv	|PADOFFSET po|NN SV* sv
#endif
pd	|void	|pad_block_start|int full
pd	|void	|pad_tidy	|padtidy_type type
pd 	|void	|do_dump_pad	|I32 level|NN PerlIO *file|NULLOK PADLIST *padlist|int full
pd	|void	|pad_fixup_inner_anons|NN PADLIST *padlist|NN CV *old_cv|NN CV *new_cv

pdX	|void	|pad_push	|NN PADLIST *padlist|int depth|int has_args
pR	|HV*	|pad_compname_type|const PADOFFSET po

#if defined(PERL_IN_PAD_C) || defined(PERL_DECL_PROT)
sd	|PADOFFSET|pad_findlex	|NN const char* name|PADOFFSET newoff\
				|NN const CV* innercv
#  if defined(DEBUGGING)
sd	|void	|cv_dump	|NN const CV *cv|NN const char *title
#  endif
s	|CV*	|cv_clone2	|NN CV *proto|NULLOK CV *outside
#endif
ApdR	|CV*	|find_runcv	|NULLOK U32 *db_seqp
p	|void	|free_tied_hv_pool
#if defined(DEBUGGING)
pR	|int	|get_debug_opts	|NN char **s
#endif

Apd	|void	|hv_clear_placeholders|NN HV* hb

#if defined(PERL_IN_HV_C) || defined(PERL_DECL_PROT)
sM	|SV*	|hv_delete_common|NULLOK HV* tb|NULLOK SV* key_sv|NULLOK const char* key|STRLEN klen|int k_flags|I32 d_flags|U32 hash
#endif
ApdR	|SV*	|hv_scalar	|NN HV* hv|
p	|SV*	|magic_scalarpack|NN HV* hv|NN MAGIC* mg

#if defined(DEBUGGING)
p	|int	|get_debug_opts_flags	|NN char **s|int flags
#endif

Ap	|void	|op_refcnt_lock
Ap	|void	|op_refcnt_unlock
Apda	|char*	|savesvpv	|NN SV* sv

#ifdef PERL_NEED_MY_HTOLE16
np	|U16	|my_htole16	|U16 n
#endif
#ifdef PERL_NEED_MY_LETOH16
np	|U16	|my_letoh16	|U16 n
#endif
#ifdef PERL_NEED_MY_HTOBE16
np	|U16	|my_htobe16	|U16 n
#endif
#ifdef PERL_NEED_MY_BETOH16
np	|U16	|my_betoh16	|U16 n
#endif
#ifdef PERL_NEED_MY_HTOLE32
np	|U32	|my_htole32	|U32 n
#endif
#ifdef PERL_NEED_MY_LETOH32
np	|U32	|my_letoh32	|U32 n
#endif
#ifdef PERL_NEED_MY_HTOBE32
np	|U32	|my_htobe32	|U32 n
#endif
#ifdef PERL_NEED_MY_BETOH32
np	|U32	|my_betoh32	|U32 n
#endif
#ifdef PERL_NEED_MY_HTOLE64
np	|U64	|my_htole64	|U64 n
#endif
#ifdef PERL_NEED_MY_LETOH64
np	|U64	|my_letoh64	|U64 n
#endif
#ifdef PERL_NEED_MY_HTOBE64
np	|U64	|my_htobe64	|U64 n
#endif
#ifdef PERL_NEED_MY_BETOH64
np	|U64	|my_betoh64	|U64 n
#endif

#ifdef PERL_NEED_MY_HTOLES
np	|short	|my_htoles	|short n
#endif
#ifdef PERL_NEED_MY_LETOHS
np	|short	|my_letohs	|short n
#endif
#ifdef PERL_NEED_MY_HTOBES
np	|short	|my_htobes	|short n
#endif
#ifdef PERL_NEED_MY_BETOHS
np	|short	|my_betohs	|short n
#endif
#ifdef PERL_NEED_MY_HTOLEI
np	|int	|my_htolei	|int n
#endif
#ifdef PERL_NEED_MY_LETOHI
np	|int	|my_letohi	|int n
#endif
#ifdef PERL_NEED_MY_HTOBEI
np	|int	|my_htobei	|int n
#endif
#ifdef PERL_NEED_MY_BETOHI
np	|int	|my_betohi	|int n
#endif
#ifdef PERL_NEED_MY_HTOLEL
np	|long	|my_htolel	|long n
#endif
#ifdef PERL_NEED_MY_LETOHL
np	|long	|my_letohl	|long n
#endif
#ifdef PERL_NEED_MY_HTOBEL
np	|long	|my_htobel	|long n
#endif
#ifdef PERL_NEED_MY_BETOHL
np	|long	|my_betohl	|long n
#endif

np	|void	|my_swabn	|NN void* ptr|int n

#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
ApR	|OP*	|ck_anoncode	|NN OP *o
ApR	|OP*	|ck_bitop	|NN OP *o
ApR	|OP*	|ck_concat	|NN OP *o
ApR	|OP*	|ck_defined	|NN OP *o
ApR	|OP*	|ck_delete	|NN OP *o
ApR	|OP*	|ck_die		|NN OP *o
ApR	|OP*	|ck_eof		|NN OP *o
ApR	|OP*	|ck_eval	|NN OP *o
ApR	|OP*	|ck_exec	|NN OP *o
ApR	|OP*	|ck_exists	|NN OP *o
ApR	|OP*	|ck_exit	|NN OP *o
ApR	|OP*	|ck_ftst	|NN OP *o
ApR	|OP*	|ck_fun		|NN OP *o
ApR	|OP*	|ck_glob	|NN OP *o
ApR	|OP*	|ck_grep	|NN OP *o
ApR	|OP*	|ck_index	|NN OP *o
ApR	|OP*	|ck_join	|NN OP *o
ApR	|OP*	|ck_lengthconst	|NN OP *o
ApR	|OP*	|ck_lfun	|NN OP *o
ApR	|OP*	|ck_listiob	|NN OP *o
ApR	|OP*	|ck_match	|NN OP *o
ApR	|OP*	|ck_method	|NN OP *o
ApR	|OP*	|ck_null	|NN OP *o
ApR	|OP*	|ck_open	|NN OP *o
ApR	|OP*	|ck_repeat	|NN OP *o
ApR	|OP*	|ck_require	|NN OP *o
ApR	|OP*	|ck_return	|NN OP *o
ApR	|OP*	|ck_rfun	|NN OP *o
ApR	|OP*	|ck_rvconst	|NN OP *o
ApR	|OP*	|ck_sassign	|NN OP *o
ApR	|OP*	|ck_select	|NN OP *o
ApR	|OP*	|ck_shift	|NN OP *o
ApR	|OP*	|ck_sort	|NN OP *o
ApR	|OP*	|ck_spair	|NN OP *o
ApR	|OP*	|ck_split	|NN OP *o
ApR	|OP*	|ck_subr	|NN OP *o
ApR	|OP*	|ck_substr	|NN OP *o
ApR	|OP*	|ck_svconst	|NN OP *o
ApR	|OP*	|ck_trunc	|NN OP *o
#endif

Apd	|bool	|is_utf8_string_loclen|NN const U8 *s|STRLEN len|NULLOK const U8 **ep|NULLOK STRLEN *el
Apda	|SV*	|newSVhek	|NULLOK const HEK *hek
ApR	|bool	|stashpv_hvname_match|NN const COP *cop|NN const HV *hv

p	|void	|offer_nice_chunk	|NN void *chunk|U32 chunk_size


#ifdef DEBUG_LEAKING_SCALARS_FORK_DUMP
p	|void	|dump_sv_child	|NN SV *sv
#endif

Apod	|void	|hv_assert	|NN HV* tb

#ifdef PERL_DONT_CREATE_GVSV
Ap	|GV*	|gv_SVadd	|NN GV* gv
#endif
Apo	|bool	|ckwarn		|U32 w
Apo	|bool	|ckwarn_d	|U32 w

px	|void	|my_clearenv

#ifndef HAS_STRLCAT
Apno	|Size_t	|my_strlcat	|NULLOK char *dst|NULLOK const char *src|Size_t size
#endif

#ifndef HAS_STRLCPY
Apno     |Size_t |my_strlcpy     |NULLOK char *dst|NULLOK const char *src|Size_t size
#endif

Ap	|GV*	|gv_fetchpvn_flags|NN const char* name|STRLEN len|I32 flags|I32 sv_type
Ap	|GV*	|gv_fetchsv|NN SV *name|I32 flags|I32 sv_type
dp	|bool	|is_gv_magical_sv|NN SV *name|U32 flags

#ifndef SPRINTF_RETURNS_STRLEN
Apnod	|int	|my_sprintf	|NN char *buffer|NN const char *pat|...
#endif

Apnodf	|int	|my_snprintf	|NN char *buffer|const Size_t len|NN const char *format|...
Apnod	|int	|my_vsnprintf	|NN char *buffer|const Size_t len|NN const char *format|va_list ap
#if !defined(HAS_SIGNBIT)
AMdnoP	|int	|Perl_signbit	|NV f
#endif

Apon	|void	|sys_init	|NN int* argc|NN char*** argv
Apon	|void	|sys_init3	|NN int* argc|NN char*** argv|NN char*** env
Apon	|void	|sys_term

END_EXTERN_C
/*
 * ex: set ts=8 sts=4 sw=4 noet:
 */
