/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.pairwise.rna;

import edu.msu.cme.rdp.readseq.utils.SeqUtils;

public class FastDistanceCalc {
    private static final float nan = -1.0f;

    public static float FastDistanceCalc(byte[] seqX, byte[] seqY, int overlapLimit) {
        int matchable = 0;
        int matches = 0;
        for (int i = 0; i < seqX.length; ++i) {
            byte x = seqX[i];
            byte y = seqY[i];
            if (((x | y) & SeqUtils.NON_COMPAREABLE) != 0) continue;
            ++matchable;
            if (x != y) continue;
            ++matches;
        }
        if (matchable == 0 || matchable < overlapLimit) {
            return -1.0f;
        }
        return 1.0f - (float)matches / (float)matchable;
    }
}

