/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers.core;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.utils.BufferedRandomAccessFile;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

public abstract class SeqReaderCore {
    private boolean seekable;
    private RandomAccessFile rawRAFile = null;
    private DataInputStream is = null;

    public SeqReaderCore(File seqFile) throws IOException {
        this.rawRAFile = new BufferedRandomAccessFile(seqFile, "r", 4096);
        this.seekable = true;
    }

    public SeqReaderCore(InputStream is) throws IOException {
        this.is = new DataInputStream(new BufferedInputStream(is));
        this.seekable = false;
    }

    protected final RandomAccessFile getRawFile() throws IOException {
        if (!this.seekable) {
            throw new IOException("Stream seq cores are not seekable");
        }
        return this.rawRAFile;
    }

    protected final DataInput getDataInput() {
        if (this.seekable) {
            return this.rawRAFile;
        }
        return this.is;
    }

    protected final int read(byte[] buf) throws IOException {
        if (this.seekable) {
            return this.rawRAFile.read(buf);
        }
        return this.is.read(buf);
    }

    public boolean isSeekable() {
        return this.seekable;
    }

    public Map<String, Long> scan() throws IOException {
        if (!this.seekable) {
            throw new IOException("This seq core is not seekable");
        }
        return this.scanInternal();
    }

    protected abstract Map<String, Long> scanInternal() throws IOException;

    public Sequence parse(long pos) throws IOException {
        if (!this.seekable) {
            throw new IOException("This seq core is not seekable");
        }
        this.rawRAFile.seek(pos);
        return this.readNextSeq();
    }

    public void seek(long pos) throws IOException {
        if (!this.seekable) {
            throw new IOException("This seq core is not seekable");
        }
        this.rawRAFile.seek(pos);
    }

    public Sequence readNextSequence() throws IOException {
        try {
            return this.readNextSeq();
        }
        catch (EOFException e) {
            return null;
        }
    }

    protected abstract Sequence readNextSeq() throws IOException;

    public void close() throws IOException {
        if (this.seekable) {
            this.rawRAFile.close();
        } else {
            this.is.close();
        }
    }

    private int read() throws IOException {
        if (this.seekable) {
            return this.rawRAFile.read();
        }
        return this.is.read();
    }

    public long getPosition() {
        if (!this.seekable) {
            return -1L;
        }
        try {
            return this.rawRAFile.getFilePointer();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    protected String readUntilNext(char ... delims) throws IOException {
        int r;
        StringBuilder ret = new StringBuilder();
        char prev = '\u0000';
        while ((r = this.read()) != -1) {
            char c = (char)r;
            if (c == '\r' && prev == '\n' || c == '\n' && prev == '\r') {
                prev = c;
                continue;
            }
            prev = c;
            if (c == '\r') {
                c = '\n';
            }
            prev = c;
            for (int index = 0; index < delims.length; ++index) {
                if (c != delims[index]) continue;
                return ret.toString();
            }
            ret.append(c);
        }
        if (ret.length() == 0) {
            return null;
        }
        return ret.toString();
    }

    protected String readUntilNext(String delimStr) throws IOException {
        int r;
        StringBuilder ret = new StringBuilder();
        int checkIndex = 0;
        char[] delim = delimStr.toCharArray();
        int prev = 0;
        boolean i = false;
        while ((r = this.read()) != -1) {
            char c = (char)r;
            if (c == '\r' && prev == 10 || c == '\n' && prev == 13) {
                prev = c;
                continue;
            }
            prev = c;
            if (c == '\r') {
                c = '\n';
            }
            ret.append(c);
            if (c == delim[checkIndex]) {
                if (++checkIndex != delim.length) continue;
                return ret.substring(0, ret.length() - delim.length);
            }
            if (delim[0] == c) {
                checkIndex = 1;
                continue;
            }
            checkIndex = 0;
        }
        if (ret.length() == 0) {
            return null;
        }
        return ret.toString();
    }

    protected String readSeqString(String delimStr) throws IOException {
        int r;
        char c;
        StringBuilder ret = new StringBuilder();
        int checkIndex = 0;
        char[] delim = delimStr.toCharArray();
        int delimLength = 0;
        for (int index = 0; index < delim.length; ++index) {
            c = delim[index];
            if (c == '\n' || c == ' ' || c == '\t') continue;
            ++delimLength;
        }
        char prev = '\u0000';
        boolean i = false;
        while ((r = this.read()) != -1) {
            c = (char)r;
            if (c == '\r' && prev == '\n' || c == '\n' && prev == '\r') {
                prev = c;
                continue;
            }
            prev = c;
            if (c == '\r') {
                c = '\n';
            }
            if (c != '\n' && c != ' ' && c != '\t') {
                ret.append(c);
            }
            if (c == delim[checkIndex]) {
                if (++checkIndex != delim.length) continue;
                return ret.substring(0, ret.length() - delimLength);
            }
            if (delim[0] == c) {
                checkIndex = 1;
                continue;
            }
            checkIndex = 0;
        }
        if (ret.length() == 0) {
            return null;
        }
        return ret.toString();
    }

    public static class EmptyCore
    extends SeqReaderCore {
        public EmptyCore(File f) throws IOException {
            super(f);
        }

        public EmptyCore(InputStream is) throws IOException {
            super(is);
        }

        @Override
        public Map<String, Long> scanInternal() throws IOException {
            return new HashMap<String, Long>();
        }

        @Override
        protected Sequence readNextSeq() throws IOException {
            return null;
        }
    }
}

