/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.multicompare.taxon;

import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.taxatree.Taxon;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MCTaxon
extends Taxon {
    protected Map<MCSample, double[]> sampleCountMap = new LinkedHashMap<MCSample, double[]>();
    private Set<String> sequences = new HashSet<String>();
    private String lineage;
    public static final int Count_Array_size = 2;

    public MCTaxon(int id, String name, String rank) {
        this(id, name, rank, false);
    }

    public MCTaxon(int id, String name, String rank, boolean unclassified) {
        super(id, name, rank, unclassified);
    }

    public MCTaxon(Taxon t) {
        super(t);
    }

    public void addSequence(String seqid) {
        this.sequences.add(seqid);
    }

    public Set<String> getSequences() {
        return Collections.unmodifiableSet(this.sequences);
    }

    public void setLineage(String lineage) {
        this.lineage = lineage;
    }

    public String getLineage() {
        return this.lineage;
    }

    public Set<MCSample> getSamples() {
        return this.sampleCountMap.keySet();
    }

    public double getCount(MCSample s) {
        if (this.sampleCountMap.containsKey(s)) {
            return this.sampleCountMap.get(s)[0];
        }
        return 0.0;
    }

    public double getCopyCorrectedCount(MCSample s) {
        if (this.sampleCountMap.containsKey(s)) {
            return this.sampleCountMap.get(s)[1];
        }
        return 0.0;
    }

    public void incCount(MCSample s, double c) {
        this.incCount(s, c, 1.0);
    }

    public void incCount(MCSample s, double c, double copyNumber) {
        double[] i = this.sampleCountMap.get(s);
        if (i == null) {
            i = new double[2];
            this.sampleCountMap.put(s, i);
        }
        i[0] = i[0] + c;
        i[1] = i[1] + c / copyNumber;
    }
}

