/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation.movingwindow;

import edu.msu.cme.rdp.classifier.train.LineageSequenceParser;
import edu.msu.cme.rdp.classifier.train.validation.TreeFactory;
import edu.msu.cme.rdp.classifier.train.validation.movingwindow.FindWindowFrame;
import edu.msu.cme.rdp.classifier.train.validation.movingwindow.Window;
import edu.msu.cme.rdp.classifier.train.validation.movingwindow.WindowTester;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class MainMovingWindow {
    TreeFactory factory = null;
    BufferedWriter outWriter = null;
    ArrayList seqList = new ArrayList();
    ArrayList windowFrames = null;
    private static int beginIndex = 0;

    public MainMovingWindow(String taxFile, String inFile, String testFile, String outFile, String ecoliFile, int begin, int end, int min_bootstrap_words) throws IOException {
        this.windowFrames = this.getWindowFrame(ecoliFile);
        beginIndex = begin;
        this.factory = new TreeFactory(new FileReader(taxFile));
        this.createTree(this.factory, new File(inFile));
        this.outWriter = new BufferedWriter(new FileWriter(outFile));
        this.outWriter.write("taxon file: " + taxFile + "\ntrain sequence file: " + inFile + "\n");
        LineageSequenceParser parser = new LineageSequenceParser(new File(testFile));
        while (parser.hasNext()) {
            this.seqList.add(parser.next());
        }
        this.outWriter.write("query sequence file: " + testFile + "\nclassify moving window of size " + 200 + ", step " + 25 + "\n");
        Iterator windowIt = this.windowFrames.iterator();
        int windowIndex = 1;
        try {
            while (windowIt.hasNext()) {
                Window w = (Window)windowIt.next();
                if (windowIndex >= begin && windowIndex <= end) {
                    WindowTester tester = new WindowTester(this.outWriter);
                    System.err.print("**** windowIndex: " + windowIndex + " model position range: " + w.getStart() + " " + w.getStop() + "\n");
                    tester.classify(this.factory, this.seqList, w, windowIndex, min_bootstrap_words);
                }
                ++windowIndex;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.outWriter.close();
        }
    }

    public static int getBeginIndex() {
        return beginIndex;
    }

    private void createTree(TreeFactory factory, File input) throws IOException {
        long startTime = System.currentTimeMillis();
        LineageSequenceParser parser = new LineageSequenceParser(input);
        while (parser.hasNext()) {
            factory.addSequence(parser.next());
        }
        factory.calculateWordPrior();
        factory.getRoot().createWordOccurrenceFromSubclasses();
    }

    public ArrayList getWindowFrame(String ecoliFile) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(new File(ecoliFile)));
        String seqString = "";
        while ((line = reader.readLine()) != null) {
            seqString = seqString + line;
        }
        reader.close();
        FindWindowFrame finder = new FindWindowFrame();
        return finder.find(seqString);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 8) {
            System.out.println("Usage: java MainClassification <tax_file> <source_file> <test_file> <out_file> <ecoli_file> begin end min_bootstrap_words");
            System.exit(-1);
        }
        MainMovingWindow main = new MainMovingWindow(args[0], args[1], args[2], args[3], args[4], Integer.parseInt(args[5]), Integer.parseInt(args[6]), Integer.parseInt(args[7]));
    }
}

