/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.io;

import edu.msu.cme.rdp.classifier.ClassificationResult;
import edu.msu.cme.rdp.classifier.RankAssignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ClassificationResultFormatter {
    public static String[] RANKS = new String[]{"domain", "phylum", "class", "order", "family", "genus"};
    public static String[] RANKS_WITHSPECIES = new String[]{"domain", "phylum", "class", "order", "family", "genus", "species"};
    public static final List<FORMAT> fileFormats = new ArrayList<FORMAT>(Arrays.asList(FORMAT.allRank, FORMAT.dbformat, FORMAT.fixRank, FORMAT.filterbyconf, FORMAT.biom));

    public static String getOutput(ClassificationResult result, FORMAT format) {
        return ClassificationResultFormatter.getOutput(result, format, 0.0f, RANKS);
    }

    public static String getOutput(ClassificationResult result, FORMAT format, float conf, String[] ranks) {
        switch (format) {
            case allRank: {
                return ClassificationResultFormatter.getAllRankOutput(result);
            }
            case fixRank: {
                return ClassificationResultFormatter.getFixRankOutput(ranks, result);
            }
            case dbformat: {
                return ClassificationResultFormatter.getDBOutput(result, conf);
            }
            case filterbyconf: {
                return ClassificationResultFormatter.getFilterByConfOutput(ranks, result, conf);
            }
            case biom: {
                return ClassificationResultFormatter.getBiomOutput(ranks, result, conf, ';');
            }
        }
        ClassificationResultFormatter.getAllRankOutput(result);
        return null;
    }

    public static String getAllRankOutput(ClassificationResult result) {
        StringBuilder assignmentStr = new StringBuilder(result.getSequence().getSeqName() + "\t");
        if (result.isReverse()) {
            assignmentStr.append("-");
        }
        for (RankAssignment assignment : result.getAssignments()) {
            assignmentStr.append("\t").append(assignment.getName()).append("\t").append(assignment.getRank()).append("\t").append(assignment.getConfidence());
        }
        assignmentStr.append("\n");
        return assignmentStr.toString();
    }

    public static String getAllRankOutput(ClassificationResult result, double conf) {
        StringBuilder assignmentStr = new StringBuilder(result.getSequence().getSeqName() + "\t");
        if (result.isReverse()) {
            assignmentStr.append("-");
        }
        for (RankAssignment assignment : result.getAssignments()) {
            if (!((double)assignment.getConfidence() >= conf)) continue;
            assignmentStr.append("\t").append(assignment.getName()).append("\t").append(assignment.getRank()).append("\t").append(assignment.getConfidence());
        }
        assignmentStr.append("\n");
        return assignmentStr.toString();
    }

    public static String getFixRankOutput(ClassificationResult result) {
        return ClassificationResultFormatter.getFixRankOutput(RANKS, result);
    }

    public static String getFixRankOutput(String[] ranks, ClassificationResult result) {
        StringBuilder assignmentStr = new StringBuilder();
        HashMap<String, RankAssignment> rankMap = new HashMap<String, RankAssignment>();
        for (RankAssignment assignment : result.getAssignments()) {
            rankMap.put(assignment.getRank().toLowerCase(), assignment);
        }
        RankAssignment prevAssign = null;
        for (int i = ranks.length - 1; i >= 0; --i) {
            RankAssignment assign = (RankAssignment)rankMap.get(ranks[i]);
            if (assign != null) {
                assignmentStr.insert(0, "\t" + assign.getName() + "\t" + assign.getRank() + "\t" + assign.getConfidence());
                prevAssign = assign;
                continue;
            }
            assignmentStr.insert(0, "\t" + prevAssign.getName() + "\t" + ranks[i] + "\t" + prevAssign.getConfidence());
        }
        if (result.isReverse()) {
            assignmentStr.insert(0, "-");
        } else {
            assignmentStr.insert(0, "");
        }
        assignmentStr.insert(0, result.getSequence().getSeqName() + "\t");
        assignmentStr.append("\n");
        return assignmentStr.toString();
    }

    public static String getFilterByConfOutput(ClassificationResult result, float conf) {
        return ClassificationResultFormatter.getFilterByConfOutput(RANKS, result, conf);
    }

    public static String getFilterByConfOutput(String[] ranks, ClassificationResult result, float conf) {
        StringBuilder assignmentStr = new StringBuilder();
        HashMap<String, RankAssignment> rankMap = new HashMap<String, RankAssignment>();
        for (RankAssignment assignment : result.getAssignments()) {
            rankMap.put(assignment.getRank().toLowerCase(), assignment);
        }
        RankAssignment prevAssign = result.getAssignments().get(0);
        assignmentStr.append(result.getSequence().getSeqName());
        for (int i = 0; i <= ranks.length - 1; ++i) {
            RankAssignment assign = (RankAssignment)rankMap.get(ranks[i]);
            if (assign != null) {
                if (assign.getConfidence() <= conf) {
                    assignmentStr.append("\tunclassified_" + prevAssign.getName());
                    continue;
                }
                assignmentStr.append("\t" + assign.getName());
                prevAssign = assign;
                continue;
            }
            if (prevAssign == null || !(prevAssign.getConfidence() >= conf)) continue;
            assignmentStr.append("\tunclassified_" + prevAssign.getName());
        }
        assignmentStr.append("\n");
        return assignmentStr.toString();
    }

    public static String getBiomOutput(String[] ranks, ClassificationResult result, float conf, char delimiter) {
        StringBuilder assignmentStr = new StringBuilder();
        HashMap<String, RankAssignment> rankMap = new HashMap<String, RankAssignment>();
        for (RankAssignment assignment : result.getAssignments()) {
            rankMap.put(assignment.getRank().toLowerCase(), assignment);
        }
        RankAssignment prevAssign = result.getAssignments().get(0);
        assignmentStr.append(result.getSequence().getSeqName() + "\t");
        for (int i = 0; i <= ranks.length - 1; ++i) {
            RankAssignment assign = (RankAssignment)rankMap.get(ranks[i]);
            String rank = RANKS[i].substring(0, 1).toLowerCase();
            if (assign != null) {
                if (assign.getConfidence() <= conf) {
                    assignmentStr.append(rank + "__unclassified_" + prevAssign.getName().replaceAll("\"", ""));
                } else {
                    assignmentStr.append(rank + "__" + assign.getName().replaceAll("\"", ""));
                    prevAssign = assign;
                }
            } else if (prevAssign != null && prevAssign.getConfidence() >= conf) {
                assignmentStr.append(rank + "__unclassified_" + prevAssign.getName().replaceAll("\"", ""));
            }
            if (i >= ranks.length - 1) continue;
            assignmentStr.append(delimiter);
        }
        return assignmentStr.toString();
    }

    public static String getDBOutput(ClassificationResult result, float conf) {
        StringBuilder assignmentStr = new StringBuilder();
        boolean set = false;
        List<RankAssignment> assignments = result.getAssignments();
        for (int i = assignments.size() - 1; i >= 0; --i) {
            int markAssigned = 0;
            RankAssignment assign = assignments.get(i);
            if (!set && assign.getConfidence() >= conf) {
                markAssigned = 1;
                set = true;
            }
            assignmentStr.append(result.getSequence().getSeqName()).append("\t").append(result.getTrainsetNo()).append("\t").append(assign.getTaxid()).append("\t").append(assign.getConfidence()).append("\t").append(markAssigned).append("\n");
        }
        return assignmentStr.toString();
    }

    public static enum FORMAT {
        allRank,
        fixRank,
        dbformat,
        filterbyconf,
        biom;

    }
}

