/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.CrossProductSymbolNameParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ListWrapper;

class SparseCrossProductAlphabet
extends AbstractAlphabet
implements Serializable {
    private final int size;
    private final List alphas;
    private final Map knownSymbols;
    private char tokenSeed = (char)65;
    private ListWrapper gopher = new ListWrapper();

    SparseCrossProductAlphabet(List list) {
        this.alphas = list;
        this.knownSymbols = new HashMap();
        int n = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FiniteAlphabet finiteAlphabet = (FiniteAlphabet)iterator.next();
            n *= finiteAlphabet.size();
        }
        this.size = n;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void addSymbolImpl(AtomicSymbol atomicSymbol) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't add symbols to alphabet: " + atomicSymbol.getName() + " in " + this.getName());
    }

    protected boolean containsImpl(AtomicSymbol atomicSymbol) {
        return this.knownSymbols.values().contains(atomicSymbol);
    }

    public List getAlphabets() {
        return this.alphas;
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = 0;
        while (n < this.alphas.size()) {
            Alphabet alphabet = (Alphabet)this.alphas.get(n);
            stringBuffer.append(alphabet.getName());
            if (n < this.alphas.size() - 1) {
                stringBuffer.append(" x ");
            }
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public SymbolParser getParser(String string) throws NoSuchElementException {
        if (string == "name") {
            try {
                return new CrossProductSymbolNameParser(this);
            }
            catch (BioException bioException) {
                throw new NoSuchElementException("Couldn't create parser: " + bioException.getMessage());
            }
        }
        throw new NoSuchElementException("No parser for " + string + " is defined for " + this.getName());
    }

    protected AtomicSymbol getSymbolImpl(List list) throws IllegalSymbolException {
        AtomicSymbol atomicSymbol;
        Serializable serializable = this.gopher;
        synchronized (serializable) {
            this.gopher.setList(list);
            atomicSymbol = (AtomicSymbol)this.knownSymbols.get(this.gopher);
        }
        if (atomicSymbol == null) {
            serializable = new ArrayList(list);
            char c = this.tokenSeed;
            this.tokenSeed = (char)(c + '\u0001');
            atomicSymbol = (AtomicSymbol)AlphabetManager.createSymbol(c, Annotation.EMPTY_ANNOTATION, (List)((Object)serializable), (Alphabet)this);
            this.knownSymbols.put(new ListWrapper(atomicSymbol.getSymbols()), atomicSymbol);
        }
        return atomicSymbol;
    }

    public Iterator iterator() {
        return new SparseIterator(this);
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeSymbol(Symbol symbol) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't remove symbols from alphabet: " + symbol.getName() + " in " + this.getName());
    }

    public int size() {
        return this.size;
    }

    public SymbolList symbols() {
        try {
            SimpleSymbolList simpleSymbolList = new SimpleSymbolList(this);
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                simpleSymbolList.addSymbol((Symbol)iterator.next());
            }
            return simpleSymbolList;
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Assertion Failure");
        }
    }

    private static class SparseIterator
    implements Iterator {
        private Alphabet parent;
        private FiniteAlphabet[] alphas;
        private Iterator[] symI;
        private AtomicSymbol[] as;
        private boolean hasNext;
        private List symList;

        public SparseIterator(FiniteAlphabet finiteAlphabet) {
            this.parent = finiteAlphabet;
            this.alphas = finiteAlphabet.getAlphabets().toArray(new FiniteAlphabet[0]);
            this.symI = new Iterator[this.alphas.length];
            this.as = new AtomicSymbol[this.alphas.length];
            this.hasNext = true;
            int n = 0;
            while (n < this.alphas.length) {
                this.symI[n] = this.alphas[n].iterator();
                if (!this.symI[n].hasNext()) {
                    this.hasNext = false;
                    return;
                }
                this.as[n] = (AtomicSymbol)this.symI[n].next();
                ++n;
            }
            this.symList = Arrays.asList(this.as);
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            try {
                Symbol symbol = this.parent.getSymbol(this.symList);
                int n = 0;
                while (n <= this.alphas.length) {
                    if (n == this.alphas.length) {
                        this.hasNext = false;
                    } else if (!this.symI[n].hasNext()) {
                        this.symI[n] = this.alphas[n].iterator();
                        this.as[n] = (AtomicSymbol)this.symI[n].next();
                    } else {
                        this.as[n] = (AtomicSymbol)this.symI[n].next();
                        break;
                    }
                    ++n;
                }
                return symbol;
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "Assertion Failure: I should contain this symbol");
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

