/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.SingletonList;
import org.biojava.utils.StaticMemberPlaceHolder;

public class DoubleAlphabet
implements Alphabet,
Serializable {
    private static final DoubleAlphabet INSTANCE = new DoubleAlphabet();
    private static final SymbolParser PARSER = new SymbolParser(){

        public Alphabet getAlphabet() {
            return INSTANCE;
        }

        public SymbolList parse(String string) {
            throw new BioError("Pants - haven't implemented this yet");
        }

        public StreamParser parseStream(SeqIOListener seqIOListener) {
            throw new BioError("Not implemented yet");
        }

        public Symbol parseToken(String string) {
            return INSTANCE.getSymbol(Double.parseDouble(string));
        }
    };
    private List alphabets = null;
    static /* synthetic */ Class class$org$biojava$bio$symbol$DoubleAlphabet;

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean contains(Symbol symbol) {
        return symbol instanceof DoubleSymbol;
    }

    public static SymbolList fromArray(double[] dArray) {
        return new DoubleArray(dArray);
    }

    public List getAlphabets() {
        if (this.alphabets == null) {
            this.alphabets = new SingletonList(this);
        }
        return this.alphabets;
    }

    public Symbol getAmbiguity(Set set) throws IllegalSymbolException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            this.validate(symbol);
        }
        throw new BioError("Operation not implemented");
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public static DoubleAlphabet getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return "Alphabet of all doubles.";
    }

    public SymbolParser getParser(String string) {
        if (!string.equals("name")) {
            throw new NoSuchElementException("No parsers supported by DoubleAlphabet called " + string);
        }
        return PARSER;
    }

    public DoubleSymbol getSymbol(double d) {
        return new DoubleSymbol(d);
    }

    public Symbol getSymbol(List list) throws IllegalSymbolException {
        if (list.size() != 1) {
            throw new IllegalSymbolException("Can't build symbol from list " + list.size() + " long");
        }
        Symbol symbol = (Symbol)list.get(0);
        this.validate(symbol);
        return symbol;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void validate(Symbol symbol) throws IllegalSymbolException {
        if (!this.contains(symbol)) {
            throw new IllegalSymbolException("Only symbols of type DoubleAlphabet.DoubleSymbol are valid for this alphabet.\n(" + symbol.getClass() + ") " + symbol.getName());
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        try {
            return new StaticMemberPlaceHolder((class$org$biojava$bio$symbol$DoubleAlphabet != null ? class$org$biojava$bio$symbol$DoubleAlphabet : (class$org$biojava$bio$symbol$DoubleAlphabet = DoubleAlphabet.class$("org.biojava.bio.symbol.DoubleAlphabet"))).getField("INSTANCE"));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new NotSerializableException(noSuchFieldException.getMessage());
        }
    }

    public static class DoubleSymbol
    implements AtomicSymbol,
    Serializable {
        private final double val;
        private final Alphabet matches;

        protected DoubleSymbol(double d) {
            this.val = d;
            this.matches = new SingletonAlphabet(this);
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }

        public double doubleValue() {
            return this.val;
        }

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public Set getBases() {
            return Collections.singleton(this);
        }

        public Alphabet getMatches() {
            return this.matches;
        }

        public String getName() {
            return String.valueOf(this.val);
        }

        public List getSymbols() {
            return new SingletonList(this);
        }

        public char getToken() {
            return '#';
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }
    }

    private static class DoubleArray
    extends AbstractSymbolList
    implements Serializable {
        private final double[] dArray;

        public DoubleArray(double[] dArray) {
            this.dArray = dArray;
        }

        public Alphabet getAlphabet() {
            return INSTANCE;
        }

        public int length() {
            return this.dArray.length;
        }

        public Symbol symbolAt(int n) {
            return new DoubleSymbol(this.dArray[n - 1]);
        }
    }
}

