/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;

public final class DNATools {
    private static final ReversibleTranslationTable complementTable;
    private static final FiniteAlphabet dna;
    private static final Symbol a;
    private static final Symbol g;
    private static final Symbol c;
    private static final Symbol t;
    private static Map symbolToComplement;

    static {
        try {
            dna = (FiniteAlphabet)AlphabetManager.alphabetForName("DNA");
            SymbolList symbolList = dna.getParser("token").parse("agct");
            a = symbolList.symbolAt(1);
            g = symbolList.symbolAt(2);
            c = symbolList.symbolAt(3);
            t = symbolList.symbolAt(4);
            symbolToComplement = new HashMap();
            Symbol symbol = AlphabetManager.getGapSymbol();
            symbolToComplement.put(symbol, symbol);
            Iterator iterator = ((SimpleAlphabet)dna).ambiguities();
            while (iterator.hasNext()) {
                Symbol symbol2 = (Symbol)iterator.next();
                HashSet<Symbol> hashSet = new HashSet<Symbol>();
                FiniteAlphabet finiteAlphabet = (FiniteAlphabet)symbol2.getMatches();
                Iterator iterator2 = finiteAlphabet.iterator();
                while (iterator2.hasNext()) {
                    hashSet.add(DNATools.complement((Symbol)iterator2.next()));
                }
                symbolToComplement.put(symbol2, dna.getAmbiguity(hashSet));
            }
            complementTable = new DNAComplementTranslationTable();
        }
        catch (Throwable throwable) {
            throw new BioError(throwable, "Unable to initialize DNATools");
        }
    }

    public static Symbol a() {
        return a;
    }

    public static Symbol c() {
        return c;
    }

    public static Symbol complement(Symbol symbol) throws IllegalSymbolException {
        if (symbol == a) {
            return t;
        }
        if (symbol == g) {
            return c;
        }
        if (symbol == c) {
            return g;
        }
        if (symbol == t) {
            return a;
        }
        Symbol symbol2 = (Symbol)symbolToComplement.get(symbol);
        if (symbol2 != null) {
            return symbol2;
        }
        DNATools.getDNA().validate(symbol);
        throw new BioError("Really confused. Can't find symbol " + symbol.getName());
    }

    public static SymbolList complement(SymbolList symbolList) throws IllegalAlphabetException {
        return SymbolListViews.translate(symbolList, DNATools.complementTable());
    }

    public static ReversibleTranslationTable complementTable() {
        return complementTable;
    }

    public static SymbolList createDNA(String string) throws IllegalSymbolException {
        try {
            SymbolParser symbolParser = DNATools.getDNA().getParser("token");
            return symbolParser.parse(string);
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Something has gone badly wrong with DNA");
        }
    }

    public static Symbol forIndex(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return a;
        }
        if (n == 1) {
            return g;
        }
        if (n == 2) {
            return c;
        }
        if (n == 3) {
            return t;
        }
        throw new IndexOutOfBoundsException("No symbol for index " + n);
    }

    public static Symbol forSymbol(char c) throws IllegalSymbolException {
        if (c == 'a') {
            return a;
        }
        if (c == 'g') {
            return g;
        }
        if (c == 'c') {
            return DNATools.c;
        }
        if (c == 't') {
            return t;
        }
        throw new IllegalSymbolException("Unable to find symbol for token " + c);
    }

    public static Symbol g() {
        return g;
    }

    public static FiniteAlphabet getDNA() {
        return dna;
    }

    public static int index(Symbol symbol) throws IllegalSymbolException {
        if (symbol == a) {
            return 0;
        }
        if (symbol == g) {
            return 1;
        }
        if (symbol == c) {
            return 2;
        }
        if (symbol == t) {
            return 3;
        }
        DNATools.getDNA().validate(symbol);
        throw new IllegalSymbolException("Really confused. Can't find index for " + symbol.getName());
    }

    public static SymbolList reverseComplement(SymbolList symbolList) throws IllegalAlphabetException {
        return SymbolListViews.translate(SymbolListViews.reverse(symbolList), DNATools.complementTable());
    }

    public static Symbol t() {
        return t;
    }

    private static class DNAComplementTranslationTable
    implements ReversibleTranslationTable {
        DNAComplementTranslationTable() {
        }

        public Alphabet getSourceAlphabet() {
            return DNATools.getDNA();
        }

        public Alphabet getTargetAlphabet() {
            return DNATools.getDNA();
        }

        public Symbol translate(Symbol symbol) throws IllegalSymbolException {
            return DNATools.complement(symbol);
        }

        public Symbol untranslate(Symbol symbol) throws IllegalSymbolException {
            return DNATools.complement(symbol);
        }
    }
}

