/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.datastructures;

import fr.cea.ig.metatarget.datastructures.Sequence;
import fr.cea.ig.metatarget.utils.Utils;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DictionaryFilter {
    private ConcurrentMap<Long, TIntList> kmer2sequenceMap;
    private HashMap<Integer, Set<Integer>> sequence2sequenceMap;

    public DictionaryFilter(int initialCapacity, int concurrencyLevel) {
        this.kmer2sequenceMap = new ConcurrentHashMap<Long, TIntList>(initialCapacity, 0.75f, concurrencyLevel);
    }

    public List<Integer> getR2RListForId(int sequenceId) {
        return Utils.asSortedList((Collection)this.sequence2sequenceMap.get(sequenceId));
    }

    public Set<Integer> getR2RSetForId(int sequenceId) {
        return this.sequence2sequenceMap.get(sequenceId);
    }

    public synchronized void insert(long kmerId, final int sequenceId) {
        if (kmerId < 0L) {
            return;
        }
        TIntList old = this.kmer2sequenceMap.putIfAbsent(kmerId, new TIntArrayList(){
            {
                this.add(sequenceId);
            }
        });
        if (old != null && !old.contains(sequenceId)) {
            old.add(sequenceId);
        }
    }

    public void populateSequence2SequenceRelation(int usingThsequences) {
        if (this.sequence2sequenceMap != null) {
            this.sequence2sequenceMap.clear();
            this.sequence2sequenceMap = null;
        }
        this.sequence2sequenceMap = new HashMap();
        for (TIntList list : this.kmer2sequenceMap.values()) {
            for (int i = 0; i < list.size(); ++i) {
                for (int j = i + 1; j < list.size(); ++j) {
                    Set<Integer> innerSet = this.sequence2sequenceMap.get(list.get(i));
                    if (innerSet == null) {
                        innerSet = new HashSet<Integer>();
                        this.sequence2sequenceMap.put(list.get(i), innerSet);
                    }
                    innerSet.add(list.get(j));
                }
            }
        }
    }

    public boolean areRelated(Sequence sequence1, Sequence sequence2) {
        return this.sequence2sequenceMap.get(sequence1.getSequenceId()).contains(sequence2.getSequenceId()) || this.sequence2sequenceMap.get(sequence2.getSequenceId()).contains(sequence1.getSequenceId());
    }

    public boolean areRelated(int sequence1Id, int sequence2Id) {
        return this.sequence2sequenceMap.get(sequence1Id).contains(sequence2Id) || this.sequence2sequenceMap.get(sequence2Id).contains(sequence1Id);
    }

    public String toString(int kFilter) {
        StringBuilder sb = new StringBuilder();
        int numOflists = this.kmer2sequenceMap.values().size();
        sb.append("numOflists:\t\t" + numOflists + "\n");
        return sb.toString();
    }
}

