/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.tree;

import com.gkano.bioinfo.tree.Clade;
import com.gkano.bioinfo.tree.TreeDataModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class PhylipWriter {
    protected Writer writer;
    protected Object output;

    public void setOutput(Writer out) {
        this.writer = out;
        this.output = null;
    }

    public void setOutput(File file) throws IOException {
        this.setOutput(file, false);
    }

    public void setOutput(File file, boolean append) throws IOException {
        this.writer = file == null ? new BufferedWriter(new OutputStreamWriter(System.out)) : new BufferedWriter(new FileWriter(file.getCanonicalPath(), append));
        this.output = file;
    }

    public void setOutput(OutputStream out) {
        this.writer = new BufferedWriter(new OutputStreamWriter(out));
        this.output = null;
    }

    public String toString() {
        return this.writer == null ? null : this.writer.toString();
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void open() throws IOException {
        if (this.output == null) {
            return;
        }
        if (this.output instanceof File) {
            this.setOutput((File)this.output);
        } else if (this.writer instanceof StringWriter) {
            this.setOutput(new StringWriter());
        }
    }

    public Object write(Object obj) throws IOException {
        try {
            DefaultMutableTreeNode root;
            if (obj instanceof TreeModel) {
                root = (DefaultMutableTreeNode)((TreeModel)obj).getRoot();
            } else if (obj instanceof TreeDataModel) {
                root = ((TreeDataModel)obj).getRoot();
            } else {
                throw new ClassCastException("Tree must be TreeModel or TreeDataModel: " + (obj == null ? "null" : String.valueOf(obj.getClass())));
            }
            this.writeTree(root);
            this.writer.write(";\n");
        }
        finally {
            this.writer.flush();
            this.writer.close();
        }
        if (this.writer instanceof StringWriter) {
            return this.writer.toString();
        }
        return null;
    }

    protected void writeTree(DefaultMutableTreeNode node) throws IOException {
        if (!node.isLeaf()) {
            this.writer.write("(\n");
        }
        int numChildren = node.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            this.writeTree((Clade)node.getChildAt(i));
            if (i >= numChildren - 1) continue;
            this.writer.write(",\n");
        }
        if (!node.isLeaf()) {
            this.writer.write(")\n");
        }
        if (!node.isRoot() && node.getUserObject() != null) {
            this.writer.write(node.toString());
        }
        if (!node.isRoot() && node instanceof Clade) {
            this.writer.write(":");
            Clade branch = (Clade)node;
            double length = branch.getBranchLength();
            this.writer.write(String.valueOf(length));
        }
    }
}

