/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.test;

import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Random;
import edu.rit.util.Range;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class Test13 {
    static long seed;
    static int N;
    static File file;
    static double[][] D;

    private Test13() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 3) {
            Test13.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        N = Integer.parseInt(stringArray[1]);
        file = new File(stringArray[2]);
        D = new double[N][N + 16];
        Random random = Random.getInstance(seed);
        for (int i = 0; i < N; ++i) {
            double[] dArray = D[i];
            for (int j = 0; j < N; ++j) {
                dArray[j] = random.nextDouble();
            }
        }
        long l = -System.currentTimeMillis();
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                int n = this.getThreadCount();
                int n2 = this.getThreadIndex();
                Range range = new Range(0, N - 1).subrange(n, n2);
                int n3 = range.lb();
                int n4 = range.ub();
                for (int i = 0; i < N; ++i) {
                    double[] dArray = D[i];
                    for (int j = n3; j <= n4; ++j) {
                        double[] dArray2 = D[j];
                        for (int k = 0; k < N; ++k) {
                            dArray2[k] = Math.min(dArray2[k], dArray2[i] + dArray[k]);
                        }
                    }
                    this.barrier();
                }
            }
        });
        l += System.currentTimeMillis();
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < N; ++i) {
            double[] dArray = D[i];
            for (int j = 0; j < N; ++j) {
                dataOutputStream.writeDouble(dArray[j]);
            }
        }
        dataOutputStream.close();
        System.out.println(l);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> edu.rit.pj.test.Test13 <seed> <N> <file>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<seed> = Random seed");
        System.err.println("<N> = Matrix size (NxN)");
        System.err.println("<file> = Output file name");
        System.exit(1);
    }
}

