/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import java.io.Serializable;

public class Rational
implements Comparable,
Serializable {
    private int numer;
    private int denom;

    public Rational() {
        this.numer = 0;
        this.denom = 1;
    }

    public Rational(int n) {
        this.numer = n;
        this.denom = 1;
    }

    public Rational(int n, int n2) {
        if (n2 == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        this.numer = n;
        this.denom = n2;
        this.normalize();
    }

    public Rational(Rational rational) {
        this.numer = rational.numer;
        this.denom = rational.denom;
    }

    public Rational(String string) {
        this.assign(string);
    }

    public Rational assign(Rational rational) {
        this.numer = rational.numer;
        this.denom = rational.denom;
        return this;
    }

    public Rational assign(int n) {
        this.numer = n;
        this.denom = 1;
        return this;
    }

    public Rational assign(String string) {
        int n;
        int n2;
        int n3 = string.indexOf(47);
        if (n3 == -1) {
            n2 = Integer.parseInt(string);
            n = 1;
        } else if (n3 + 1 < string.length()) {
            n2 = Integer.parseInt(string.substring(0, n3));
            n = Integer.parseInt(string.substring(n3 + 1));
            if (n <= 0) {
                throw new NumberFormatException();
            }
        } else {
            throw new NumberFormatException();
        }
        this.numer = n2;
        this.denom = n;
        this.normalize();
        return this;
    }

    public Rational neg(Rational rational) {
        this.numer = -rational.numer;
        this.denom = rational.denom;
        return this;
    }

    public Rational neg(int n) {
        this.numer = -n;
        this.denom = 1;
        return this;
    }

    public Rational abs(Rational rational) {
        this.numer = Rational.absval(rational.numer);
        this.denom = rational.denom;
        return this;
    }

    public Rational abs(int n) {
        this.numer = Rational.absval(n);
        this.denom = 1;
        return this;
    }

    public Rational intPart(Rational rational) {
        this.numer = rational.numer / rational.denom;
        this.denom = 1;
        return this;
    }

    public Rational fracPart(Rational rational) {
        this.numer = rational.numer % rational.denom;
        this.denom = rational.denom;
        this.normalize();
        return this;
    }

    public Rational add(Rational rational, Rational rational2) {
        int n = Rational.leastCommonMultiple(rational.denom, rational2.denom);
        this.numer = n / rational.denom * rational.numer + n / rational2.denom * rational2.numer;
        this.denom = n;
        this.normalize();
        return this;
    }

    public Rational add(Rational rational, int n) {
        this.numer = rational.numer + n * rational.denom;
        this.denom = rational.denom;
        this.normalize();
        return this;
    }

    public Rational add(int n, Rational rational) {
        this.numer = n * rational.denom + rational.numer;
        this.denom = rational.denom;
        this.normalize();
        return this;
    }

    public Rational add(int n, int n2) {
        this.numer = n + n2;
        this.denom = 1;
        return this;
    }

    public Rational sub(Rational rational, Rational rational2) {
        int n = Rational.leastCommonMultiple(rational.denom, rational2.denom);
        this.numer = n / rational.denom * rational.numer - n / rational2.denom * rational2.numer;
        this.denom = n;
        this.normalize();
        return this;
    }

    public Rational sub(Rational rational, int n) {
        this.numer = rational.numer - n * rational.denom;
        this.denom = rational.denom;
        this.normalize();
        return this;
    }

    public Rational sub(int n, Rational rational) {
        this.numer = n * rational.denom - rational.numer;
        this.denom = rational.denom;
        this.normalize();
        return this;
    }

    public Rational sub(int n, int n2) {
        this.numer = n - n2;
        this.denom = 1;
        return this;
    }

    public Rational mul(Rational rational, Rational rational2) {
        this.numer = rational.numer * rational2.numer;
        this.denom = rational.denom * rational2.denom;
        this.normalize();
        return this;
    }

    public Rational mul(Rational rational, int n) {
        this.numer = rational.numer * n;
        this.denom = rational.denom;
        this.normalize();
        return this;
    }

    public Rational mul(int n, Rational rational) {
        this.numer = n * rational.numer;
        this.denom = rational.denom;
        this.normalize();
        return this;
    }

    public Rational mul(int n, int n2) {
        this.numer = n * n2;
        this.denom = 1;
        return this;
    }

    public Rational div(Rational rational, Rational rational2) {
        if (rational2.numer == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        int n = rational.numer * rational2.denom;
        int n2 = rational.denom * rational2.numer;
        this.numer = n;
        this.denom = n2;
        this.normalize();
        return this;
    }

    public Rational div(Rational rational, int n) {
        if (n == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        this.numer = rational.numer;
        this.denom = rational.denom * n;
        this.normalize();
        return this;
    }

    public Rational div(int n, Rational rational) {
        if (rational.numer == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        int n2 = n * rational.denom;
        int n3 = rational.numer;
        this.numer = n2;
        this.denom = n3;
        this.normalize();
        return this;
    }

    public Rational div(int n, int n2) {
        if (n2 == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        this.numer = n;
        this.denom = n2;
        this.normalize();
        return this;
    }

    public Rational min(Rational rational, Rational rational2) {
        if (rational.lt(rational2)) {
            this.assign(rational);
        } else {
            this.assign(rational2);
        }
        return this;
    }

    public Rational min(Rational rational, int n) {
        if (rational.lt(n)) {
            this.assign(rational);
        } else {
            this.assign(n);
        }
        return this;
    }

    public Rational min(int n, Rational rational) {
        if (rational.gt(n)) {
            this.assign(n);
        } else {
            this.assign(rational);
        }
        return this;
    }

    public Rational min(int n, int n2) {
        this.assign(Math.min(n, n2));
        return this;
    }

    public Rational max(Rational rational, Rational rational2) {
        if (rational.gt(rational2)) {
            this.assign(rational);
        } else {
            this.assign(rational2);
        }
        return this;
    }

    public Rational max(Rational rational, int n) {
        if (rational.gt(n)) {
            this.assign(rational);
        } else {
            this.assign(n);
        }
        return this;
    }

    public Rational max(int n, Rational rational) {
        if (rational.lt(n)) {
            this.assign(n);
        } else {
            this.assign(rational);
        }
        return this;
    }

    public Rational max(int n, int n2) {
        this.assign(Math.max(n, n2));
        return this;
    }

    public boolean eqZero() {
        return this.numer == 0;
    }

    public boolean neZero() {
        return this.numer != 0;
    }

    public boolean ltZero() {
        return this.numer < 0;
    }

    public boolean leZero() {
        return this.numer <= 0;
    }

    public boolean gtZero() {
        return this.numer > 0;
    }

    public boolean geZero() {
        return this.numer >= 0;
    }

    public boolean eq(Rational rational) {
        return this.numer == rational.numer && this.denom == rational.denom;
    }

    public boolean eq(int n) {
        return this.numer == n && this.denom == 1;
    }

    public boolean ne(Rational rational) {
        return this.numer != rational.numer || this.denom != rational.denom;
    }

    public boolean ne(int n) {
        return this.numer != n || this.denom != 1;
    }

    public boolean lt(Rational rational) {
        return new Rational().sub(this, rational).ltZero();
    }

    public boolean lt(int n) {
        return new Rational().sub(this, n).ltZero();
    }

    public boolean le(Rational rational) {
        return new Rational().sub(this, rational).leZero();
    }

    public boolean le(int n) {
        return new Rational().sub(this, n).leZero();
    }

    public boolean gt(Rational rational) {
        return new Rational().sub(this, rational).gtZero();
    }

    public boolean gt(int n) {
        return new Rational().sub(this, n).gtZero();
    }

    public boolean ge(Rational rational) {
        return new Rational().sub(this, rational).geZero();
    }

    public boolean ge(int n) {
        return new Rational().sub(this, n).geZero();
    }

    public int intValue() {
        return this.numer / this.denom;
    }

    public long longValue() {
        return (long)this.numer / (long)this.denom;
    }

    public float floatValue() {
        return (float)this.numer / (float)this.denom;
    }

    public double doubleValue() {
        return (double)this.numer / (double)this.denom;
    }

    public String toString() {
        if (this.denom == 1) {
            return Integer.toString(this.numer);
        }
        return this.numer + "/" + this.denom;
    }

    public boolean equals(Object object) {
        return object instanceof Rational && this.eq((Rational)object);
    }

    public int hashCode() {
        return this.numer + this.denom;
    }

    public int compareTo(Object object) {
        return new Rational().sub((Rational)this, (Rational)((Rational)object)).numer;
    }

    private void normalize() {
        int n = Rational.signum(this.numer) * Rational.signum(this.denom);
        this.numer = Rational.absval(this.numer);
        this.denom = Rational.absval(this.denom);
        int n2 = Rational.greatestCommonDivisor(this.numer, this.denom);
        this.numer = n * this.numer / n2;
        this.denom /= n2;
    }

    private static int signum(int n) {
        return n < 0 ? -1 : 1;
    }

    private static int absval(int n) {
        return n < 0 ? -n : n;
    }

    private static int greatestCommonDivisor(int n, int n2) {
        while (n2 != 0) {
            int n3 = n % n2;
            n = n2;
            n2 = n3;
        }
        return n;
    }

    private static int leastCommonMultiple(int n, int n2) {
        return n / Rational.greatestCommonDivisor(n, n2) * n2;
    }
}

