/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.ArraysMerger;
import base.CountObject;
import base.DebugLog;
import base.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.LinkedList;
import java.util.Properties;

public class ArraysMergerHeap {
    public static final int BUFFER_SIZE_IN = 0xC800000;
    public static final int BUFFER_SIZE_OUT = 0x1E00000;
    private int BUFFER_SIZE_PER_FILE = 0x100000;
    private MinHeapNode[] arrays;
    private int len;

    public ArraysMergerHeap(String string, String string2, int n) {
        this.len = n;
        this.arrays = new MinHeapNode[this.len];
        int n2 = Util.getMaxThreadNumber();
        this.BUFFER_SIZE_PER_FILE = 0xC800000 / n;
        DebugLog.log("Buffer size per file:" + this.BUFFER_SIZE_PER_FILE);
        int n3 = 0x100000 * n2 * 2;
        DebugLog.log("total_quque_size : " + n3);
        int n4 = n3 / n;
        for (int i = 0; i < n; ++i) {
            this.arrays[i] = new MinHeapNode(ArraysMerger.getFileName(string, string2, i), this.BUFFER_SIZE_PER_FILE, n4);
        }
    }

    private boolean isLess(CountObject countObject, CountObject countObject2) {
        if (countObject == null) {
            return false;
        }
        return countObject.compareToByKey(countObject2) < 0;
    }

    public void minHeapify(int n) {
        CountObject countObject;
        CountObject countObject2;
        int n2 = 2 * n;
        int n3 = n2 + 1;
        int n4 = n;
        CountObject countObject3 = this.arrays[n].peek();
        if (n2 < this.len) {
            countObject2 = this.arrays[n2].peek();
            if (countObject2 == null) {
                n4 = n;
            } else if (countObject3 == null) {
                n4 = n2;
            } else if (this.isLess(countObject2, countObject3)) {
                n4 = n2;
            }
        }
        countObject2 = this.arrays[n4].peek();
        if (n3 < this.len && (countObject = this.arrays[n3].peek()) != null) {
            if (countObject2 == null) {
                n4 = n3;
            } else if (this.isLess(countObject, countObject2)) {
                n4 = n3;
            }
        }
        if (n4 != n && this.arrays[n4].peek() != null) {
            this.exchange(n4, n);
            this.minHeapify(n4);
        }
    }

    public void buildMinHeap() {
        for (int i = (this.len - 1) / 2; i >= 0; --i) {
            this.minHeapify(i);
        }
    }

    public Properties output(boolean bl, String string) throws Exception {
        Object object;
        this.buildMinHeap();
        Object object2 = null;
        long l = 0L;
        DebugLog.log("Outputing to " + string);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string), 0x1E00000));
        long l2 = 0L;
        long l3 = Long.MAX_VALUE;
        long l4 = Long.MIN_VALUE;
        long l5 = 2000000L;
        while ((object = this.arrays[0].peek()) != null) {
            if (object2 == null) {
                object2 = object;
            } else if (((CountObject)object2).getKey().compareTo(((CountObject)object).getKey()) == 0) {
                ((CountObject)object2).setCount(((CountObject)object2).getCount() + ((CountObject)object).getCount());
            } else {
                if (bl) {
                    CountObject.steamOutSequenceTxt(dataOutputStream, (CountObject)object2);
                } else {
                    CountObject.steamOutSequence(dataOutputStream, (CountObject)object2);
                }
                l2 += (long)((CountObject)object2).getCount().intValue();
                if (l3 > (long)((CountObject)object2).getCount().intValue()) {
                    l3 = ((CountObject)object2).getCount().intValue();
                }
                if (l4 < (long)((CountObject)object2).getCount().intValue()) {
                    l4 = ((CountObject)object2).getCount().intValue();
                }
                object2 = object;
                if (++l == l5) {
                    DebugLog.log("Output Size:" + l);
                    l5 += 2000000L;
                }
            }
            this.arrays[0].pop();
            this.minHeapify(0);
        }
        if (object2 != null) {
            if (bl) {
                CountObject.steamOutSequenceTxt(dataOutputStream, (CountObject)object2);
            } else {
                CountObject.steamOutSequence(dataOutputStream, (CountObject)object2);
            }
            l2 += (long)((CountObject)object2).getCount().intValue();
            if (l3 > (long)((CountObject)object2).getCount().intValue()) {
                l3 = ((CountObject)object2).getCount().intValue();
            }
            if (l4 < (long)((CountObject)object2).getCount().intValue()) {
                l4 = ((CountObject)object2).getCount().intValue();
            }
            ++l;
        }
        CountObject.steamOutSequenceClose(dataOutputStream);
        dataOutputStream.flush();
        DebugLog.log("Output completed. Unique Rows:" + l);
        object = new Properties();
        ((Properties)object).put("noOfValidRead", (Object)l2);
        ((Properties)object).put("lowestCount", (Object)l3);
        ((Properties)object).put("highestCount", (Object)l4);
        return object;
    }

    private void exchange(int n, int n2) {
        MinHeapNode minHeapNode = this.arrays[n];
        this.arrays[n] = this.arrays[n2];
        this.arrays[n2] = minHeapNode;
    }

    public static class MinHeapNode {
        CountObject element;
        boolean end = false;
        String path;
        long currentPosition = 0L;
        LinkedList<CountObject> queue;
        final int OBJECT_SIZE = 16;
        int QUEUE_SIZE = 100000;
        int BUFFER_SIZE_PER_FILE = 0x100000;

        public MinHeapNode(String string, int n, int n2) {
            this.path = string;
            this.BUFFER_SIZE_PER_FILE = n;
            this.QUEUE_SIZE = n2;
            DebugLog.log("QUEUE_SIZE:" + this.QUEUE_SIZE);
            DebugLog.log("Data file path:" + this.path);
            this.reset();
        }

        public MinHeapNode(String string) {
            this.path = string;
            DebugLog.log("Data file path:" + this.path);
            this.reset();
        }

        public void reset() {
            try {
                this.currentPosition = 0L;
                this.end = false;
            }
            catch (Exception exception) {
                DebugLog.log(exception);
            }
        }

        public CountObject peek() {
            if (this.end) {
                return null;
            }
            if (this.element == null) {
                this.read();
            }
            return this.element;
        }

        public void pop() {
            if (!this.end) {
                this.read();
            }
        }

        private void readInElements() {
            this.queue = new LinkedList();
            try {
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.path), this.BUFFER_SIZE_PER_FILE));
                long l = dataInputStream.skip(this.currentPosition);
                if (l < this.currentPosition) {
                    return;
                }
                for (int i = 0; i < this.QUEUE_SIZE; ++i) {
                    this.element = CountObject.steamInSequence(dataInputStream);
                    if (this.element == null) break;
                    this.queue.addLast(this.element);
                }
                this.currentPosition += (long)(16 * this.queue.size());
                dataInputStream.close();
            }
            catch (Exception exception) {
                DebugLog.log(exception);
                throw new RuntimeException(exception);
            }
        }

        private void read() {
            if (this.end) {
                this.element = null;
                return;
            }
            try {
                if (this.queue != null && this.queue.size() > 0) {
                    this.element = this.queue.removeFirst();
                } else {
                    this.readInElements();
                    if (this.queue.size() == 0) {
                        this.end = true;
                        this.element = null;
                    } else {
                        this.element = this.queue.removeFirst();
                    }
                }
            }
            catch (Exception exception) {
                this.end = true;
                DebugLog.log(exception);
                System.err.println("Error file:" + this.path);
                throw new RuntimeException(exception);
            }
        }
    }
}

