### Name: colorRampPalette
### Title: Extend a color palette to a color ramp
### Aliases: colorRampPalette colorRamp
### Keywords: color

### ** Examples

   m<-outer(1:20,1:20,function(x,y) sin(sqrt(x*y)/3))

   redblue<-colorRampPalette(c("red","orange","blue"))
   filled.contour(m,color.palette=redblue)

   yb<-colorRampPalette(c("yellow2","goldenrod","darkred"))
   filled.contour(m,color.palette=yb)

   yb<-colorRampPalette(c("yellow2","goldenrod","darkred"),bias=0.5)
   filled.contour(m,color.palette=yb)

   ## Two ColorBrewer sequential palettes
   ylOrBn4<-c("#FFFFD4", "#FED98E", "#FE9929","#CC4C02")
   ylGnBl5<-c("#FFFFCC","#C7E9B4","#7FCDBB","#40B6C4","#2C7FB8" ,"#253494")

   ylOrBn<-colorRampPalette(ylOrBn4)
   ylGnBl<-colorRampPalette(ylGnBl5,method="spline")
   filled.contour(m,color.palette=ylOrBn)
   filled.contour(m,color.palette=ylGnBl)

   if(require("RColorBrewer")){
        RdBu7<-colorRampPalette(brewer.pal(7,"RdBu"),method="spline")
        RWB<-colorRampPalette(c("red","white","blue"))
        redblue<-colorRampPalette(c("red","blue"))
        filled.contour(m,color.palette=redblue,main="naive red-blue")
        filled.contour(m,color.palette=RWB,main="naive red-white-blue")
        filled.contour(m,color.palette=RdBu7,main="ColorBrewer RdBu7")
   }




