### Name: exprSetRG-class
### Title: Class exprSetRG for two colour DNA microarray data (extension of
###   exprSet)
### Aliases: exprSetRG-class exprSetRG as.exprSet as.RGList getExprSetGreen
###   getExprSetGreenMinusRed getExprSetRedMinusGreen getExprSetRed
###   getExprSetLogRatio getIndGreen getIndRed pDataGreen pDataRed
###   pDataSlide phenoDataGreen phenoDataRed phenoDataSlide slideSubset
###   [,exprSetRG-method as.exprSet,exprSetRG-method
###   as.RGList,exprSetRG-method getExprSetGreen,exprSetRG-method
###   getExprSetGreenMinusRed,exprSetRG-method
###   getExprSetRedMinusGreen,exprSetRG-method
###   getExprSetRed,exprSetRG-method getExprSetLogRatio,exprSetRG-method
###   getIndGreen,exprSetRG-method getIndRed,exprSetRG-method
###   initialize,exprSetRG-method pDataGreen,exprSetRG-method
###   pDataRed,exprSetRG-method pDataSlide,exprSetRG-method
###   phenoDataGreen,exprSetRG-method phenoDataRed,exprSetRG-method
###   phenoDataSlide,exprSetRG-method show,exprSetRG-method
###   slideSubset,exprSetRG-method
### Keywords: classes methods

### ** Examples

  indGreen=1:3
  indRed=4:6
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  eSA <- new("exprSetRG", exprs=matrix(1:60, ncol=6, nrow=10), phenoData=
          new("phenoData", pData=data.frame(matrix(0,nrow=6,ncol=1)),
              varLabels=list(rep("varLabel1",1))), channels=channels)
  stopifnot( all(pDataSlide(eSA) ==pData(eSA)[1:3,,drop=FALSE]) )
  eSAGreen <- getExprSetGreen(eSA)
  eSARed <- getExprSetRed(eSA)
  eSALogRatio <- getExprSetLogRatio(eSA)
  eSALogRatio2 <- getExprSetGreenMinusRed(eSA)
  eSALogRatio3 <- getExprSetRedMinusGreen(eSA)
  stopifnot( identical( eSALogRatio, eSALogRatio2 ) )
  stopifnot( identical( exprs(eSALogRatio), exprs(eSAGreen)-exprs(eSARed)) )
  stopifnot( all.equal.numeric( exprs(eSALogRatio3), exprs(eSARed)-exprs(eSAGreen)) )
  eSAPart <- eSA[,c(1,3,1,4,6,4)]
  eSAInvalid <- eSA[,c(1,3,1,5,6,4),type="invalidExprSetRG"]
  eSAPart2 <- slideSubset(eSA,j=c(1,3,1))

  eSAeSA <- cbind(eSA, eSA)
  eSAeSAPart2 <- cbind(eSA, eSAPart2)
  stopifnot( class(as.exprSet(eSA)) == "exprSet" )

  ## Don't show: 
  rg <- as.RGList(eSA)
  stopifnot( identical( exprs(eSAPart), exprs(eSAPart2) ) )
  ind <- c(1,1,3,2,3,3)
  stopifnot( identical( exprs(eSALogRatio[,ind]), exprs(eSAGreen[,ind])-exprs(eSARed[,ind])) )
  stopifnot( dim(exprs(eSALogRatio[,ind]))[2] == length(ind) )
  eSAPart <- eSA[,1:3, type="invalidExprSetRG"] # not recommended
  stopifnot(identical(eSAGreen, getExprSetGreen(eSAPart)))
  stopifnot(identical(eSAGreen[,c(1,1,1)], getExprSetGreen(eSAPart[,c(1,1,1),type="invalidExprSetRG"])))
  stopifnot(identical(eSAGreen[,c(TRUE,TRUE,TRUE)], getExprSetGreen(eSAPart[,c(TRUE,TRUE,TRUE),type="invalidExprSetRG"])))
  stopifnot(identical(eSAGreen[,c(FALSE,FALSE,FALSE)], getExprSetGreen(eSAPart[,c(FALSE,FALSE,FALSE), type="invalidExprSetRG"])))
  stopifnot(identical(eSAGreen[,c(FALSE,TRUE,FALSE)], getExprSetGreen(eSAPart[,c(FALSE,TRUE,FALSE), type="invalidExprSetRG"])))
  print(eSA)
  print(phenoDataSlide(eSA))
  print(pDataSlide(eSA))
  print(phenoDataGreen(eSA))
  print(pDataGreen(eSA))
  print(phenoDataRed(eSA))
  print(pDataRed(eSA))

  indGreen <- c(2,4); indRed <- c(1,3)
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  myPData <- data.frame(commonOne=c(1,1,2,2), first=c(1,2,3,4))
  myPDataTwo <- data.frame(commonOne=c(1,1,2,2), second=c("a","b","a","b"))
  myPDataThree <- data.frame(commonOne=c(1,1,2,2))
  myPhenoData <- new("phenoData", pData=myPData, varLabels=as.list(colnames(myPData)))
  myPhenoDataTwo <- new("phenoData", pData=myPDataTwo, varLabels=as.list(colnames(myPDataTwo)))
  myPhenoDataThree <- new("phenoData", pData=myPDataThree, varLabels=as.list(colnames(myPDataThree)))
  myMatrix <- cbind(c(1,1,1,1),c(2,2,2,2),c(3,3,3,3),c(4,4,4,4))
  myExprSetRG <- new("exprSetRG", exprs=myMatrix, se.exprs=myMatrix, phenoData=myPhenoData, channels=channels)
  myExprSetRGTwo <- new("exprSetRG", exprs=myMatrix, se.exprs=myMatrix, phenoData=myPhenoDataTwo, channels=channels)
  myExprSetRGThree <- new("exprSetRG", exprs=myMatrix, se.exprs=myMatrix, phenoData=myPhenoDataThree, channels=channels)
  stopifnot( all.equal.numeric(se.exprs(getExprSetGreen(myExprSetRG)), cbind(c(2,2,2,2),c(4,4,4,4))))
  stopifnot( all.equal.numeric(se.exprs(getExprSetRed(myExprSetRG)), cbind(c(1,1,1,1),c(3,3,3,3))))
  stopifnot( all.equal.numeric(se.exprs(getExprSetLogRatio(myExprSetRG, seExprsHandling="mean")), 0.5*cbind(c(3,3,3,3),c(7,7,7,7))))
  stopifnot( all.equal.numeric(as.vector(se.exprs(myExprSetRG[2,])) , c(1,2,3,4)) )
  stopifnot( all.equal.numeric(as.vector(se.exprs(myExprSetRG[2,3:4])) , c(3,4)) )
  stopifnot( all.equal.numeric( se.exprs(cbind(myExprSetRG,myExprSetRG)), cbind(se.exprs(myExprSetRG),se.exprs(myExprSetRG))) )
  stopifnot( all.equal.numeric(exprs(getExprSetLogRatio(myExprSetRG)), matrix(1,ncol=4,nrow=2))) 
  cTwo <- cbind(myExprSetRG, myExprSetRGTwo)
  cThree <- cbind(myExprSetRG, myExprSetRGTwo, myExprSetRGThree)
  cTwob <- cbind(myExprSetRG, myExprSetRGThree)
  # match corresponds to %in% , i.e. 
  stopifnot( all( match(varLabels(cTwo),  c("commonOne", "first", "second")) ) ) 
  stopifnot( all( match(varLabels(cTwob),c("commonOne", "first")) ) )
  stopifnot( all( match(varLabels(cThree), c("commonOne", "first", "second")) ) )
  stopifnot( all( pData(cTwo)[,"commonOne"] ==  pData(cTwob)[,"commonOne"] ) )

  indGreen <- c(2,4,6); indRed <- c(1,3,5)
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  myPData <- data.frame(commonOne=c(1,1,2,2,3,3), commonTwo=c(1,1,1,1,2,2), redOne=c(1,NA,2,NA,3,NA), redTwo=c(1,-1,2,-1,3,-1), greenOne=c(NA,10,NA,20,NA,30), greenTwo=c(-10,10,-10,20,-10,30))
  myPhenoData <- new("phenoData", pData=myPData, varLabels=as.list(colnames(myPData)))
  myExprSetRG <- new("exprSetRG", exprs=matrix(1,nrow=10,ncol=6), phenoData=myPhenoData, channels=channels)
  stopifnot( all.equal( myPData[indRed,] , pDataRed(myExprSetRG) ) )
  stopifnot( all.equal( myPData[indGreen,] , pDataGreen(myExprSetRG) ) )
  stopifnot( all.equal( myPhenoData[indRed,] , phenoDataRed(myExprSetRG) ) )
  stopifnot( all.equal( myPhenoData[indGreen,] , phenoDataGreen(myExprSetRG) ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("commonOne","commonTwo")] == pDataRed(myExprSetRG)[,c("commonOne","commonTwo")] ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("commonOne","commonTwo")] == pDataGreen(myExprSetRG)[,c("commonOne","commonTwo")] ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("greenSpecific_greenOne","greenSpecific_greenTwo")] == pDataGreen(myExprSetRG)[,c("greenOne","greenTwo")] ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("redSpecific_redOne","redSpecific_redTwo")] == pDataRed(myExprSetRG)[,c("redOne","redTwo")] ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("greenSpecific_redTwo")] == pDataGreen(myExprSetRG)[,c("redTwo")] ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("redSpecific_greenTwo")] == pDataRed(myExprSetRG)[,c("greenTwo")] ) )
  ## End Don't show
 


