/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf.util;

import java.awt.geom.AffineTransform;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.jfree.pdf.util.Args;

public class PDFUtils {
    private PDFUtils() {
    }

    public static String toPDFArray(boolean[] b) {
        Args.nullNotPermitted(b, "b");
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < b.length; ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(String.valueOf(b[i]));
        }
        return sb.append("]").toString();
    }

    public static String toPDFArray(float[] f) {
        Args.nullNotPermitted(f, "f");
        StringBuilder b = new StringBuilder("[");
        for (int i = 0; i < f.length; ++i) {
            if (i != 0) {
                b.append(" ");
            }
            b.append(String.valueOf(f[i]));
        }
        return b.append("]").toString();
    }

    public static String toPDFArray(double[] d) {
        Args.nullNotPermitted(d, "d");
        StringBuilder b = new StringBuilder("[");
        for (int i = 0; i < d.length; ++i) {
            if (i != 0) {
                b.append(" ");
            }
            b.append(String.valueOf(d[i]));
        }
        return b.append("]").toString();
    }

    public static String transformToPDF(AffineTransform t) {
        Args.nullNotPermitted(t, "t");
        StringBuilder b = new StringBuilder("[");
        b.append(t.getScaleX()).append(" ");
        b.append(t.getShearY()).append(" ");
        b.append(t.getShearX()).append(" ");
        b.append(t.getScaleY()).append(" ");
        b.append(t.getTranslateX()).append(" ");
        b.append(t.getTranslateY());
        return b.append("]").toString();
    }

    public static String toDateFormat(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return PDFUtils.toPDFDateFormat(c);
    }

    public static String toPDFDateFormat(Calendar calendar) {
        Date d = calendar.getTime();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat df2 = new SimpleDateFormat("Z");
        String part1 = df1.format(d);
        String part2 = df2.format(d);
        Object tzinfo = part2.equals("z") ? "Z00'00'" : part2.substring(0, 3) + "'" + part2.substring(4) + "'";
        return "D:" + part1 + (String)tzinfo;
    }

    public static byte[] toBytes(String s) {
        byte[] result = null;
        try {
            result = s.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }
}

