/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.comparison;

import edu.msu.cme.rdp.classifier.comparison.AbstractNode;
import edu.msu.cme.rdp.classifier.comparison.ComparisonBrowserNode;
import edu.msu.cme.rdp.classifier.comparison.Score;
import edu.msu.cme.rdp.classifier.comparison.SigCalculator;
import edu.msu.cme.rdp.classifier.comparison.UncNode;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TaxonTree
extends AbstractNode {
    private int taxid;
    private String name;
    private String rank;
    private AbstractNode firstChild;
    private Score firstS1Score;
    private Score lastS1Score;
    private Score firstS2Score;
    private Score lastS2Score;

    public TaxonTree(int id, String name, String rank, AbstractNode p) {
        this.taxid = id;
        this.name = name;
        this.rank = rank;
        this.setParent(p);
    }

    @Override
    public Iterator getDetailIterator(float conf) {
        DetailIterator it = new DetailIterator(conf);
        return it;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRank() {
        return this.rank;
    }

    @Override
    public int getTaxid() {
        return this.taxid;
    }

    @Override
    AbstractNode getFirstChild() {
        return this.firstChild;
    }

    Score getFirstS1Score() {
        return this.firstS1Score;
    }

    Score getFirstS2Score() {
        return this.firstS2Score;
    }

    private Score getLastS1Score() {
        return this.lastS1Score;
    }

    private Score getLastS2Score() {
        return this.lastS2Score;
    }

    protected void addChild(AbstractNode n) {
        if (this.firstChild == null) {
            UncNode unc_child = new UncNode(this);
            this.firstChild = unc_child;
        }
        AbstractNode temp = this.firstChild;
        this.firstChild = n;
        this.firstChild.addSibling(temp);
    }

    private void setFirstS1Score(Score s) {
        this.firstS1Score = s;
        this.lastS1Score = s;
    }

    private void setFirstS2Score(Score s) {
        this.firstS2Score = s;
        this.lastS2Score = s;
    }

    protected void addS1Score(Score s) {
        this.incS1Count(1);
        if (this.lastS1Score == null) {
            this.setFirstS1Score(s);
            return;
        }
        this.lastS1Score.setNextSeqScore(s);
        this.lastS1Score = s;
    }

    protected void addS2Score(Score s) {
        this.incS2Count(1);
        if (this.lastS2Score == null) {
            this.setFirstS2Score(s);
            return;
        }
        this.lastS2Score.setNextSeqScore(s);
        this.lastS2Score = s;
    }

    TaxonTree getChildbyTaxid(int taxid, String name, String rank) {
        AbstractNode child;
        boolean found = false;
        for (child = this.firstChild; child != null; child = child.getNextSibling()) {
            if (child.getTaxid() != taxid) continue;
            found = true;
            break;
        }
        if (!found) {
            child = new TaxonTree(taxid, name, rank, this);
            this.addChild(child);
        }
        return (TaxonTree)child;
    }

    @Override
    public void changeConfidence(SigCalculator cal) {
        this.resetCount();
        for (Score s1Score = this.firstS1Score; s1Score != null; s1Score = s1Score.getNextSeqScore()) {
            if (!(s1Score.getScore() >= cal.getConfidence())) continue;
            this.incS1Count(1);
        }
        for (Score s2Score = this.firstS2Score; s2Score != null; s2Score = s2Score.getNextSeqScore()) {
            if (!(s2Score.getScore() >= cal.getConfidence())) continue;
            this.incS2Count(1);
        }
        this.setSignificance(cal.calculateSig(this.getS1Count(), this.getS2Count()));
        if (this.firstChild != null) {
            this.firstChild.changeConfidence(cal);
        }
        if (this.getNextSibling() != null) {
            this.getNextSibling().changeConfidence(cal);
        }
    }

    @Override
    public ComparisonBrowserNode findNode(int id) {
        if (this.taxid == id) {
            return this;
        }
        ComparisonBrowserNode node = this.firstChild;
        if (node != null && (node = node.findNode(id)) != null) {
            return node;
        }
        node = this.getNextSibling();
        if (node != null) {
            node = node.findNode(id);
        }
        return node;
    }

    class SampleDetailIterator
    implements Iterator {
        private Object onDeck;
        private Score curScore;
        private float confCutoff;

        public SampleDetailIterator(Score s, float conf) {
            Score score = s;
            this.confCutoff = conf;
            this.setNextElement(score);
        }

        @Override
        public boolean hasNext() {
            return this.onDeck != null;
        }

        public Object next() {
            if (this.onDeck == null) {
                throw new NoSuchElementException();
            }
            Object tmp = this.onDeck;
            Score score = this.curScore.getNextSeqScore();
            this.setNextElement(score);
            return tmp;
        }

        private void setNextElement(Score score) {
            while (score != null && !(score.getScore() >= this.confCutoff)) {
                score = score.getNextSeqScore();
            }
            if (score != null) {
                this.onDeck = score.getSeqInfo();
                this.curScore = score;
            } else {
                this.onDeck = null;
            }
        }

        @Override
        public void remove() throws UnsupportedOperationException {
        }
    }

    class DetailIterator
    implements Iterator {
        private Object onDeck;
        private Iterator s1DetailIterator;
        private Iterator s2DetailIterator;

        public DetailIterator(float conf) {
            this.s1DetailIterator = new SampleDetailIterator(TaxonTree.this.firstS1Score, conf);
            this.s2DetailIterator = new SampleDetailIterator(TaxonTree.this.firstS2Score, conf);
            this.setNextElement(this.s1DetailIterator, this.s2DetailIterator);
        }

        @Override
        public boolean hasNext() {
            return this.onDeck != null;
        }

        public Object next() {
            if (this.onDeck == null) {
                throw new NoSuchElementException();
            }
            Object tmp = this.onDeck;
            this.setNextElement(this.s1DetailIterator, this.s2DetailIterator);
            return tmp;
        }

        private void setNextElement(Iterator s1, Iterator s2) {
            this.onDeck = s1.hasNext() ? s1.next() : (s2.hasNext() ? s2.next() : null);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
        }
    }
}

