/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers.core;

import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.core.SeqReaderCore;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenbankTaxonCore
extends SeqReaderCore {
    public GenbankTaxonCore(File seqFile) throws IOException {
        super(seqFile);
    }

    public GenbankTaxonCore(InputStream is) throws IOException {
        super(is);
    }

    @Override
    public Map<String, Long> scanInternal() throws IOException {
        RandomAccessFile seqFile = super.getRawFile();
        seqFile.seek(0L);
        long firstHeader = seqFile.getFilePointer();
        long lastHeader = seqFile.getFilePointer();
        LinkedHashMap<String, Long> seqIndex = new LinkedHashMap<String, Long>();
        while (seqFile.getFilePointer() != seqFile.length()) {
            String sid = this.parseSid();
            seqIndex.put(sid, lastHeader);
            this.readUntilNext("\n//");
            lastHeader = seqFile.getFilePointer();
        }
        seqFile.seek(firstHeader);
        return seqIndex;
    }

    public int scanToStream(DataOutputStream out) throws IOException {
        RandomAccessFile seqFile = super.getRawFile();
        seqFile.seek(0L);
        long firstHeader = seqFile.getFilePointer();
        long lastHeader = seqFile.getFilePointer();
        out.writeLong(seqFile.length());
        out.writeUTF(SequenceFormat.GENBANK.toString());
        int written = 0;
        while (seqFile.getFilePointer() != seqFile.length()) {
            String sid = this.parseSid();
            out.writeUTF(sid);
            out.writeLong(lastHeader);
            ++written;
            this.readUntilNext("\n//");
            lastHeader = seqFile.getFilePointer();
        }
        out.close();
        seqFile.seek(firstHeader);
        return written;
    }

    @Override
    public Sequence readNextSeq() throws IOException {
        String line;
        String seqid = null;
        String seqString = null;
        StringBuilder desc = new StringBuilder();
        StringBuilder taxonomy = new StringBuilder();
        boolean appendDesc = false;
        boolean appendTaxonomy = false;
        while ((line = this.readUntilNext('\n')) != null && !(line = line.trim()).equals("//")) {
            if (line.isEmpty()) continue;
            String[] lexemes = line.split("\\s+");
            if (lexemes[0].equals("VERSION")) {
                seqid = lexemes[1];
                continue;
            }
            if (lexemes[0].equals("ORGANISM")) {
                desc.append(line.substring("ORGANISM".length()).trim());
                appendDesc = true;
                continue;
            }
            if (lexemes[0].equals("REFERENCE")) {
                appendDesc = false;
                continue;
            }
            if (lexemes[0].equals("ORIGIN")) {
                seqString = this.parseSeq();
                break;
            }
            if (!appendDesc) continue;
            if (line.contains(";")) {
                appendTaxonomy = true;
            }
            if (!appendTaxonomy) {
                desc.append(" " + line);
                continue;
            }
            taxonomy.append(" " + line);
        }
        if (seqid == null) {
            return null;
        }
        String taxonomyStr = "";
        String[] vals = taxonomy.toString().split(";");
        taxonomyStr = taxonomyStr + vals[0].trim();
        for (int i = 1; i < vals.length - 1; ++i) {
            taxonomyStr = taxonomyStr + ";" + vals[i].trim();
        }
        taxonomyStr = vals[vals.length - 1].trim().endsWith(".") ? taxonomyStr + ";" + vals[vals.length - 1].trim().substring(0, vals[vals.length - 1].length() - 2) : taxonomyStr + ";" + vals[vals.length - 1].trim();
        desc.append("\t" + taxonomyStr);
        return new Sequence(seqid, desc.toString(), seqString.replaceAll("\\s+", "").toUpperCase());
    }

    private String parseSid() throws IOException {
        return this.readUntilNext(' ', '\t', '\n', '\r');
    }

    private String parseSeq() throws IOException {
        StringBuilder retSeq = new StringBuilder();
        String seq = this.readUntilNext("//");
        if (seq == null) {
            return null;
        }
        seq = seq.trim();
        for (String line : seq.split("\n")) {
            int idx = (line = line.trim()).indexOf(" ");
            if (idx == -1) {
                Logger.getLogger(this.getClass().getCanonicalName()).log(Level.WARNING, "Weird sequence parsing seqbuffer={0}, currseq={1}", new Object[]{seq, retSeq});
                continue;
            }
            retSeq.append(line.substring(idx));
        }
        return retSeq.toString();
    }
}

