/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.job;

import edu.rit.pj.job.Job;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JobGenerator
implements Iterable<Job> {
    private Set<Integer> myOmittedJobNumbers = new HashSet<Integer>();

    public void omit(Set<Integer> set) {
        this.myOmittedJobNumbers.clear();
        this.myOmittedJobNumbers.addAll(set);
    }

    @Override
    public Iterator<Job> iterator() {
        return new Iterator<Job>(){
            private int N;
            private int myJobNumber;
            private boolean generated;
            {
                this.N = JobGenerator.this.jobCount();
                this.myJobNumber = -1;
                this.generated = true;
            }

            @Override
            public boolean hasNext() {
                this.advance();
                return this.myJobNumber < this.N;
            }

            @Override
            public Job next() {
                this.advance();
                if (this.myJobNumber >= this.N) {
                    throw new NoSuchElementException();
                }
                this.generated = true;
                return JobGenerator.this.createJob(this.myJobNumber);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void advance() {
                if (this.generated) {
                    this.generated = false;
                    do {
                        ++this.myJobNumber;
                    } while (this.myJobNumber < this.N && JobGenerator.this.myOmittedJobNumbers.contains(this.myJobNumber));
                }
            }
        };
    }

    protected abstract int jobCount();

    protected abstract Job createJob(int var1);
}

