tabPanel("Differential Expression Analysis",
         # Application title
         titlePanel("Differential Expression Analysis"),
         sidebarLayout(
           sidebarPanel(
            selectizeInput('DE_method',
                   'Choose analysis method',
                   multiple = FALSE,
                   choices = c('DESeq2', 'limma', 'edgeR', 'ANOVA', 'Kruskal-Wallis'), # 'wilcox'),
                   selected = NULL,
                   options = list(placeholder = 'Please select an option below',
                       onInitialize = I('function() { this.setValue(""); }'))),
            selectizeInput('DE_assay',
                 'Choose assay to analyze',
                 choices = "",
                 options = list(placeholder = 'Please select an option below',
                    onInitialize = I('function() { this.setValue(""); }'))),
            selectizeInput('DE_batch',
                 'Choose batch covariate',
                 choices = "",
                 options = list(placeholder = 'Please select an option below',
                    onInitialize = I('function() { this.setValue(""); }'))),
            selectizeInput('DE_conditions',
                 'Choose analysis covariate(s)',
                 choices = c(),
                 multiple = TRUE,
                 selected = NULL,
                 options = list(placeholder = 'Please select an option below',
                     onInitialize = I('function() { this.setValue(""); }'))),
            selectizeInput('padj_method',
                'Choose p.adjust method',
                choices = p.adjust.methods[p.adjust.methods != "none"],
                options = list(placeholder = 'Please select an option below',
                    onInitialize = I('function() { this.setValue(""); }'))),
            withBusyIndicatorUI(actionButton('DE_analyze', label = 'Here we go!'))),
           mainPanel(
             h4(strong("Usage")),
             h5("Each differential expression method requires a specific type of input. Please provide raw counts data or DESeq-normalized data for DESeq, normalized log or log-CPM data for limma, edgeR-normalized data for edgeR, and normalized data for ANOVA."),
             tabsetPanel(
               tabPanel("Results Table",
                       selectizeInput("result_to_view",
                           'Choose analysis results to display',
                           choices = "",
                           options = list(placeholder = 'Please select an option below',
                               onInitialize = I('function() { this.setValue(""); }'))),
                        DTOutput('DE_results'),
                        conditionalPanel(condition = "output.DE_results",
                                         downloadButton("downloadDEData",
                                             "Download"))),
               tabPanel("P-Value Analysis",
                        plotOutput('pval_plot'),
                        h5("P-Value Summary Table"),
                        DTOutput('pval_summary')),
               tabPanel("Volcano Plot",
                   selectizeInput('DE_res_selected',
                       'Choose analysis results to display',
                       choices = "",
                       options = list(placeholder = 'Please select an option below',
                           onInitialize = I('function() { this.setValue(""); }'))),
                   sliderInput(inputId = "pslider",
                       label = "Select the magnitude of significance value coloring:",
                       min = 0,
                       max = 1,
                       value = 0.05,
                       round = FALSE,
                       ticks = TRUE,
                       step = 0.001),
                   sliderInput(inputId = "fcslider",
                       label = "Select the magnitude of expression change value coloring:",
                       min = -10,
                       max = 10,
                       value = 0,
                       step = NULL,
                       round = FALSE,
                       ticks = TRUE),
                    actionButton("volcano_plot", "Run", class = "btn-primary"),
                    plotlyOutput('volcano', height = 'auto', width = 'auto')
               )
             )
           )
         )
)
