/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.datastructures;

import fr.cea.ig.metatarget.datastructures.ClusterPoisson;
import fr.cea.ig.metatarget.datastructures.Dictionary;
import fr.cea.ig.metatarget.utils.Utils;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.hash.TIntLongHashMap;
import java.util.concurrent.CountDownLatch;

public class EMasync {
    private static final int maxRuns = 25;
    private static final double CONVERGE_THRESHOLD = 1.0E-5;
    private final int numberOfClusters;
    private final TIntLongHashMap countsHisto;
    private final int excludeMin;
    private final int excludeMax;
    private int kmerHighestCount;
    private double kmerThreshold = 0.5;
    private double readThreshold = 0.5;
    private double[] clusterSizes;
    private double[] clusterAbundances;
    private double[] currAbundances;
    private double[] currClassSize;
    private double[] prevClassSize;
    private double[] prevClassAbundance;
    private double[][] countPoissonClass;

    public double[] getClusterAbundances() {
        return this.clusterAbundances;
    }

    public double[] getClusterSizes() {
        return this.clusterSizes;
    }

    public EMasync(int numberOfClusters, int excludeMin, int excludeMax, Dictionary dictionary) {
        this.numberOfClusters = numberOfClusters;
        this.countsHisto = dictionary.getCountsHisto();
        this.excludeMin = excludeMin;
        this.excludeMax = excludeMax;
        this.kmerHighestCount = dictionary.getMaxCount();
        if (excludeMax != 0 && this.kmerHighestCount > excludeMax) {
            this.kmerHighestCount = excludeMax;
        }
        this.kmerThreshold = 1.0 / (double)numberOfClusters;
        this.clusterSizes = new double[numberOfClusters];
        this.clusterAbundances = new double[numberOfClusters];
        this.currAbundances = new double[numberOfClusters];
        this.currClassSize = new double[numberOfClusters];
        this.prevClassSize = new double[numberOfClusters];
        this.prevClassAbundance = new double[numberOfClusters];
        int j = 10 * (numberOfClusters - 1);
        for (int i = 0; i < numberOfClusters; ++i) {
            this.clusterAbundances[i] = j;
            this.prevClassAbundance[i] = this.clusterAbundances[i];
            if ((j -= 10) == 0) {
                j = 1;
            }
            this.clusterSizes[i] = 1000000.0;
            this.prevClassSize[i] = this.clusterSizes[i];
        }
        this.countPoissonClass = new double[this.kmerHighestCount + 1][numberOfClusters];
    }

    private double safeDivideWith(double div) {
        return div == 0.0 ? 1.0 : div;
    }

    public void performEM() {
        try {
            CountDownLatch doneSignal = new CountDownLatch(this.numberOfClusters);
            for (int i = 0; i < this.numberOfClusters; ++i) {
                Thread t = new Thread(new EMThread(i, doneSignal));
                t.start();
            }
            doneSignal.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class EMThread
    implements Runnable {
        private int clusterId;
        private CountDownLatch doneSignal;

        private EMThread(int clusterId, CountDownLatch doneSignal) {
            this.clusterId = clusterId;
            this.doneSignal = doneSignal;
        }

        @Override
        public void run() {
            int convflag;
            boolean zeroflag;
            int k = 0;
            do {
                System.out.println("Cluster=" + this.clusterId + "\tRun=" + ++k);
                ((EMasync)EMasync.this).currAbundances[this.clusterId] = EMasync.this.clusterAbundances[this.clusterId];
                ((EMasync)EMasync.this).currClassSize[this.clusterId] = EMasync.this.clusterSizes[this.clusterId];
                for (int cnt = 1; cnt <= EMasync.this.kmerHighestCount; ++cnt) {
                    if (cnt < EMasync.this.excludeMin || EMasync.this.excludeMax != 0 && cnt > EMasync.this.excludeMax) continue;
                    ((EMasync)EMasync.this).countPoissonClass[cnt][this.clusterId] = 0.0;
                    for (int j = 0; j < EMasync.this.numberOfClusters; ++j) {
                        double lnSum = ClusterPoisson.lnPoissonProbabilitySum(EMasync.this.currAbundances[j], EMasync.this.currAbundances[this.clusterId], cnt, EMasync.this.currClassSize[j]);
                        double tempSum = Math.exp(lnSum);
                        if (Double.isInfinite(tempSum)) {
                            ((EMasync)EMasync.this).countPoissonClass[cnt][this.clusterId] = Double.POSITIVE_INFINITY;
                            break;
                        }
                        double[] dArray = EMasync.this.countPoissonClass[cnt];
                        int n = this.clusterId;
                        dArray[n] = dArray[n] + tempSum;
                    }
                    ((EMasync)EMasync.this).countPoissonClass[cnt][this.clusterId] = EMasync.this.currClassSize[this.clusterId] / EMasync.this.countPoissonClass[cnt][this.clusterId];
                }
                ((EMasync)EMasync.this).prevClassSize[this.clusterId] = EMasync.this.clusterSizes[this.clusterId];
                ((EMasync)EMasync.this).clusterSizes[this.clusterId] = 0.0;
                ((EMasync)EMasync.this).prevClassAbundance[this.clusterId] = EMasync.this.clusterAbundances[this.clusterId];
                ((EMasync)EMasync.this).clusterAbundances[this.clusterId] = 0.0;
                TIntLongIterator it = EMasync.this.countsHisto.iterator();
                while (it.hasNext()) {
                    it.advance();
                    int count = it.key();
                    long countAbundance = it.value();
                    if (count < EMasync.this.excludeMin || EMasync.this.excludeMax != 0 && count > EMasync.this.excludeMax) continue;
                    double[] dArray = EMasync.this.clusterSizes;
                    int n = this.clusterId;
                    dArray[n] = dArray[n] + (double)countAbundance * EMasync.this.countPoissonClass[count][this.clusterId];
                    double[] dArray2 = EMasync.this.clusterAbundances;
                    int n2 = this.clusterId;
                    dArray2[n2] = dArray2[n2] + (double)countAbundance * (EMasync.this.countPoissonClass[count][this.clusterId] * (double)count);
                }
                double[] dArray = EMasync.this.clusterAbundances;
                int n = this.clusterId;
                dArray[n] = dArray[n] / EMasync.this.safeDivideWith(EMasync.this.clusterSizes[this.clusterId]);
                zeroflag = false;
                convflag = 0;
                if (EMasync.this.clusterAbundances[this.clusterId] == 0.0 || EMasync.this.clusterSizes[this.clusterId] == 0.0) {
                    zeroflag = true;
                    continue;
                }
                double fTemp = (EMasync.this.clusterAbundances[this.clusterId] - EMasync.this.prevClassAbundance[this.clusterId]) / EMasync.this.safeDivideWith(EMasync.this.prevClassAbundance[this.clusterId]);
                if (fTemp < 0.0) {
                    fTemp *= -1.0;
                }
                if (fTemp < 1.0E-5) {
                    ++convflag;
                }
                if ((fTemp = (EMasync.this.clusterSizes[this.clusterId] - EMasync.this.prevClassSize[this.clusterId]) / EMasync.this.safeDivideWith(EMasync.this.prevClassSize[this.clusterId])) < 0.0) {
                    fTemp *= -1.0;
                }
                if (!(fTemp < 1.0E-5)) continue;
                ++convflag;
            } while (!zeroflag && convflag != 2 && k < 25);
            System.out.println(Utils.time() + "\tCluster " + this.clusterId + " abundance=" + EMasync.this.clusterAbundances[this.clusterId]);
            System.out.println(Utils.time() + "\tCluster " + this.clusterId + " length=" + EMasync.this.clusterSizes[this.clusterId]);
            System.out.println(Utils.time() + "\tCluster " + this.clusterId + " Runs=" + k);
            this.doneSignal.countDown();
        }
    }
}

