/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget;

import fr.cea.ig.metatarget.MetaBin;
import fr.cea.ig.metatarget.datastructures.FastaManager;
import fr.cea.ig.metatarget.datastructures.Sequence;
import fr.cea.ig.metatarget.datastructures.SequenceProcessor;
import fr.cea.ig.metatarget.kmeans.ClusterVectorCB;
import fr.cea.ig.metatarget.kmeans.ConcurrentKMeans;
import fr.cea.ig.metatarget.utils.Utils;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;

public class MTxCB
implements MetaBin {
    private static String version;
    private static FastaManager frm;
    private StringBuilder sb = null;
    private TIntIntHashMap sequenceAssignmentsCB;
    private TIntObjectHashMap<double[]> sequenceDistancesCB;
    private List<BufferedOutputStream> bos;
    private List<AtomicInteger> spc;

    public String go(String[] args) throws Exception {
        version = new Date(Utils.classBuildTimeMillis(this.getClass())).toString();
        System.out.println("version MTxCB =" + version);
        int numOfThreads = 1;
        int kCB = 4;
        int numOfClustersCB = 5;
        List<String> inputFastaFileNames = null;
        String outputClustersFileNamePrefix = null;
        boolean keepQualities = false;
        boolean compressOut = false;
        boolean dryRun = false;
        BasicParser parser = new BasicParser();
        Options options = this.createOptions();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
            if (args.length < 1) {
                throw new Exception();
            }
            if (cmd.hasOption("t")) {
                numOfThreads = Integer.parseInt(cmd.getOptionValue("t"));
            }
            if (cmd.hasOption("kCB")) {
                kCB = Integer.parseInt(cmd.getOptionValue("kCB"));
            }
            if (cmd.hasOption("nCB")) {
                numOfClustersCB = Integer.parseInt(cmd.getOptionValue("nCB"));
            }
            if (cmd.hasOption("i")) {
                inputFastaFileNames = Arrays.asList(cmd.getOptionValues("i"));
            }
            if (cmd.hasOption("oCB")) {
                outputClustersFileNamePrefix = cmd.getOptionValue("oCB");
            }
            if (cmd.hasOption("q")) {
                keepQualities = true;
            }
            if (cmd.hasOption("z")) {
                compressOut = true;
            }
            if (cmd.hasOption("d")) {
                dryRun = true;
            }
        }
        catch (Exception exp) {
            formatter.printHelp("MTxCB", options, true);
            exp.printStackTrace(System.err);
            return null;
        }
        this.sequenceAssignmentsCB = new TIntIntHashMap();
        this.sequenceDistancesCB = new TIntObjectHashMap();
        this.sb = new StringBuilder();
        this.processSequencesCB_count(numOfThreads, kCB, inputFastaFileNames);
        System.out.println(Utils.RAMInfo(Runtime.getRuntime()));
        ClusterVectorCB[] clusterVectorsCB = this.createCBClusterVectors(numOfThreads, numOfClustersCB, kCB, frm.getStaticSequences());
        this.parseAssignmentsCB(clusterVectorsCB);
        this.prepareOutputFiles(numOfClustersCB, outputClustersFileNamePrefix, keepQualities, compressOut, dryRun);
        this.processSequencesCB_assign(numOfThreads, inputFastaFileNames, keepQualities);
        this.closeOutputFiles(numOfClustersCB);
        System.out.println(Utils.RAMInfo(Runtime.getRuntime()));
        return this.sb.toString();
    }

    private Options createOptions() {
        Options options = new Options();
        OptionBuilder.withArgName("numOfThreads");
        OptionBuilder.withLongOpt("numOfThreads");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Number of threads to use.");
        OptionBuilder.isRequired(false);
        Option t = OptionBuilder.create("t");
        options.addOption(t);
        OptionBuilder.withArgName("kMerSizeCB");
        OptionBuilder.withLongOpt("kMerSizeCB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("k-mer length for CB.");
        OptionBuilder.isRequired(false);
        Option kCB = OptionBuilder.create("kCB");
        options.addOption(kCB);
        OptionBuilder.withArgName("input");
        OptionBuilder.withLongOpt("input");
        OptionBuilder.hasArgs(Integer.MAX_VALUE);
        OptionBuilder.withDescription("Input Fasta/q files paths.");
        OptionBuilder.isRequired(true);
        Option input = OptionBuilder.create("i");
        options.addOption(input);
        OptionBuilder.withArgName("outputCB");
        OptionBuilder.withLongOpt("outputCB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Output Composition Based Clusters files prefix.");
        OptionBuilder.isRequired(true);
        Option output_CB = OptionBuilder.create("oCB");
        options.addOption(output_CB);
        OptionBuilder.withArgName("numOfClustersCB");
        OptionBuilder.withLongOpt("numOfClustersCB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Number of Clusters for CB.");
        OptionBuilder.isRequired(false);
        Option numOfClustersCB = OptionBuilder.create("nCB");
        options.addOption(numOfClustersCB);
        OptionBuilder.withArgName("q");
        OptionBuilder.withLongOpt("quality");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Keep qualities.");
        OptionBuilder.isRequired(false);
        Option keepQualities = OptionBuilder.create("q");
        options.addOption(keepQualities);
        OptionBuilder.withArgName("z");
        OptionBuilder.withLongOpt("gzip");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Compress output.");
        OptionBuilder.isRequired(false);
        Option compressOut = OptionBuilder.create("z");
        options.addOption(compressOut);
        OptionBuilder.withArgName("d");
        OptionBuilder.withLongOpt("dry");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Dry run.");
        OptionBuilder.isRequired(false);
        Option dryRun = OptionBuilder.create("d");
        options.addOption(dryRun);
        return options;
    }

    private void processSequencesCB_count(int numOfThreads, int kCB, List<String> inputFastaFileNames) {
        try {
            int cpus = Runtime.getRuntime().availableProcessors();
            int usingThreads = cpus < numOfThreads ? cpus : numOfThreads;
            System.out.println("cpus=" + cpus);
            System.out.println("using=" + usingThreads);
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            System.out.println(Utils.time() + " START of CB Counting");
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, SequenceProcessor> sequenceProcessors = new HashMap<Integer, SequenceProcessor>();
            if (frm != null) {
                frm.clear();
                frm = null;
            }
            frm = new FastaManager(false, inputFastaFileNames, startSignal, doneSignal);
            pool.execute(frm);
            SequenceProcessor.resetCounters();
            for (int i = 0; i < usingThreads; ++i) {
                SequenceProcessor sp = new SequenceProcessor(this, null, frm, SequenceProcessor.MODE.CB_SEQUENCEVECTORBUILD, kCB, startSignal, doneSignal, null);
                sequenceProcessors.put(sp.getId(), sp);
                pool.execute(sp);
            }
            doneSignal.await();
            pool.shutdown();
            System.out.println(Utils.time() + " END of CB Counting");
            System.out.println(Utils.time() + " Loaded sequences: " + SequenceProcessor.getSequenceCount().get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ClusterVectorCB[] createCBClusterVectors(int numOfThreads, int numOfClustersCB, int kCB, List<Sequence> sequences) {
        try {
            int cpus = Runtime.getRuntime().availableProcessors();
            int usingThreads = cpus < numOfThreads ? cpus : numOfThreads;
            System.out.println("cpus=" + cpus);
            System.out.println("using=" + usingThreads);
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(1);
            ExecutorService pool = Executors.newFixedThreadPool(1);
            System.out.println(Utils.time() + " START of Creating CB Clusters\tSize=" + sequences.size());
            ConcurrentKMeans kMeans = new ConcurrentKMeans(numOfClustersCB, kCB, sequences, 25, System.currentTimeMillis(), usingThreads, startSignal, doneSignal);
            pool.execute(kMeans);
            startSignal.countDown();
            doneSignal.await();
            pool.shutdown();
            System.out.println(Utils.time() + " END of Creating CB Clusters.");
            return kMeans.getClusters();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private void parseAssignmentsCB(ClusterVectorCB[] CBClusters) {
        try {
            for (int i = 0; i < CBClusters.length; ++i) {
                for (int seq_index : CBClusters[i].getMemberIndexes()) {
                    this.sequenceAssignmentsCB.put(seq_index + 1, i + 1);
                }
            }
            for (Sequence s : frm.getStaticSequences()) {
                this.sequenceDistancesCB.put(s.getSequenceId(), s.getDistancesToClusters());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareOutputFiles(int numOfClustersCB, String outputClustersFileNamePrefix, boolean keepQualities, boolean compressOut, boolean dryRun) {
        try {
            this.bos = Arrays.asList(new BufferedOutputStream[numOfClustersCB + 1]);
            this.spc = new ArrayList<AtomicInteger>();
            for (int i = 0; i < numOfClustersCB; ++i) {
                if (!dryRun) {
                    File f = compressOut ? new File(outputClustersFileNamePrefix + "__CB." + (i + 1) + (MTxCB.frm.isFastq && keepQualities ? ".fastq.gz" : ".fasta.gz")).getCanonicalFile() : new File(outputClustersFileNamePrefix + "__CB." + (i + 1) + (MTxCB.frm.isFastq && keepQualities ? ".fastq" : ".fasta")).getCanonicalFile();
                    f.getParentFile().mkdirs();
                    BufferedOutputStream bo = null;
                    bo = compressOut ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(f))) : new BufferedOutputStream(new FileOutputStream(f));
                    this.bos.set(i, bo);
                }
                this.spc.add(new AtomicInteger(0));
            }
            List numbers = Stream.iterate(1, n -> n + 1).limit(numOfClustersCB).collect(Collectors.toList());
            String line = "read_id\tCB\tCB." + numbers.stream().map(String::valueOf).collect(Collectors.joining("\tCB.")) + "\n";
            this.sb.append(line);
            if (!dryRun) {
                File f = new File(outputClustersFileNamePrefix + "__CB.assignments.tsv").getCanonicalFile();
                f.getParentFile().mkdirs();
                this.bos.set(numOfClustersCB, new BufferedOutputStream(new FileOutputStream(f)));
                IOUtils.write(line, (OutputStream)this.bos.get(numOfClustersCB), StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void processSequencesCB_assign(int numOfThreads, List<String> inputFastaFileNames, boolean keepQualities) {
        try {
            int cpus = Runtime.getRuntime().availableProcessors();
            int usingThreads = cpus < numOfThreads ? cpus : numOfThreads;
            System.out.println("cpus=" + cpus);
            System.out.println("using=" + usingThreads);
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            System.out.println(Utils.time() + " START of CB Binning");
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, SequenceProcessor> sequenceProcessors = new HashMap<Integer, SequenceProcessor>();
            if (frm != null) {
                frm.clear();
                frm = null;
            }
            frm = new FastaManager(false, inputFastaFileNames, startSignal, doneSignal);
            pool.execute(frm);
            SequenceProcessor.resetCounters();
            for (int i = 0; i < usingThreads; ++i) {
                SequenceProcessor sp = new SequenceProcessor(this, null, frm, SequenceProcessor.MODE.CB_BINNING, -1, startSignal, doneSignal, new Object[]{keepQualities});
                sequenceProcessors.put(sp.getId(), sp);
                pool.execute(sp);
            }
            doneSignal.await();
            pool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeOutputFiles(int numOfClustersCB) {
        try {
            BufferedOutputStream bo;
            System.out.println("\tClustered reads:");
            for (int i = 0; i < numOfClustersCB; ++i) {
                bo = this.bos.get(i);
                if (bo != null) {
                    bo.flush();
                    bo.close();
                }
                System.out.println("\t\tCB Cluster " + (i + 1) + ": " + this.spc.get(i).get());
            }
            bo = this.bos.get(numOfClustersCB);
            if (bo != null) {
                bo.flush();
                bo.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public synchronized boolean saveSeqToCluster(Sequence sequence, boolean keepQualities) {
        try {
            BufferedOutputStream bo;
            int clusterId = this.sequenceAssignmentsCB.get(sequence.getSequenceId());
            if (clusterId <= 0) {
                return false;
            }
            this.spc.get(clusterId - 1).incrementAndGet();
            String line = sequence.getShortName() + "\t" + clusterId + "\t" + Arrays.stream(this.sequenceDistancesCB.get(sequence.getSequenceId())).mapToObj(String::valueOf).collect(Collectors.joining("\t")) + "\n";
            this.sb.append(line);
            if (this.bos.get(this.bos.size() - 1) != null) {
                IOUtils.write(line, (OutputStream)this.bos.get(this.bos.size() - 1), StandardCharsets.UTF_8);
            }
            if ((bo = this.bos.get(clusterId - 1)) == null) {
                return false;
            }
            if (sequence.getHeader() != null) {
                IOUtils.write(sequence.getHeader(), (OutputStream)bo);
                IOUtils.write("\n", (OutputStream)bo, StandardCharsets.UTF_8);
            }
            if (sequence.getSeq() != null) {
                IOUtils.write(sequence.getSeq(), (OutputStream)bo);
                IOUtils.write("\n", (OutputStream)bo, StandardCharsets.UTF_8);
            }
            if (keepQualities && sequence.getQual() != null) {
                IOUtils.write("+\n", (OutputStream)bo, StandardCharsets.UTF_8);
                IOUtils.write(sequence.getQual(), (OutputStream)bo);
                IOUtils.write("\n", (OutputStream)bo, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        MTxCB MT_CB = new MTxCB();
        try {
            System.out.println(MT_CB.go(args));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    static {
        frm = null;
    }
}

