/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class FixSizedPriorityQueue<E extends Comparable<? super E>> {
    private PriorityQueue<E> queue;
    private int maxSize;

    public FixSizedPriorityQueue(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxSize = maxSize;
        this.queue = new PriorityQueue(maxSize, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return o2.compareTo(o1);
            }
        });
    }

    public void add(E e) {
        if (this.queue.size() < this.maxSize) {
            this.queue.add(e);
        } else {
            Comparable peek = (Comparable)this.queue.peek();
            if (e.compareTo((Comparable)peek) < 0) {
                this.queue.poll();
                this.queue.add(e);
            }
        }
    }

    public List<E> sortedList() {
        ArrayList<E> list = new ArrayList<E>(this.queue);
        Collections.sort(list);
        return list;
    }
}

