/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.seq.test;

import edu.rit.compbio.seq.ProteinDatabase;
import edu.rit.compbio.seq.ProteinSequence;
import java.io.File;
import java.util.HashMap;

public class SummarizeDatabase {
    private SummarizeDatabase() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 3) {
            SummarizeDatabase.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        int n = Integer.parseInt(stringArray[2]);
        ProteinDatabase proteinDatabase = new ProteinDatabase(file, file2);
        HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        for (long i = 0L; i < proteinDatabase.getProteinCount(); ++i) {
            ProteinSequence proteinSequence = proteinDatabase.getProteinSequence(i);
            int n4 = proteinSequence.length();
            n2 = Math.min(n2, n4);
            n3 = Math.max(n3, n4);
            int n5 = n4 / n;
            long l = hashMap.containsKey(n5) ? (Long)hashMap.get(n5) : 0L;
            hashMap.put(n5, ++l);
        }
        System.out.println("Database file: " + file);
        System.out.println("Database index file: " + file2);
        System.out.println("Number of sequences: " + proteinDatabase.getProteinCount());
        System.out.println("Total sequence length: " + proteinDatabase.getDatabaseLength());
        System.out.println("Minimum sequence length: " + n2);
        System.out.println("Maximum sequence length: " + n3);
        System.out.println("Length\tCount");
        int n6 = 0;
        int n7 = n6 * n;
        int n8 = n7 + n - 1;
        while (n7 <= n3) {
            long l = hashMap.containsKey(n6) ? (Long)hashMap.get(n6) : 0L;
            System.out.println(n7 + "-" + n8 + "\t" + l);
            ++n6;
            n7 += n;
            n8 += n;
        }
        proteinDatabase.close();
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.compbio.seq.test.SummarizeDatabase <databasefile> <indexfile> <database>");
        System.err.println("<databasefile> = Protein sequence database file");
        System.err.println("<indexfile> = Protein sequence index file");
        System.err.println("<binsize> = Sequence length histogram bin size");
        System.exit(1);
    }
}

