/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.seq;

import edu.rit.compbio.seq.Sequence;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProteinSequence
extends Sequence {
    public ProteinSequence(String string, String string2) {
        if (string.charAt(0) != '>') {
            throw new IllegalArgumentException("ProteinSequence(): Invalid description");
        }
        this.myDescription = string;
        this.myLength = string2.length();
        this.mySequence = new byte[this.myLength + 1];
        this.mySequence[0] = -1;
        for (int i = 0; i < this.myLength; ++i) {
            char c = string2.charAt(i);
            if ('A' <= c && c <= 'Z') {
                this.mySequence[i + 1] = (byte)(c - 65);
                continue;
            }
            if ('a' <= c && c <= 'z') {
                this.mySequence[i + 1] = (byte)(c - 97);
                continue;
            }
            if (c == '*') {
                this.mySequence[i + 1] = 26;
                continue;
            }
            if (c == '-') {
                this.mySequence[i + 1] = 27;
                continue;
            }
            throw new IllegalArgumentException("ProteinSequence(): Invalid amino acid '" + c + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProteinSequence(File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            this.read(inputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    ProteinSequence(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    private void read(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n != 62) {
            throw new IOException("ProteinSequence(): Invalid description line");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(n);
        while ((n = inputStream.read()) != -1 && n != 13 && n != 10) {
            byteArrayOutputStream.write(n);
        }
        this.myDescription = new String(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(-1);
        while ((n = inputStream.read()) != -1 && n != 62) {
            if (65 <= n && n <= 90) {
                byteArrayOutputStream.write(n - 65);
                continue;
            }
            if (97 <= n && n <= 122) {
                byteArrayOutputStream.write(n - 97);
                continue;
            }
            if (n == 42) {
                byteArrayOutputStream.write(26);
                continue;
            }
            if (n == 45) {
                byteArrayOutputStream.write(27);
                continue;
            }
            if (n == 13 || n == 10) continue;
            throw new IOException("ProteinSequence(): Invalid amino acid '" + (char)n + "'");
        }
        this.mySequence = byteArrayOutputStream.toByteArray();
        this.myLength = this.mySequence.length - 1;
    }

    public char charAt(int n) {
        if (1 > n || n > this.myLength) {
            throw new IndexOutOfBoundsException("ProteinSequence.charAt(): Index " + n + " out of bounds");
        }
        byte by = this.mySequence[n];
        if (0 <= by && by <= 25) {
            return (char)(65 + by);
        }
        if (by == 26) {
            return '*';
        }
        return '-';
    }

    public String toString() {
        return "ProteinSequence(" + this.myDescription + ")";
    }
}

