/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.seq;

import edu.rit.compbio.seq.Alignment;
import edu.rit.compbio.seq.AlignmentPrinter;
import edu.rit.compbio.seq.AlignmentStats;
import edu.rit.compbio.seq.DefaultAlignmentStats;
import edu.rit.compbio.seq.ProteinDatabase;
import edu.rit.compbio.seq.ProteinLocalAlignment;
import edu.rit.compbio.seq.ProteinLocalAlignmentSeq;
import edu.rit.compbio.seq.ProteinSequence;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.CommStatus;
import edu.rit.pj.LongForLoop;
import edu.rit.pj.LongSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.LongRange;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FindProteinHyb2 {
    static Comm world;
    static int size;
    static int rank;
    static File queryfile;
    static File databasefile;
    static File indexfile;
    static LongSchedule thrschedule;
    static double expect;
    static ProteinSequence query;
    static ProteinDatabase database;
    static AlignmentStats stats;
    static List<Alignment> alignmentsFound;

    private FindProteinHyb2() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (3 > stringArray.length || stringArray.length > 5) {
            FindProteinHyb2.usage();
        }
        queryfile = new File(stringArray[0]);
        databasefile = new File(stringArray[1]);
        indexfile = new File(stringArray[2]);
        thrschedule = LongSchedule.fixed();
        if (stringArray.length >= 4) {
            thrschedule = LongSchedule.parse(stringArray[3]);
        }
        expect = 10.0;
        if (stringArray.length >= 5) {
            expect = Double.parseDouble(stringArray[4]);
        }
        query = new ProteinSequence(queryfile);
        database = new ProteinDatabase(databasefile, indexfile);
        stats = new DefaultAlignmentStats(database.getDatabaseLength());
        alignmentsFound = new ArrayList<Alignment>();
        long l2 = System.currentTimeMillis();
        if (rank == 0) {
            new ParallelTeam(2).execute(new ParallelRegion(){

                public void run() throws Exception {
                    this.execute(new ParallelSection(){

                        public void run() throws Exception {
                            FindProteinHyb2.masterSection();
                        }
                    }, new ParallelSection(){

                        public void run() throws Exception {
                            FindProteinHyb2.workerSection();
                        }
                    });
                }
            });
        } else {
            FindProteinHyb2.workerSection();
        }
        long l3 = System.currentTimeMillis();
        if (rank == 0) {
            Collections.sort(alignmentsFound);
            AlignmentPrinter alignmentPrinter = new AlignmentPrinter(System.out, stats);
            System.out.println("Query Description:");
            System.out.println(query.description());
            System.out.println("Length = " + query.length());
            System.out.println();
            System.out.println("                                                                Bit  E-");
            System.out.println("Subject Description                                           Score  Value");
            for (Alignment alignment : alignmentsFound) {
                alignmentPrinter.printSummary(alignment, database.getProteinSequence(alignment.getSubjectId()));
            }
            System.out.println();
            for (Alignment alignment : alignmentsFound) {
                alignmentPrinter.printDetails(alignment, query, database.getProteinSequence(alignment.getSubjectId()));
            }
            System.out.println("Query file: " + queryfile);
            System.out.println("Database file: " + databasefile);
            System.out.println("Database index file: " + indexfile);
            System.out.println("Number of sequences: " + database.getProteinCount());
            System.out.println("Number of matches: " + alignmentsFound.size());
            System.out.println("Query length: " + query.length());
            System.out.println("Database length: " + database.getDatabaseLength());
            stats.print(System.out);
            System.out.println();
            long l4 = System.currentTimeMillis();
            System.out.println(l2 - l + " msec pre");
            System.out.println(l3 - l2 + " msec calc");
            System.out.println(l4 - l3 + " msec post");
            System.out.println(l4 - l + " msec total");
        }
        database.close();
    }

    private static void masterSection() throws IOException {
        LongRange longRange;
        int n;
        long l = System.currentTimeMillis();
        LongSchedule longSchedule = LongSchedule.runtime();
        longSchedule.start(size, new LongRange(0L, database.getProteinCount() - 1L));
        int n2 = size;
        for (n = 0; n < size; ++n) {
            longRange = longSchedule.next(n);
            world.send(n, ObjectBuf.buffer(longRange));
            if (longRange != null) continue;
            --n2;
        }
        while (n2 > 0) {
            ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
            CommStatus commStatus = world.receive(null, objectItemBuf);
            n = commStatus.fromRank;
            longRange = longSchedule.next(n);
            world.send(n, ObjectBuf.buffer(longRange));
            if (longRange == null) {
                --n2;
            }
            alignmentsFound.addAll((Collection)objectItemBuf.item);
        }
    }

    private static void workerSection() throws Exception {
        ParallelTeam parallelTeam = new ParallelTeam();
        int n = parallelTeam.getThreadCount();
        final ProteinLocalAlignment[] proteinLocalAlignmentArray = new ProteinLocalAlignment[n];
        for (int i = 0; i < n; ++i) {
            proteinLocalAlignmentArray[i] = new ProteinLocalAlignmentSeq();
            proteinLocalAlignmentArray[i].setQuerySequence(query, 0L);
        }
        while (true) {
            ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
            world.receive(0, objectItemBuf);
            LongRange longRange = (LongRange)objectItemBuf.item;
            if (longRange == null) break;
            final long l = longRange.lb();
            final long l2 = longRange.ub();
            final ArrayList arrayList = new ArrayList();
            parallelTeam.execute(new ParallelRegion(){

                public void run() throws Exception {
                    this.execute(l, l2, new LongForLoop(){
                        ProteinLocalAlignment thrAligner;
                        List<Alignment> thrAlignments;
                        long p0;
                        long p1;
                        long p2;
                        long p3;
                        long p4;
                        long p5;
                        long p6;
                        long p7;
                        long p8;
                        long p9;
                        long pa;
                        long pb;
                        long pc;
                        long pd;
                        long pe;
                        long pf;

                        public void start() {
                            this.thrAligner = proteinLocalAlignmentArray[this.getThreadIndex()];
                            this.thrAlignments = new ArrayList<Alignment>();
                        }

                        public LongSchedule schedule() {
                            return thrschedule;
                        }

                        public void run(long l, long l2) throws Exception {
                            for (long i = l; i <= l2; ++i) {
                                ProteinSequence proteinSequence = database.getProteinSequence(i);
                                this.thrAligner.setSubjectSequence(proteinSequence, i);
                                Alignment alignment = this.thrAligner.align();
                                if (!(stats.eValue(alignment) <= expect)) continue;
                                this.thrAlignments.add(alignment);
                            }
                        }

                        public void finish() throws Exception {
                            this.region().critical(new ParallelSection(){

                                public void run() {
                                    arrayList.addAll(thrAlignments);
                                }
                            });
                        }
                    });
                }
            });
            world.send(0, ObjectBuf.buffer(arrayList));
        }
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<Kp> -Dpj.nt=<Kt> [-Dpj.schedule=<procschedule>] edu.rit.compbio.seq.FindProteinHyb2 <queryfile> <databasefile> <indexfile> [<thrschedule> [<expect>]]");
        System.err.println("<Kp> = Number of parallel processes");
        System.err.println("<Kt> = Number of parallel threads per process");
        System.err.println("<procschedule> = Load balancing schedule for processes (default: fixed schedule)");
        System.err.println("<queryfile> = Query sequence file");
        System.err.println("<databasefile> = Protein sequence database file");
        System.err.println("<indexfile> = Protein sequence index file");
        System.err.println("<thrschedule> = Load balancing schedule for threads (default: fixed schedule)");
        System.err.println("<expect> = <E>-value threshold (default: 10)");
        System.exit(1);
    }
}

