/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.DnaSequence;
import edu.rit.compbio.phyl.DnaSequenceList;
import edu.rit.compbio.phyl.DnaSequenceTree;
import edu.rit.compbio.phyl.FitchParsimony;
import edu.rit.compbio.phyl.MaximumParsimonyResults;

public class MaximumParsimonyExhSeq {
    private DnaSequenceList seqList;
    private MaximumParsimonyResults results;
    private int L;
    private int N;
    private int C;
    private DnaSequenceTree[] treeStack;
    DnaSequence[][] seqArrayStack;
    private int[] signature;

    public MaximumParsimonyExhSeq(DnaSequenceList dnaSequenceList, MaximumParsimonyResults maximumParsimonyResults) {
        int n;
        this.seqList = dnaSequenceList;
        this.results = maximumParsimonyResults;
        this.L = dnaSequenceList.seq(0).length();
        this.N = dnaSequenceList.length();
        this.C = 2 * this.N - 1;
        this.treeStack = new DnaSequenceTree[this.N];
        for (n = 0; n < this.N; ++n) {
            this.treeStack[n] = new DnaSequenceTree(this.C);
        }
        this.treeStack[0].add(0, dnaSequenceList.seq(0));
        this.seqArrayStack = new DnaSequence[this.N][];
        for (n = 0; n < this.N; ++n) {
            DnaSequence[] dnaSequenceArray = new DnaSequence[n];
            this.seqArrayStack[n] = dnaSequenceArray;
            for (int i = 0; i < n; ++i) {
                dnaSequenceArray[i] = new DnaSequence(this.L);
            }
        }
        this.signature = new int[this.N];
    }

    public void findTrees() {
        int n;
        this.signature[0] = 0;
        for (n = 1; n < this.N; ++n) {
            this.signature[n] = -1;
        }
        n = 1;
        boolean bl = false;
        this.results.clear();
        while (!bl) {
            DnaSequenceTree dnaSequenceTree = this.treeStack[n - 1];
            if (n == this.N) {
                int n2 = dnaSequenceTree.seq(dnaSequenceTree.root()).score();
                this.results.add(this.signature, n2);
                if (--n != 1) continue;
                bl = true;
                continue;
            }
            if (this.signature[n] == 2 * (n - 1)) {
                this.signature[n] = -1;
                if (--n != 1) continue;
                bl = true;
                continue;
            }
            int n3 = n;
            this.signature[n3] = this.signature[n3] + 1;
            DnaSequenceTree dnaSequenceTree2 = this.treeStack[n];
            dnaSequenceTree2.copy(dnaSequenceTree);
            int n4 = dnaSequenceTree2.add(this.signature[n], this.seqList.seq(n));
            FitchParsimony.updateScore(dnaSequenceTree2, n4, this.seqArrayStack[n]);
            ++n;
        }
    }
}

