/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.internal.lang3.Validate;

public class HandlebarsError {
    public final int line;
    public final int column;
    public final String reason;
    public final String evidence;
    public final String filename;
    public final String message;

    public HandlebarsError(String filename, int line, int column, String reason, String evidence, String message) {
        this.filename = Validate.notEmpty(filename, "The file's name is required", new Object[0]);
        Validate.isTrue(line > 0, "The error's line number must be greater than zero", new Object[0]);
        this.line = line;
        Validate.isTrue(column > 0, "The error's column number must be greater than zero", new Object[0]);
        this.column = column;
        this.reason = Validate.notEmpty(reason, "The file's reason is required", new Object[0]);
        this.evidence = Validate.notEmpty(evidence, "The file's evidence is required", new Object[0]);
        this.message = Validate.notEmpty(message, "The file's message is required", new Object[0]);
    }

    public String toString() {
        return this.message;
    }
}

