/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.validation.skeleton.schema;

import io.swagger.v3.oas.models.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.collections4.MapUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.schema.SchemaRecursiveValidatorTemplate;
import org.apache.servicecomb.toolkit.oasv.validation.util.OasObjectValidatorUtils;

public class SchemaPropertiesKeysValidator
extends SchemaRecursiveValidatorTemplate {
    private final Predicate<String> keyPredicate;
    private final Function<String, String> errorFunction;

    public SchemaPropertiesKeysValidator(Predicate<String> keyPredicate, Function<String, String> errorFunction) {
        this.keyPredicate = keyPredicate;
        this.errorFunction = errorFunction;
    }

    @Override
    protected List<OasViolation> validateCurrentSchemaObject(OasValidationContext context, Schema oasObject, OasObjectPropertyLocation location) {
        Map properties = oasObject.getProperties();
        if (MapUtils.isEmpty((Map)properties)) {
            return Collections.emptyList();
        }
        return OasObjectValidatorUtils.doValidateMapPropertyKeys(location, "properties", properties, this.keyPredicate, this.errorFunction);
    }
}

