/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.validation.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasObjectValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.util.OasObjectValidatorUtils;

public abstract class MapPropertyKeysValidator<T>
implements OasObjectValidator<T> {
    private final Predicate<String> keyPredicate;
    private final Function<String, String> errorFunction;

    public MapPropertyKeysValidator(Predicate<String> keyPredicate, Function<String, String> errorFunction) {
        this.keyPredicate = keyPredicate;
        this.errorFunction = errorFunction;
    }

    @Override
    public final List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, T oasObject) {
        if (StringUtils.isNotBlank((CharSequence)this.get$ref(oasObject))) {
            return Collections.emptyList();
        }
        return OasObjectValidatorUtils.doValidateMapPropertyKeys(location, this.getMapPropertyName(), this.getMapProperty(oasObject), this.keyPredicate, this.errorFunction);
    }

    protected abstract String get$ref(T var1);

    protected abstract Map<String, ?> getMapProperty(T var1);

    protected abstract String getMapPropertyName();
}

