/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.diffvalidation.skeleton.responses;

import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffViolation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasObjectDiffValidatorTemplate;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.ResponseDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.ResponsesDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.util.OasObjectDiffValidatorUtils;

public class ResponsesResponsesDiffValidator
extends OasObjectDiffValidatorTemplate<ApiResponses>
implements ResponsesDiffValidator {
    private final List<ResponseDiffValidator> responseValidators;

    public ResponsesResponsesDiffValidator(List<ResponseDiffValidator> responseValidators) {
        this.responseValidators = responseValidators;
    }

    @Override
    public List<OasDiffViolation> validateCompare(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, ApiResponses leftOasObject, OasObjectPropertyLocation rightLocation, ApiResponses rightOasObject) {
        ArrayList<OasDiffViolation> violations = new ArrayList<OasDiffViolation>();
        for (Map.Entry entry : leftOasObject.entrySet()) {
            String leftStatus = (String)entry.getKey();
            ApiResponse leftResponse = (ApiResponse)entry.getValue();
            OasObjectPropertyLocation leftResponseLoc = leftLocation.property(leftStatus, OasObjectType.RESPONSE);
            ApiResponse rightResponse = (ApiResponse)rightOasObject.get((Object)leftStatus);
            if (rightResponse == null) {
                violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, leftResponseLoc, leftResponse, null, null, this.responseValidators));
                continue;
            }
            OasObjectPropertyLocation rightResponseLoc = rightLocation.property(leftStatus, OasObjectType.RESPONSE);
            violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, leftResponseLoc, leftResponse, rightResponseLoc, rightResponse, this.responseValidators));
        }
        for (Map.Entry entry : rightOasObject.entrySet()) {
            String rightStatus = (String)entry.getKey();
            if (leftOasObject.containsKey((Object)rightStatus)) continue;
            ApiResponse rightResponse = (ApiResponse)entry.getValue();
            OasObjectPropertyLocation rightResponseLoc = rightLocation.property(rightStatus, OasObjectType.RESPONSE);
            violations.addAll(OasObjectDiffValidatorUtils.doDiffValidateProperty(context, null, null, rightResponseLoc, rightResponse, this.responseValidators));
        }
        return violations;
    }
}

