/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.annotations.Api;
import io.swagger.models.Swagger;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.servicecomb.swagger.generator.core.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.springframework.util.StringUtils;

public class ApiProcessor
implements ClassAnnotationProcessor {
    @Override
    public void process(Object annotation, SwaggerGenerator swaggerGenerator) {
        Api api = (Api)annotation;
        this.setTags(api, swaggerGenerator);
        this.processConsumes(api, swaggerGenerator.getSwagger());
        this.processProduces(api, swaggerGenerator.getSwagger());
    }

    private void processProduces(Api api, Swagger swagger) {
        List<String> validProducesList = this.getValidStringList(api.produces());
        if (this.isBlank(swagger.getProduces()) && !validProducesList.isEmpty()) {
            swagger.setProduces(validProducesList);
        }
    }

    private void processConsumes(Api api, Swagger swagger) {
        List<String> validConsumesList = this.getValidStringList(api.consumes());
        if (this.isBlank(swagger.getConsumes()) && !validConsumesList.isEmpty()) {
            swagger.setConsumes(validConsumesList);
        }
    }

    private List<String> getValidStringList(String rawString) {
        return Stream.of(rawString.split(",")).filter(s -> !StringUtils.isEmpty((Object)s)).map(String::trim).collect(Collectors.toList());
    }

    private boolean isBlank(List<String> stringList) {
        boolean isEmpty;
        boolean bl = isEmpty = null == stringList || stringList.isEmpty();
        if (isEmpty) {
            return true;
        }
        for (String s : stringList) {
            if (!StringUtils.isEmpty((Object)s)) continue;
            return true;
        }
        return false;
    }

    private void setTags(Api api, SwaggerGenerator swaggerGenerator) {
        String[] tags;
        for (String tagName : tags = api.tags()) {
            if (StringUtils.isEmpty((Object)tagName)) continue;
            swaggerGenerator.addDefaultTag(tagName);
        }
    }
}

