/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.docgen;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.servicecomb.toolkit.DocGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractsSwaggerUIGenerator
implements DocGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContractsSwaggerUIGenerator.class);
    private static Pattern variablePattern = Pattern.compile("(?<=\\{\\{)[a-zA-Z0-9_-]*(?=\\}\\})");
    private static final String DOC_SUFFIX = ".html";
    private OpenAPI contractContent;
    private String outputPath = ".";

    public boolean canProcess(String type) {
        return "default".equals(type) || "swagger-ui".equals(type);
    }

    public void configure(Map<String, Object> config) {
        this.contractContent = (OpenAPI)config.get("contractContent");
        this.outputPath = (String)config.get("outputPath");
    }

    private boolean checkConfig() {
        return this.contractContent != null;
    }

    public void generate() {
        if (!this.checkConfig()) {
            throw new IllegalArgumentException("Cannot found configuration");
        }
        String swaggerUiHtml = null;
        try {
            String swaggerJson = Json.mapper().writeValueAsString((Object)this.contractContent);
            swaggerUiHtml = this.renderHtml(this.getSwaggerUiHtml(), Collections.singletonMap("spec", swaggerJson));
            this.outputPath = this.correctPath(this.outputPath);
            Path outputFile = Paths.get(this.outputPath, new String[0]);
            if (!Files.exists(outputFile, new LinkOption[0])) {
                if (outputFile.getParent() != null) {
                    Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                }
                Files.createFile(outputFile, new FileAttribute[0]);
            }
            Files.write(outputFile, swaggerUiHtml.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String correctPath(String filepath) {
        if (!filepath.endsWith(DOC_SUFFIX)) {
            return filepath + DOC_SUFFIX;
        }
        return filepath;
    }

    private String renderHtml(String html, Map<String, String> args) {
        Matcher variableMatcher = variablePattern.matcher(html);
        while (variableMatcher.find()) {
            String variableStr = variableMatcher.group();
            String variableValue = args.get(variableStr);
            html = html.replace("{{" + variableStr + "}}", variableValue);
        }
        return html;
    }

    private String getSwaggerUiHtml() throws IOException {
        int len;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("webroot/swagger-ui.html");
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            bout.write(buf, 0, len);
        }
        bout.close();
        in.close();
        return new String(bout.toByteArray());
    }
}

