/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;

public class JavaJAXRSCXFCDIServerCodegen
extends JavaJAXRSSpecServerCodegen
implements BeanValidationFeatures {
    public JavaJAXRSCXFCDIServerCodegen() {
        this.outputFolder = "generated-code/JavaJaxRS-CXF-CDI";
        this.artifactId = "openapi-jaxrs-cxf-cdi-server";
        this.sourceFolder = "src/gen/java";
        this.useBeanValidation = true;
        this.updateOption("sourceFolder", this.getSourceFolder());
        this.updateOption("artifactId", this.getArtifactId());
        this.apiTemplateFiles.put("apiService.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        this.typeMapping.put("DateTime", "java.util.Date");
        this.embeddedTemplateDir = this.templateDir = "JavaJaxRS" + File.separator + "cxf-cdi";
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations", this.useBeanValidation));
    }

    @Override
    public String getName() {
        return "jaxrs-cxf-cdi";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        this.supportingFiles.clear();
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("RestApplication.mustache", (this.implFolder + '/' + this.invokerPackage).replace(".", "/"), "RestApplication.java"));
        this.writeOptional(this.outputFolder, new SupportingFile("beans.mustache", "src/main/webapp/WEB-INF", "beans.xml"));
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.add("JsonProperty");
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS Server according to JAXRS 2.0 specification, assuming an Apache CXF runtime and a Java EE runtime with CDI enabled.";
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }
}

