/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.serviceregistry.api.PropertyExtended;
import org.apache.servicecomb.serviceregistry.config.ConfigurePropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractPropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPropertiesLoader.class);
    protected static final String PROPERTIES = ".properties";
    protected static final String EXTENDED_CLASS_FOR_COMPATIBLE = ".propertyExtentedClass";
    protected static final String EXTENDED_CLASS = ".propertyExtendedClass";

    protected abstract String getConfigOptionPrefix();

    public Map<String, String> loadProperties(Configuration configuration) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        this.loadPropertiesFromConfigMap(configuration, propertiesMap);
        this.loadPropertiesFromExtendedClass(configuration, propertiesMap);
        return propertiesMap;
    }

    protected void loadPropertiesFromConfigMap(Configuration configuration, Map<String, String> propertiesMap) {
        String configKeyPrefix = AbstractPropertiesLoader.mergeStrings(this.getConfigOptionPrefix(), PROPERTIES);
        propertiesMap.putAll(ConfigurePropertyUtils.getPropertiesWithPrefix(configuration, configKeyPrefix));
    }

    protected void loadPropertiesFromExtendedClass(Configuration configuration, Map<String, String> propertiesMap) {
        String extendedPropertyClass = this.readExtendedPropertyClassName(configuration, EXTENDED_CLASS);
        if (StringUtils.isEmpty((Object)extendedPropertyClass)) {
            extendedPropertyClass = this.readExtendedPropertyClassName(configuration, EXTENDED_CLASS_FOR_COMPATIBLE);
            if (StringUtils.isEmpty((Object)extendedPropertyClass)) {
                return;
            }
            LOGGER.warn("The property `{}` is deprecated and will be removed soon, please use the new property `{}`.", (Object)EXTENDED_CLASS_FOR_COMPATIBLE, (Object)EXTENDED_CLASS);
        }
        try {
            Class<?> classExternalProperty = Class.forName(extendedPropertyClass);
            if (!PropertyExtended.class.isAssignableFrom(classExternalProperty)) {
                String errMsg = String.format("Define propertyExtendedClass %s in yaml, but not implement the interface PropertyExtended.", extendedPropertyClass);
                LOGGER.error(errMsg);
                throw new Error(errMsg);
            }
            PropertyExtended instance = (PropertyExtended)classExternalProperty.newInstance();
            Map<String, String> extendedPropertiesMap = instance.getExtendedProperties();
            if (extendedPropertiesMap != null && !extendedPropertiesMap.isEmpty()) {
                propertiesMap.putAll(extendedPropertiesMap);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            String errMsg = "Fail to create instance of class: " + extendedPropertyClass;
            LOGGER.error(errMsg);
            throw new Error(errMsg, e);
        }
    }

    private String readExtendedPropertyClassName(Configuration configuration, String keyName) {
        String configKey = AbstractPropertiesLoader.mergeStrings(this.getConfigOptionPrefix(), keyName);
        return configuration.getString(configKey, "");
    }

    protected static String mergeStrings(String ... strArr) {
        return String.join((CharSequence)"", strArr);
    }
}

