/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.validator.operation;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OperationValidator;

public class OperationTagsReferenceValidator
implements OperationValidator {
    public static final String CONFIG_KEY = "operation.tags.element.must_reference_root_tags";
    public static final String ERROR = "is not defined in $.tags";

    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, Operation oasObject) {
        List tags = oasObject.getTags();
        if (CollectionUtils.isEmpty((Collection)tags)) {
            return Collections.emptyList();
        }
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        Set<String> globalTagNames = this.getGlobalTagNames(context.getOpenAPI());
        for (int i = 0; i < tags.size(); ++i) {
            String tagName = (String)tags.get(i);
            if (globalTagNames.contains(tagName)) continue;
            violations.add(new OasViolation(location.property("tags[" + i + "]"), ERROR));
        }
        return violations;
    }

    public Set<String> getGlobalTagNames(OpenAPI openAPI) {
        if (CollectionUtils.isEmpty((Collection)openAPI.getTags())) {
            return Collections.emptySet();
        }
        return openAPI.getTags().stream().map(Tag::getName).collect(Collectors.toSet());
    }
}

